/*
 * Copyright (C) 2001  CodeFactory AB
 * Copyright (C) 2001  Richard Hult
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult <rhult@codefactory.se>
 */
#ifndef __ARROW_ITEM_H__
#define __ARROW_ITEM_H__

#include <gtk/gtk.h>
#include <libgnomeui/gnome-canvas.h>
#include <libgnomeui/gnome-canvas-line.h>

#include "network-item.h"

#define TYPE_ARROW_ITEM			(arrow_item_get_type ())
#define ARROW_ITEM(obj)			(GTK_CHECK_CAST ((obj), TYPE_ARROW_ITEM, ArrowItem))
#define ARROW_ITEM_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), TYPE_ARROW_ITEM, ArrowItemClass))
#define IS_ARROW_ITEM(obj)		(GTK_CHECK_TYPE ((obj), TYPE_ARROW_ITEM))
#define IS_ARROW_ITEM_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((obj), TYPE_ARROW_ITEM))

typedef struct _ArrowItem       ArrowItem;
typedef struct _ArrowItemClass  ArrowItemClass;

struct _ArrowItem {
	GnomeCanvasLine  parent;

	NetworkItem     *predecessor;
	NetworkItem     *item;
};

struct _ArrowItemClass {
	GnomeCanvasLineClass parent_class;
};

GtkType    arrow_item_get_type (void);
ArrowItem *arrow_item_new      (NetworkItem *item, NetworkItem *predecessor);


#endif /* __ARROW_ITEM_H__ */

