/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2000 CodeFactory AB
 * Copyright (C) 2000 Richard Hult <rhult@codefactory.se>
 * Copyright (C) 2001 Anders Carlsson <andersca@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */

#ifndef __RESOURCE_COMPONENT_H__
#define __RESOURCE_COMPONENT_H__

#include <gtk/gtktypeutils.h>
#include "client/components/shell-component/shell-component.h"

#define RESOURCE_COMPONENT_TYPE        (resource_component_get_type ())
#define RESOURCE_COMPONENT(o)          (GTK_CHECK_CAST ((o), RESOURCE_COMPONENT_TYPE, ResourceComponent))
#define RESOURCE_COMPONENT_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), RESOURCE_COMPONENT_TYPE, ResourceComponentClass))
#define IS_RESOURCE_COMPONENT(o)       (GTK_CHECK_TYPE ((o), RESOURCE_COMPONENT_TYPE))
#define IS_RESOURCE_COMPONENT_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), RESOURCE_COMPONENT_TYPE))

typedef struct _ResourceComponentPriv ResourceComponentPriv;

typedef struct {
	ShellComponent         parent;
	ResourceComponentPriv *priv;
} ResourceComponent;

typedef struct {
	ShellComponentClass    parent_class;
} ResourceComponentClass;


GtkType  resource_component_get_type  (void);


#endif /* _RESOURCE_COMPONENT_H_ */

