/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 CodeFactory AB
 * Copyright (C) 2001 Mikael Hallendal <micke@codefactory.se>
 * Copyright (C) 2001 Richard Hult     <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Mikael Hallendal
 */

#ifndef __TASK_DIALOG_H__
#define __TASK_DIALOG_H__

#include <bonobo/bonobo-xobject.h>
#include "libmrproject/GNOME_MrProject.h"

#define TASK_DIALOG_TYPE        (task_dialog_get_type ())
#define TASK_DIALOG(o)          (GTK_CHECK_CAST ((o), TASK_DIALOG_TYPE, TaskDialog))
#define TASK_DIALOG_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), TASK_DIALOG_TYPE, TaskDialogClass))
#define IS_TASK_DIALOG(o)       (GTK_CHECK_TYPE ((o), TASK_DIALOG_TYPE))
#define IS_TASK_DIALOG_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), TASK_DIALOG_TYPE))

#define DEFAULT_UNITS 100

typedef struct _TaskDialogPriv TaskDialogPriv;

typedef struct {
	BonoboXObject   parent;
	TaskDialogPriv *priv;
} TaskDialog;

typedef struct {
	BonoboXObjectClass                  parent_class;
	POA_GNOME_MrProject_TaskDialog__epv epv;
} TaskDialogClass;

GtkType task_dialog_get_type (void);

#endif /* __TASK_DIALOG_H__ */

