/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2000 CodeFactory AB
 * Copyright (C) 2000 Richard Hult <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */

#ifndef __M_CELL_FILTER_H__
#define __M_CELL_FILTER_H__

#include <glib.h>
#include <gtk/gtktypeutils.h>
#include <gal/e-table/e-table-model.h>
#include <gal/e-table/e-cell.h>
#include <gal/e-table/e-cell-text.h>

#define M_CELL_FILTER_TYPE        (m_cell_filter_get_type ())
#define M_CELL_FILTER(o)          (GTK_CHECK_CAST ((o), M_CELL_FILTER_TYPE, MCellFilter))
#define M_CELL_FILTER_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), M_CELL_FILTER_TYPE, MCellFilterClass))

typedef gchar *(*MCellFilterGetFunc) (gconstpointer  value);
typedef void (*MCellFilterFreeFunc)  (gchar         *text);

typedef struct {
	ECellText parent;
	MCellFilterGetFunc get_func;
	MCellFilterFreeFunc free_func;
} MCellFilter;

typedef struct {
	ECellTextClass parent_class;
} MCellFilterClass;

GtkType    m_cell_filter_get_type (void);
ECell     *m_cell_filter_new      (const char          *fontname,
				   GtkJustification     justify,
				   MCellFilterGetFunc   get_func,
				   MCellFilterFreeFunc  free_func);


#endif /* __M_CELL_FILTER_H__ */
