/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 Anders Carlsson <andersca@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Anders Carlsson
 */

#ifndef __TEMPLATE_DIALOG_H__
#define __TEMPLATE_DIALOG_H__

#include <glib.h>
#include <gtk/gtktypeutils.h>
#include <gtk/gtkwidget.h>
#include <bonobo.h>
#include <bonobo/bonobo-win.h>

#define TEMPLATE_TYPE_DIALOG        (template_dialog_get_type())
#define TEMPLATE_DIALOG(o)          (GTK_CHECK_CAST((o), TEMPLATE_TYPE_DIALOG, TemplateDialog))
#define TEMPLATE_DIALOG_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), TEMPLATE_TYPE_DIALOG, TemplateDialogClass))
#define TEMPLATE_IS_DIALOG(o)       (GTK_CHECK_TYPE((o), TEMPLATE_TYPE_DIALOG))
#define TEMPLATE_IS_DIALOG_CLASS(k) (GTK_CHECK_CLASS_TYPE((k), TEMPLATE_TYPE_DIALOG))

typedef struct _TemplateDialog        TemplateDialog;
typedef struct _TemplateDialogClass   TemplateDialogClass;
typedef struct _TemplateDialogPriv    TemplateDialogPriv;

struct _TemplateDialog
{
	GnomeDialog	   parent_instance;
	TemplateDialogPriv *priv;
};

struct _TemplateDialogClass
{
	GnomeDialogClass parent_class;
};

GtkType    template_dialog_get_type (void);
GtkWidget *template_dialog_new	   (void);
gint template_dialog_run (TemplateDialog *dialog, gchar **filename);

#endif /* __TEMPLATE_DIALOG_H__ */

