/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) Almer S. Tigelaar <almer@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Based on GnumericHScrollbar by Almer S. Tigelaar, tweaked by
 * Richard Hult <rhult@codefactory.se>
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtkhscrollbar.h>
#include <gtk/gtksignal.h>
#include "util/type-utils.h"
#include "mr-hscrollbar.h"

static void mr_hscrollbar_init (MrHScrollbar *hs);
static void mr_hscrollbar_class_init (MrHScrollbarClass *klass);


GNOME_CLASS_BOILERPLATE (MrHScrollbar, mr_hscrollbar,
			 GtkHScrollbar, gtk_hscrollbar);

enum {
	EXPAND,
	LAST_SIGNAL
};

static gint signals[LAST_SIGNAL] = { 0, };

static gint
button_press (GtkWidget *widget, GdkEventButton *event)
{
	GtkRange      *range;
	GtkAdjustment *adj;
	gint           ret;
	gfloat         old_value;
	
	range = GTK_RANGE (widget);
	adj = range->adjustment;

	old_value = adj->value;
	
	ret = GTK_WIDGET_CLASS (parent_class)->button_press_event (widget,
								   event);

	if (event->window == range->step_forw) {
		if (adj->value == (adj->upper-adj->page_size) && adj->value == old_value) {
			gtk_signal_emit (GTK_OBJECT (widget),
					 signals[EXPAND],
					 MR_SCROLL_STEP_FORWARD);
		}
	}
	else if (event->window == range->step_back) {
		if (adj->value == adj->lower && adj->value == old_value) {
			gtk_signal_emit (GTK_OBJECT (widget),
					 signals[EXPAND],
					 MR_SCROLL_STEP_BACKWARD);
		}
	}

	return ret;
}
	
static gint
mr_hscrollbar_timer (GtkRange *range)
{
	gint         ret;
	MrScrollType type;
	
	switch (range->scroll_type) {
	case GTK_SCROLL_STEP_FORWARD:
		type = MR_SCROLL_CONT_FORWARD;
		break;
	case GTK_SCROLL_STEP_BACKWARD:
		type = MR_SCROLL_CONT_BACKWARD;
		break;
	default:
		return 1;
	}

	gtk_signal_emit (GTK_OBJECT (range),
			 signals[EXPAND],
			 type);

	range->need_timer = TRUE;
	
	ret = GTK_RANGE_CLASS (parent_class)->timer (range);

	return ret;
}

static void
mr_hscrollbar_init (MrHScrollbar *hs)
{
}

static void
mr_hscrollbar_class_init (MrHScrollbarClass *klass)
{
	GtkObjectClass *object_class;
	GtkWidgetClass *widget_class;
	GtkRangeClass  *range_class;

	widget_class = (GtkWidgetClass *) klass;
	range_class = (GtkRangeClass *) klass;
	object_class = (GtkObjectClass *) klass;
	
	range_class->timer = mr_hscrollbar_timer;
	widget_class->button_press_event = button_press;

	signals [EXPAND] =
		gtk_signal_new ("expand",
				GTK_RUN_LAST,
				object_class->type,
				0,
				gtk_marshal_NONE__ENUM,
				GTK_TYPE_NONE, 1, GTK_TYPE_ENUM);

	gtk_object_class_add_signals (object_class, signals, LAST_SIGNAL);
}

GtkWidget *
mr_hscrollbar_new (GtkAdjustment *adjustment)
{
	GtkWidget *hs;
	
	hs = gtk_widget_new (MR_HSCROLLBAR_TYPE,
			     "adjustment", adjustment,
			     NULL);

	return hs;
}



