/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 CodeFactory AB
 * Copyright (C) 2001 Richard Hult <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */


#ifndef __FILE_TASK_MANAGER_H__
#define __FILE_TASK_MANAGER_H__

#include <bonobo/bonobo-event-source.h>
#include "libmrproject/GNOME_MrProject.h"
#include "project-engine/task-manager.h"
#include "project-engine/task-model.h"

#define TYPE_FILE_TASK_MANAGER			(file_task_manager_get_type ())
#define FILE_TASK_MANAGER(obj)			(GTK_CHECK_CAST ((obj), TYPE_FILE_TASK_MANAGER, FileTaskManager))
#define FILE_TASK_MANAGER_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), TYPE_FILE_TASK_MANAGER, FileTaskManagerClass))
#define IS_FILE_TASK_MANAGER(obj)		(GTK_CHECK_TYPE ((obj), TYPE_FILE_TASK_MANAGER))
#define IS_FILE_TASK_MANAGER_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((obj), TYPE_FILE_TASK_MANAGER))

typedef struct _FileTaskManager      FileTaskManager;
typedef struct _FileTaskManagerClass FileTaskManagerClass;
typedef struct _FileTaskManagerPriv  FileTaskManagerPriv;

struct _FileTaskManager
{
	TaskManager          parent;
	FileTaskManagerPriv *priv;
};

struct _FileTaskManagerClass
{
	TaskManagerClass parent_class;
};

GtkType      file_task_manager_get_type (void);
TaskManager *file_task_manager_new (BonoboEventSource *event_source);


#endif /* __FILE_TASK_MANAGER_H__ */

