/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2000 CodeFactory AB
 * Copyright (C) 2000 Richard Hult <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */

#ifndef __TYPE_UTILS_H__
#define __TYPE_UTILS_H__

#include <glib.h>
#include <gtk/gtkobject.h>
#include <gtk/gtktypeutils.h>

/* Define the boilerplate type stuff to reduce typos and code size.  Defines
 * the get_type method and the parent_class static variable. */
#define GNOME_CLASS_BOILERPLATE(type, type_as_function,			\
				parent_type, parent_type_as_function)	\
static parent_type ## Class *parent_class = NULL;				\
GtkType									\
type_as_function ## _get_type (void)					\
{									\
	static GtkType object_type = 0;					\
	if (object_type == 0) {						\
		GtkType type_of_parent;					\
		static const GtkTypeInfo object_info = {		\
			#type,						\
			sizeof (type),					\
			sizeof (type ## Class),				\
			(GtkClassInitFunc) type_as_function ## _class_init, \
			(GtkObjectInitFunc) type_as_function ## _init,	\
			/* reserved_1 */ NULL,				\
			/* reserved_2 */ NULL,				\
			(GtkClassInitFunc) NULL				\
		};							\
		type_of_parent = parent_type_as_function ## _get_type (); \
		object_type = gtk_type_unique (type_of_parent, &object_info); \
		parent_class = gtk_type_class (type_of_parent);		\
	}								\
	return object_type;						\
}

/* Just call the parent handler.  This assumes that there is a variable
 * named parent_class that points to the (duh!) parent class */
#define GNOME_CALL_PARENT_HANDLER(parent_class_cast, name, args)	\
	((parent_class_cast(parent_class)->name != NULL) ?		\
	 parent_class_cast(parent_class)->name args : 0)

#define ASSERT_STRUCT_SIZE(struct_name,struct_size) \
         G_STMT_START{ \
                if (sizeof (struct_name) != struct_size)  \
	                g_error ("Size of struct changed, update %s, %s: row %d\n", \
		                __FUNCTION__, __FILE__, __LINE__); \
         }G_STMT_END
 

#endif /* __TYPE_UTILS_H__ */

