/* Time-stamp: <2006-10-09 10:57:12 poser> */

/*
 * Copyright (C) 1993-2006 William J. Poser (billposer@alum.mit.edu).
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"
#include "compdefs.h"

#include <stdlib.h>
#include <stdio.h>
#ifdef LOCALE_GETTEXT
#include <libintl.h>
#define _(x) gettext(x)
#else
#define _(x) (x)
#endif
#include "limits.h"

static char rcsid[] = "$Id: info.c,v 1.16 2005/09/03 23:32:05 poser Exp poser $";

#ifdef HAVE_GETOPT_LONG
void
PrintGeneralFlags(FILE *fp)
{
  fprintf(fp,_("General options:\n"));
  fprintf(fp,_("\t-h,--help\t\tPrint usage message\n"));
  fprintf(fp,_("\t-v,--version\t\tPrint version message\n"));
  fprintf(fp,_("\t-D,--defaults\t\tList defaults\n"));
  fprintf(fp,_("\t-F,--general-options\tList general command line flags\n"));
  fprintf(fp,_("\t-G,--gnu-equivalences\tList GNU equivalences\n"));
  fprintf(fp,_("\t-K,--key-specific-options\n\t\t\t\tList key-specific command line flags\n"));
  fprintf(fp,_("\t-L,--limits\t\tList limits\n"));
  fputc('\n',fp);
  fprintf(fp,_("\tThe following two options must precede any sort order specifications.\n"));
  fprintf(fp,_("\t-B,--BMP\t\tNo characters fall outside the BMP.\n"));
  fprintf(fp,_("\t-p,--reserve-private-use-area\n\t\t\t\tDo not use the Private Use areas.\n"));
  fputc('\n',fp);
  fprintf(fp,_("\t-b,--block\t\tA record is terminated by two or more\n\t\t\t\tend-of-line characters.\n"));
  fprintf(fp,_("\t-l,--line\t\tA record consists of a single line\n"));
  fprintf(fp,_("\t-r,--record-separator <separator>\n\t\t\t\tA record is terminated by separator character\n"));
  fprintf(fp,_("\t-O,--fixed-size-record-size <bytes>\n\t\t\t\tA record consists of the specified number of bytes\n"));
	
  fputc('\n',fp);
  fprintf(fp,_("\t-d,--field-separators <character>+\n\t\t\t\tFields are delimited by the named character(s)\n"));
  fprintf(fp,_("\t-w,--whole-record\tSort on the entire text of the record\n"));
  fputc('\n',fp);	
  fprintf(fp,_("\t-a,--algorithm <algorithm>\n\t\t\t\tI(nsertionSort)\n"));
  fprintf(fp,_("\t\t\t\tM(ergeSort) \n"));
  fprintf(fp,_("\t\t\t\tQ(uickSort) \n"));
  fprintf(fp,_("\t\t\t\tS(hellSort)\n"));
  fprintf(fp,_("\t-M,--initial-maximum-records <records>\n\t\t\t\tSet initial maximum number of records \n"));
  fprintf(fp,_("\t-m,--line-end-carriage-return\n\t\t\t\tEnd of line is marked by Carriage Return (0x0D)\n"));
  fprintf(fp,_("\t-I,--invert-globally\tInvert sense of comparisons globally\n"));
  fprintf(fp,_("\t-Q,--check-only\t\tCheck whether input is sorted. Generate no output.\n"));
  fprintf(fp,_("\t-q,--quiet\t\tBe quiet - do not chat while working\n"));
  fputc('\n',fp);				
}

void PrintKeySpecificFlags(FILE *fp)
{
  fprintf(fp,_("Key specific options:\n"));
  fprintf(fp,_("\t-e,--character-range <m,n>\n\t\t\t\tSort on characters m through n\n"));
  fprintf(fp,_("\t-n,--position <POS>(,<POS>)\n\t\t\t\tSort on the position or range of positions\n"));
  fprintf(fp,_("\t-t,--tag <tag regexp>\tSort on the field with the specified tag\n"));
  fprintf(fp,_("\t-o,--optional <comparison>\n\t\t\t\tOptional: if absent compare as (<,=,>)\n"));
  fprintf(fp,_("\t-C,--fold-case\t\tFold case\n"));
  fprintf(fp,_("\t-z,--fold-case-turkic\tFold case with additional Turkic conversions\n"));
  fprintf(fp,_("\t-c,--comparison-type <comparison type>\n\t\t\t\tl(exicographic)\n"));
  fprintf(fp,_("\t\t\t\tN(umeric string)\n"));
  fprintf(fp,_("\t\t\t\tn(umeric)\n"));
  fprintf(fp,_("\t\t\t\th(ybrid)\n"));
  fprintf(fp,_("\t\t\t\ts(ize)\n"));
  fprintf(fp,_("\t\t\t\ta(ngle) - ddd:mm:ss(.sss) or ddd mm ss(.sss)\n"));
  fprintf(fp,_("\t\t\t\td(ate)\n"));
  fprintf(fp,_("\t\t\t\tm(onth)\n"));
  fprintf(fp,_("\t\t\t\tt(ime)\n"));
  fprintf(fp,_("\t\t\t\ti(so8601 date/time)\n"));
  fprintf(fp,_("\t\t\t\tr(andom)\n"));
  fprintf(fp,_("\t-f,--date-format <date format>\n\t\t\t\tPermutation of ymd with separators\n"));
  fprintf(fp,_("\t-W,--sort-order-file-separators <file name>\n\t\t\t\tRead separators for sort order file.\n"));
  fprintf(fp,_("\t-S,--substitution-file <file name>\n\t\t\t\tRead substitutions from named file\n"));
#ifdef LOCALE_SORT_ORDER
  fprintf(fp,_("\t-s,--sort-order\t<file name|locale name|\"current\">\n"));
#else
  fprintf(fp,_("\t-s,--sort-order-file <file name>\n\t\t\t\tRead the sort order definition from <file name>.\n"));
#endif
  fprintf(fp,_("\t-T,--transformations <(d)(e)(s)>\n\t\t\t\tApply the specified transformations\n"));
  fprintf(fp,_("\t\t\t\t\td = strip diacritics\n\t\t\t\t\te = strip enclosures\n\t\t\t\t\ts = simplify style\n"));
  fprintf(fp,_("\t-x,--exclusion-file <file name>\n\t\t\t\tRead exclusions from named file\n"));
  fprintf(fp,_("\t-X,--exclude-characters <exclusions>\n\t\t\t\tExclude specified characters\n"));
  fprintf(fp,_("\t-i,--invert-locally\tInvert sense of comparisons\n"));
  fprintf(fp,_("\t-R,--reverse-key\tReverse characters of key\n"));
  fputc('\n',fp);				
}

void
PrintGNUEquivalences(FILE *fp)
{
  fprintf(fp,"GNU sort\t\t\t\tmsort\n");
  fprintf(fp,"-c,--check\t\t\t\t-Q,--check-only\n");
  fprintf(fp,"-f,--ignore-case\t\t\t-C,--fold-case\n");
  fprintf(fp,"-g,--general-numeric-sort\t\t-c n,--comparison-type n\n");
  fprintf(fp,"-M,--month-sort\t\t\t\t-c m,--comparison-type m\n");
  fprintf(fp,"-n,--numeric-sort\t\t\t-c N,--comparison-type N\n");
  fprintf(fp,"-r,--reverse\t\t\t\t-i,--invert-locally\n");
  fprintf(fp,"-s,--stable\t\t\t\t-a I,--algorithm I\n");
  fprintf(fp,"           \t\t\t\t-a M,--algorithm M\n");
  fprintf(fp,"-t <fs>,--field-separator <fs>\t\t-d <fs>,--field-separators <fs>\n");
  fprintf(fp,"-z,--zero-terminated\t\t\t-r \\000,--record-separator \\000\n");
  fputc('\n',fp);				
}
#else

void
PrintGeneralFlags(FILE *fp)
{
  fprintf(fp,_("General options:\n"));
  fprintf(fp,_("\t-h                    Print usage message\n"));
  fprintf(fp,_("\t-v                    Print version message\n"));
  fprintf(fp,_("\t-D                    List defaults\n"));
  fprintf(fp,_("\t-F                    List general command line flags\n"));
  fprintf(fp,_("\t-G                    List GNU equivalences\n"));
  fprintf(fp,_("\t-K                    List key-specific command line flags\n"));
  fprintf(fp,_("\t-L                    List limits\n"));
  fputc('\n',fp);
  fprintf(fp,_("\tThe following two options must precede any sort order specifications.\n"));
  fprintf(fp,_("\t-B                    No characters fall outside the BMP.\n"));
  fprintf(fp,_("\t-p                    Do not use the Private Use areas.\n"));
  fputc('\n',fp);
  fprintf(fp,_("\t-b                    A record is terminated by two or more\n\t\t\t\tend-of-line characters.\n"));
  fprintf(fp,_("\t-l                    A record consists of a single line\n"));
  fprintf(fp,_("\t-r <separator>        A record is terminated by separator character\n"));
  fprintf(fp,_("\t-O <bytes>            A record consists of the specified number of bytes\n"));
	
  fputc('\n',fp);
  fprintf(fp,_("\t-d <character>+       Fields are delimited by the named character(s)\n"));
  fprintf(fp,_("\t-w                    Sort on the entire text of the record\n"));
  fputc('\n',fp);	
  fprintf(fp,_("\t-a <algorithm>        I(nsertionSort)\n"));
  fprintf(fp,_("\t                      M(ergeSort) \n"));
  fprintf(fp,_("\t                      Q(uickSort) \n"));
  fprintf(fp,_("\t                      S(hellSort)\n"));
  fprintf(fp,_("\t-M <records>          Set initial maximum number of records \n"));
  fprintf(fp,_("\t-m                    End of line is marked by Carriage Return (0x0D)\n"));
  fprintf(fp,_("\t-I                    Invert sense of comparisons globally\n"));
  fprintf(fp,_("\t-q                    Be quiet - do not chat while working\n"));
  fputc('\n',fp);				
}

PrintKeySpecificFlags(FILE *fp)
{
  fprintf(fp,_("Key specific options:\n"));
  fprintf(fp,_("\t-e <m,n>              Sort on characters m through n\n"));
  fprintf(fp,_("\t-n <POS>(,<POS>)      Sort on the position or range of positions\n"));
  fprintf(fp,_("\t-t <tag regexp>       Sort on the field with the specified tag\n"));
  fprintf(fp,_("\t-o <comparison>       Optional: if absent compare as (<,=,>)\n"));
  fprintf(fp,_("\t-C                    Fold case\n"));
  fprintf(fp,_("\t-c <key type>         l(exicographic)\n"));
  fprintf(fp,_("\t                      N(umeric string)\n"));
  fprintf(fp,_("\t                      n(umeric)\n"));
  fprintf(fp,_("\t                      h(ybrid)\n"));
  fprintf(fp,_("\t                      s(ize)\n"));
  fprintf(fp,_("\t                      a(ngle) - ddd:mm:ss(.sss) or ddd mm ss(.sss)\n"));
  fprintf(fp,_("\t                      d(ate)\n"));
  fprintf(fp,_("\t                      t(ime)\n"));
  fprintf(fp,_("\t                      i(so8601 date/time)\n"));
  fprintf(fp,_("\t                      r(andom)\n"));
  fprintf(fp,_("\t-f <date format>      Permutation of ymd with separators\n"));
  fprintf(fp,_("\t-W <file name>        Read separators for sort order file.\n"));
  fprintf(fp,_("\t-S <file name>        Read substitutions from named file\n"));
#ifdef LOCALE_SORT_ORDER
  fprintf(fp,_("\t-s <string>\n"));
  fprintf(fp,_("\t   If string is a file name, the sort order is read from the file.\n"));
  fprintf(fp,_("\t   If string is a locale name, the sort order for the locale is used.\n"));
  fprintf(fp,_("\t   If string is \"locale\", the sort order for the current locale is used.\n"));
#else
  fprintf(fp,_("\t-s <file name>        Read the sort order definition from <file name>.\n"));
#endif
  fprintf(fp,_("\t-x <file name>        Read exclusions from named file\n"));
  fprintf(fp,_("\t-X <exclusions>       Exclude specified characters\n"));
  fprintf(fp,_("\t-i                    Invert sense of comparisons\n"));
  fprintf(fp,_("\t-R                    Reverse characters of key\n"));
  fputc('\n',fp);				
}

void
PrintGNUEquivalences(FILE *fp)
{
  fprintf(fp,"GNU sort\t\t\t\tmsort\n");
  fprintf(fp,"-c,--check\t\t\t\t-Q\n");
  fprintf(fp,"-f,--ignore-case\t\t\t-C\n");
  fprintf(fp,"-g,--general-numeric-sort\t\t-c n\n");
  fprintf(fp,"-M,--month-sort\t\t\t\t-c m\n");
  fprintf(fp,"-n,--numeric-sort\t\t\t-c N\n");
  fprintf(fp,"-r,--reverse\t\t\t\t-i\n");
  fprintf(fp,"-s,--stable\t\t\t\t-a I\n");
  fprintf(fp,"           \t\t\t\t-a M\n");
  fprintf(fp,"-t <fs>,--field-separator <fs>\t\t-d <fs>\n");
  fprintf(fp,"-z,--zero-terminated\t\t\t-r \\000\n");
  fputc('\n',fp);				
}

#endif
void
PrintDefaults(FILE *fp)
{

   fprintf(fp,_("Defaults:\n"));
   fprintf(fp,_("    Field terminator character(s)\n"));
   fprintf(fp,_("        Record = line               whitespace (space or tab)\n"));
   fprintf(fp,_("        Record = block              end-of-line\n"));
   fprintf(fp,_("    Key specification               whole record\n"));
   fprintf(fp,_("    Initial number of records       %4d\n"),DEFMAXRECORDS);
   fprintf(fp,_("    Presence of key                 obligatory\n"));
   fprintf(fp,_("    Record type                     double end-of-line terminated block\n"));
   fprintf(fp,_("    Sense of sort                   forward\n"));	
   fprintf(fp,_("    Date format                     y-m-d (International Date Format)\n"));
   fprintf(fp,_("    Sort order                      numerical Unicode order\n"));
   fprintf(fp,_("    Sort type                       lexicographic\n"));
   fprintf(fp,_("    Algorithm                       quicksort\n"));
   fprintf(fp,"\n");
}

#define BUFSIZE 128
void
PrintLimits(FILE *fp)
{
  char buf[BUFSIZE];
  char *ptr;

  fprintf(fp,_("Limits:\n"));
  fprintf(fp,_("   Maximum length of numeric key                              %8d\n"),
	  MAXDOUBLELEN);
  fprintf(fp,_("   Number of multigraphs per key with no restrictions         %'8d\n"),
	  FUL_MAXMULTIGRAPHS);
  fprintf(fp,_("   Number of multigraphs per key (BMP only)                   %8s\n"),
	  BMP_MAXMULTIGRAPHS);
  fprintf(fp,_("   Number of multigraphs per key (Private Use Areas reserved) %8s\n"),
	  NPU_MAXMULTIGRAPHS);
  fprintf(fp,_("   Number of subparts of a hybrid key with locale collation   %8s\n"),
	  "127");
  fprintf(fp,"\n");
  free(ptr);
}


void
PrintUsage(void)
{   extern char progname[];
	
   fprintf(stdout,"\n");
   fprintf(stdout,_("This program sorts text using arbitrary sort\norders on fields specified on the command-line.\n"));
   fprintf(stdout,_("If no input file is specified, input is read from\nthe standard input.\n"));
   fprintf(stdout,_("Usage: %s <flags> (<input file name>)\n"),progname);
   fprintf(stdout,_("Type %s -F to obtain a list of global options.\n"),progname);
   fprintf(stdout,_("Type %s -K to obtain a list of key-specific options.\n"),progname);
   fprintf(stdout,_("There is also a graphical interface called msg.\n\n"));
}
