/*
 * Decompiled with CFR 0.152.
 */
package org.petzall.daapapplet.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import org.cdavies.itunes.Track;
import org.petzall.daapapplet.DAAPApplet;
import org.petzall.daapapplet.DAAPPanel;
import org.petzall.daapapplet.gui.GUI;
import org.petzall.daapapplet.gui.components.Display;
import org.petzall.daapapplet.gui.components.MainView;

public class SkinnedGUI
extends JPanel
implements GUI,
Runnable {
    private DAAPApplet _applet;
    private MainView _view;
    private JLabel _searchStats;
    private JTextField _searchField;
    private JButton _playPauseBtn;
    private Display _display;
    private Track _currentTrack;
    private String _displayMessage;
    private long _lastSetTime;

    public SkinnedGUI(DAAPApplet dAAPApplet) {
        this._applet = dAAPApplet;
    }

    public void layoutPanel(DAAPPanel dAAPPanel) {
        this._view = new MainView(this._applet, dAAPPanel.getTrackList(), dAAPPanel.getControl(), this);
        this._view.validate();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.left = 6;
        gridBagConstraints.insets.right = 6;
        JButton jButton = new JButton("Prev");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SkinnedGUI.this._applet.previous();
            }
        });
        this.add((Component)jButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.right = 6;
        gridBagConstraints.insets.left = 6;
        jButton = new JButton("Play");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SkinnedGUI.this._applet.playPause();
            }
        });
        this.add((Component)jButton, gridBagConstraints);
        this._playPauseBtn = jButton;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.left = 6;
        gridBagConstraints.insets.right = 6;
        jButton = new JButton("Next");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SkinnedGUI.this._applet.next();
            }
        });
        this.add((Component)jButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets.top = 6;
        gridBagConstraints.insets.bottom = 6;
        JSlider jSlider = new JSlider();
        this.add((Component)jSlider, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        this._display = new Display(this);
        this.add((Component)this._display, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this._searchField = new JTextField(10);
        this._searchField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SkinnedGUI.this._applet.search(SkinnedGUI.this._searchField.getText());
            }
        });
        this.add((Component)this._searchField, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 6;
        this._searchStats = new JLabel("Search");
        this.add((Component)this._searchStats, gridBagConstraints);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.bottom = 6;
        gridBagConstraints.fill = 1;
        jButton = new JButton("Browse");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SkinnedGUI.this._view.toggleBrowse();
            }
        });
        this.add((Component)jButton, gridBagConstraints);
        dAAPPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        dAAPPanel.add((Component)this, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        dAAPPanel.add((Component)this._view, gridBagConstraints);
        new Thread(this).start();
    }

    public void run() {
        boolean bl = false;
        int n = 0;
        String string = "";
        String string2 = "";
        try {
            while (true) {
                try {
                    while (true) {
                        int n2 = (int)(System.currentTimeMillis() - this._lastSetTime);
                        Thread.sleep(20L);
                        if (!this._displayMessage.equals("")) {
                            string2 = "<- " + this._displayMessage + " ->";
                            this._display.setTimes(-1, 0);
                        } else if (this._currentTrack != null) {
                            n2 = n2 / 4000 % 3;
                            switch (n2) {
                                case 0: {
                                    string2 = "Title: " + this._currentTrack.getTrackName();
                                    break;
                                }
                                case 1: {
                                    string2 = "Artist: " + this._currentTrack.getArtistName();
                                    break;
                                }
                                case 2: {
                                    string2 = "Album: " + this._currentTrack.getAlbumName();
                                    break;
                                }
                                default: {
                                    string2 = "xcskdf\u00f6lakd\u00f6laslkd\u00f6";
                                }
                            }
                            int n3 = this._applet.getCurrentTrackPosition();
                            int n4 = this._applet.getCurrentTrackLength();
                            if (n3 != n) {
                                this._display.setTimes(n3, n4);
                            }
                            n = n3;
                        } else {
                            string2 = " ?? ";
                            this._display.setTimes(-2, 0);
                        }
                        this._display.setText(string2);
                        string = string2;
                    }
                }
                catch (Exception exception) {
                    if (!(exception instanceof InterruptedException)) continue;
                    throw (InterruptedException)exception;
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void updateTable(String string, String string2) {
        if (string.length() == 0 && string2.length() > 0) {
            this._searchStats.setText(this._applet.getNumFilteredTracks() + " of " + this._applet.getNumTracks());
        } else {
            this._searchStats.setText("Search");
        }
        this._view.getBrowser().updateFilter(string, string2);
        this._view.getTrackTable().addNotify();
        this._view.getTrackTable().validate();
        this._view.getTrackTable().repaint();
    }

    public Color getColor(String string) {
        return this._applet.getColor(string);
    }

    public Font getFont(String string) {
        return this._applet.getFont(string);
    }

    public void setPlayState(int n) {
        if (n == 1) {
            if (this._playPauseBtn != null) {
                this._playPauseBtn.setText("Pause");
            }
        } else if (this._playPauseBtn != null) {
            this._playPauseBtn.setText("Play");
        }
    }

    public void setStatusString(String string) {
        this._displayMessage = string;
        this._lastSetTime = System.currentTimeMillis();
    }

    public void setTrack(Track track) {
        this._currentTrack = track;
        this._displayMessage = "";
        this._lastSetTime = System.currentTimeMillis();
    }

    public void addLogEntry(String string) {
    }

    public int getSelectedTrack() {
        return this._view.getTrackTable().getSelectedRow();
    }
}

