/* MToolsFM - A graphical Frontend to mtools                                     */
/* earlier versions under the name mfm                                           */
/* Copyright (c) 1999-2001 Christian Ospelkaus <christian@core-coutainville.org> */

/* This program is free software; you can redistribute it and/or                 */
/* modify it under the terms of the GNU General Public License                   */
/* as published by the Free Software Foundation; either version 2                */
/* of the License, or (at your option) any later version.                        */

/* This program is distributed in the hope that it will be useful,               */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 */
/* GNU General Public License for more details.                                  */

/* You should have received a copy of the GNU General Public License             */
/* along with this program; if not, write to the Free Software                   */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.   */

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <dirent.h>
#include <time.h>
#include <ctype.h>
#include <fcntl.h>
#include <signal.h>
#include <libintl.h>
#define _(String) gettext( String )
                     
#include "mtoolsfm.h"

#ifndef NOPIXMAPS
#include "pixmaps.h"
#endif

extern char **environ;
char ***fenv;

GtkWidget *showdots,*textmode,*outtext,*dirfirst,*middlebox,*logobutton,*logopixwid,*clock1pixwid,*clock2pixwid,*clock3pixwid;
int mtools_version1=-1, mtools_version2=-1, mtools_version3=-1;
GtkCListCompareFunc default_compare_func=0;

/*XXXX*/ 
GtkWidget *mainwindow;

#ifndef NOPIXMAPS
GdkPixmap *dirpix;
GdkBitmap *dirmask;
GdkPixmap *filepix;
GdkBitmap *filemask;
GdkPixmap *linkdirpix;
GdkBitmap *linkdirmask;
GdkPixmap *linkfilepix;
GdkBitmap *linkfilemask;

GdkPixmap *mtoolsfmpix;
GdkBitmap *mtoolsfmmask;

GdkPixmap *logopix;
GdkBitmap *logomask;

GdkPixmap *clock1pix;
GdkBitmap *clock1mask;

GdkPixmap *clock2pix;
GdkBitmap *clock2mask;

GdkPixmap *clock3pix;
GdkBitmap *clock3mask;
#endif

char drives[27]="";
/* char mpath[256]=""; XXX */
/* char mtoolscommand[256]=""; XXX */
char *homedir;
int debug=0;

/* should a configuration file ~/.mtoolsfm be written in user's homedir ? */
#ifdef DEFAULT_NOSAVE
    int nosave=1;
#else
    int nosave=0;
#endif   

extern char ertext[];
extern int erleng;

int er_interface (FILE * infile, FILE * parserout);

int max(int a1, int a2) {
  if(a1>a2)
    return a1;
  else 
    return a2;
}

void wait_gtk_events(void) {
  /* This is called from the lexer for diagnostics from subprocesses 
   * to redraw windows etc... */
  while (gtk_events_pending ())
    gtk_main_iteration ();
}

void change_pixmap(mode) {
  /* This is called from the lexer er.l for diagnostics from subprocesses. It will
   * change the pixmap in the middle of the window to the MToolsFM logo (mode=1)
   * or to one of the three clock pixmaps which are used by the lexer to produce a 
   * little animation while subprocesses are active (mode=1,2,3). 
   */
#ifndef NOPIXMAPS
  if(mode==0) {
    gtk_widget_ref(GTK_BIN(logobutton)->child);
    gtk_container_remove(GTK_CONTAINER(logobutton),GTK_BIN(logobutton)->child);
    gtk_container_add(GTK_CONTAINER(logobutton),logopixwid);
    gtk_widget_unref(logopixwid);
  } else if(mode==1) {
    gtk_widget_ref(GTK_BIN(logobutton)->child);
    gtk_container_remove(GTK_CONTAINER(logobutton),GTK_BIN(logobutton)->child);
    gtk_container_add(GTK_CONTAINER(logobutton),clock1pixwid);
    gtk_widget_unref(clock1pixwid);
  } else if(mode==2) {
    gtk_widget_ref(GTK_BIN(logobutton)->child);
    gtk_container_remove(GTK_CONTAINER(logobutton),GTK_BIN(logobutton)->child);
    gtk_container_add(GTK_CONTAINER(logobutton),clock2pixwid);
    gtk_widget_unref(clock2pixwid);
  } else if(mode==3) {
    gtk_widget_ref(GTK_BIN(logobutton)->child);
    gtk_container_remove(GTK_CONTAINER(logobutton),GTK_BIN(logobutton)->child);
    gtk_container_add(GTK_CONTAINER(logobutton),clock3pixwid);
    gtk_widget_unref(clock3pixwid);
  }
#endif
}

void set_main_window_state(int state) {
  /* Make main window sensitive / insensitive 
   * state = 0: insensitive
   * state = 1: sensitive
   */
  if(state)
    gtk_widget_set_sensitive(mainwindow,TRUE);
  else
    gtk_widget_set_sensitive(mainwindow,FALSE);
}


void lc_change(int mode) {
  /* Make sure that subprocesses do not send us localized 
   * diagnostics which we cannot interpret. Make backups of relevant 
   * environment variables and delete them (mode=1) or restore them 
   * from backups (mode=2)
   * This funcion is called with mode=1 before any subprocess is called with 
   * fork() / execlp(). If system() is used (as in filepront_event), need to call
   * this function in the following way: lc_change(1); system("some_command"); lc_change(2)
   */
  static int firstcall=1;
  static char *LC_back=NULL;
  static char *LANGUAGE_back=NULL;
  /* mode = 1 : LC_MESSAGES=C and LANGUAGE deleted
   *        2 : restore LC_MESSAGES and LANGUAGE
   */
  if(firstcall) {
    firstcall=0;
    if(getenv("LC_MESSAGES")) {
      LC_back=malloc(strlen(getenv("LC_MESSAGES"))+sizeof(char));
      strcpy(LC_back,getenv("LC_MESSAGES"));
    }
    if(getenv("LANGUAGE")) {
      LANGUAGE_back=malloc(strlen(getenv("LANGUAGE"))+sizeof(char));
      strcpy(LANGUAGE_back,getenv("LANGUAGE"));
    }
  }
  if(mode==1) {
    putenv ("LC_MESSAGES=C");
    unsetenv("LANGUAGE");
  }
  else if(mode==2) {
    if(LC_back)
      putenv(LC_back);
    else
      unsetenv("LC_MESSAGES");
    if(LANGUAGE_back)
      putenv(LANGUAGE_back);
  }
}

char *removespace (char *string) {
  /* Remove spaces from beginning and end of 'string' */
  int i;
  if (debug)
    printf ("In removespace()\n");
  while (string[0] == ' ') {
    for (i = 0; i < strlen (string); i++)
      string[i] = string[i + 1];
  }
  for (i = strlen (string) - 1; i >= 0; i--)
    if (string[i] == ' ')
      string[i] = '\0';
  return (string);
}

void shiftstring (char *text, int n) {
  /* Remove first 'n' characters from the string 'text' */
  char *runp;
  for (runp = text + strlen (text); runp != (text - 1);
       *(runp + n) = *runp, runp--);
}

gint dialog_event (GtkWidget * widget, msgenv * msg) {
  /* Callback needed for delete event in a dialog */
  if (debug) {
    printf ("In dialog_event()\n");
    printf ("  msg: %i\n", msg->msg);
  }
  *(msg->mvar) = msg->msg;
  return (TRUE);
}

gint dialogclose_event (GtkWidget * widget, GdkEvent * event, msgenv * msg) {
  /* Callback needed for cancel button in dialogs */
  if (debug) {
    printf ("In dialogclose_event()\n");
    printf ("  msg: %i\n", msg->msg);
  }
  *(msg->mvar) = msg->msg;
  return (TRUE);
}

int display_message (const char *message, const char *title, unsigned int button_mask) {
  /* Display a messagebox. button_mask tells us which buttons we need. See mtoolsfm.h for possiblities. */
  GtkWidget *dialog, *button,*hbox,*label;
#ifndef NOPIXMAPS
  GtkWidget *mtoolsfmpixwid;
#endif
  msgenv msg[MAX_BUTTON];
  int result = 0;
  int i;
  const char *buttonlabels[]={ OK,RETRY,YES,NO,SKIP,ALL,CANCEL};
  if (debug)
    printf ("In display_message()\n");
  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), title);
  gtk_container_set_border_width (GTK_CONTAINER (dialog), 15);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), hbox, TRUE, FALSE,
		      15);
  gtk_widget_show (hbox);

#ifndef NOPIXMAPS
  mtoolsfmpixwid = gtk_pixmap_new (mtoolsfmpix, mtoolsfmmask);
  gtk_box_pack_start (GTK_BOX (hbox), mtoolsfmpixwid, FALSE, FALSE, 15);
  gtk_widget_show (mtoolsfmpixwid);
#endif

  /* Display message */
  label = gtk_label_new (message);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 15);
  gtk_widget_show (label);

  /* Create buttons */
  for (i=0;i<=MAX_BUTTON-1;i++) {
    msg[i].mvar=&result;
    msg[i].msg=1<<i;
    if((1<<i)&button_mask) {
      button = gtk_button_new_with_label (buttonlabels[i]);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), button,
			  TRUE, TRUE, 0);
      gtk_signal_connect (GTK_OBJECT (button), "clicked",
			  GTK_SIGNAL_FUNC (dialog_event), msg+i);
      gtk_widget_show (button);
      if((!i)&&(button_mask==BUTTON_OK)) {
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (button);
      }
    }
    if((1<<i)&BUTTON_CANCEL)
      gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
			  GTK_SIGNAL_FUNC (dialogclose_event), msg+i);
  }

  gtk_grab_add (dialog);
#ifndef OLDGTK
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);
#endif
  gtk_widget_show (dialog);

#ifndef NOPIXMAPS
  gdk_window_set_icon (dialog->window, NULL, mtoolsfmpix, mtoolsfmmask);
#endif

  while (!result) 
    while (gtk_events_pending ())
      gtk_main_iteration ();
  
  gtk_grab_remove (dialog);
  gtk_widget_destroy (dialog);
  if (debug)
    printf ("End display_message()\n");
  return (result);
}

void warnme (const char *title, const char *text) {
  /* Display a small messagebox with an OK button */
  display_message(text,title,BUTTON_OK);
}

int mtools_version_check(void) {
  /* This function will check which version of mtools is installed. 
   * This is mostly to check whether mcopy has the /dev/tty bug. 
   */
  pid_t childpid;
  int copypipe[2];
  FILE *mcopyout;
  int status, lex_result;
  mtools_version1=-1;
  mtools_version2=-1;
  mtools_version3=-1;
  if (pipe (copypipe) < 0) {
    printf ("  Error with pipe()\n");
    gtk_main_quit ();
  }
  if ((childpid = fork ()) < 0) {
    printf ("  Error with fork()\n");
    exit (-1);
  }
  else if (childpid == 0) {
    /* In child */
    if (debug)
      printf ("  in child\n");
    lc_change(1);
    close (copypipe[0]);
    if (copypipe[1] != STDERR_FILENO) {
      if (dup2 (copypipe[1], STDOUT_FILENO) != STDOUT_FILENO) {
	printf ("  Error with dup2()\n");
	gtk_main_quit ();
      }
      close (copypipe[1]);
    }
    execlp("mtools","mtools", "--version", NULL);
    printf ("  error in execlp()\n");
    printf ("  errno:%d\n", errno);
    _exit (-1);
  }
  else {
    /* In parent */
    if (debug)
      printf ("  in parent\n");
    close (copypipe[1]);
    if ((mcopyout = fdopen (copypipe[0], "r")) == NULL) {
      printf ("  Error while opening pipe for reading\n");
      gtk_main_quit ();
    }
    lex_result = er_interface (mcopyout,stdout);
    while (1) {
      while (gtk_events_pending ())
	gtk_main_iteration ();
      if (waitpid (childpid, &status, WNOHANG) == childpid) {
	waitpid (childpid, &status, WUNTRACED);
	break;
      }
    }
  }
  /* return value: 0 mtools >= 3.9.7
   *               1 mtools <= 3.9.7
   *               2 mtools not present or version detection failed 
   */
  if((mtools_version1==-1)||(mtools_version2==-1)||(mtools_version3==-1)) 
    return 2;
  else if((mtools_version1>3)||
	  ((mtools_version1==3)&&(mtools_version2>9))||
	  ((mtools_version1==3)&&(mtools_version2==9)&&(mtools_version2>=7)))
    return 0;
  else 
    return 1;
}

void mtoolserroutput (const char *text) {
  /* This function will display 'text' in the text box for diagnostics 
   * from subprocesses. It is called from the lexer for the output from subprocesses
   * which can be found in er.l
   */
  gtk_text_insert (GTK_TEXT (outtext), NULL, NULL, NULL, text, -1);
}

int entertext (char *title, char *text, char *answer, int length) {
  /* A little dialog which allows the user to enter a text with 
   * maximum length 'length'. 'title' contains the title for the message box,
   * 'text' a string which will be displayed together with the text box and 
   * answer can contain a default value and will contain the text the user 
   * entered when the function terminates. 
   * Return values are 1 for OK and 2 for Cancel.
   */
  GtkWidget *dialog, *okbutton, *cancelbutton, *label, *hbox, *entry;
#ifndef NOPIXMAPS
  GtkWidget *mtoolsfmpixwid;
#endif
  int flag = 0;
  msgenv msg[2];

  if (debug)
    printf ("In entertext()\n");
  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), title);
  gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
		      GTK_SIGNAL_FUNC (dialogclose_event), &msg);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), hbox, TRUE, FALSE,
		      15);
  gtk_widget_show (hbox);

#ifndef NOPIXMAPS
  mtoolsfmpixwid = gtk_pixmap_new (mtoolsfmpix, mtoolsfmmask);
  gtk_box_pack_start (GTK_BOX (hbox), mtoolsfmpixwid, FALSE, FALSE, 15);
  gtk_widget_show (mtoolsfmpixwid);
#endif

  label = gtk_label_new (text);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 15);
  gtk_widget_show (label);

  entry = gtk_entry_new ();
  gtk_entry_set_max_length (GTK_ENTRY (entry), length);
  gtk_entry_set_text (GTK_ENTRY (entry), answer);
  gtk_box_pack_start (GTK_BOX (hbox), entry, FALSE, FALSE, 5);
  gtk_widget_show (entry);

  okbutton = gtk_button_new_with_label (OK);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), okbutton,
		      TRUE, FALSE, 0);
  GTK_WIDGET_SET_FLAGS (okbutton, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (okbutton);
  msg[0].mvar = &flag;
  msg[0].msg = 1;
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      GTK_SIGNAL_FUNC (dialog_event), msg);
  gtk_signal_connect (GTK_OBJECT (entry), "activate",
		      GTK_SIGNAL_FUNC (dialog_event), msg);
  gtk_widget_show (okbutton);

  cancelbutton = gtk_button_new_with_label (CANCEL);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      cancelbutton, TRUE, FALSE, 0);
  msg[1].mvar = &flag;
  msg[1].msg = 2;
  gtk_signal_connect (GTK_OBJECT (cancelbutton), "clicked",
		      GTK_SIGNAL_FUNC (dialog_event), msg + 1);
  gtk_widget_show (cancelbutton);

  gtk_grab_add (dialog);
#ifndef OLDGTK
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);
#endif
  gtk_widget_show (dialog);

#ifndef NOPIXMAPS
  gdk_window_set_icon (dialog->window, NULL, mtoolsfmpix, mtoolsfmmask);
#endif

  while (!flag) {
    while (gtk_events_pending ())
      gtk_main_iteration ();
  }
  strcpy (answer, gtk_entry_get_text (GTK_ENTRY (entry)));
  gtk_grab_remove (dialog);
  gtk_widget_destroy (dialog);
  if (debug)
    printf ("End entertext()\n");
  return (flag);
}

int entersplitsize (long int *splitsize) {
  /* This dialog will be called from util_split_event(). It will 
   * allow the user to enter the file size when splitting files. 
   */
  GtkWidget *dialog, *okbutton, *cancelbutton, 
    *hbox, *entry, *table, *fromlistbutton, *customsizebutton, *combo;
  GList *glist=NULL;
#ifndef NOPIXMAPS
  GtkWidget *mtoolsfmpixwid;
#endif
  int flag = 0;
  msgenv msg[2];

  if (debug)
    printf ("In entersplitsize()\n");
  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), _("Set split size"));
  gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
		      GTK_SIGNAL_FUNC (dialogclose_event), &msg);
  /* This hbox will hold the pixmap in one cell and the rest in the other cell */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), hbox, TRUE, FALSE,
		      15);
  gtk_widget_show (hbox);

#ifndef NOPIXMAPS
  mtoolsfmpixwid = gtk_pixmap_new (mtoolsfmpix, mtoolsfmmask);
  gtk_box_pack_start (GTK_BOX (hbox), mtoolsfmpixwid, FALSE, FALSE, 15);
  gtk_widget_show (mtoolsfmpixwid);
#endif

  /* This table will hold the radiobuttons and the size fields */
  table = gtk_table_new(2,2,FALSE);
  gtk_box_pack_start (GTK_BOX (hbox), table, FALSE, FALSE, 5);
  gtk_widget_show (table);

  /* Create radio buttons */
  fromlistbutton=gtk_radio_button_new_with_label(NULL,_("From list:"));
  customsizebutton=gtk_radio_button_new_with_label(
		   gtk_radio_button_group(GTK_RADIO_BUTTON(fromlistbutton)),
		   _("Custom size:"));
  gtk_table_attach_defaults(GTK_TABLE(table),fromlistbutton,0,1,0,1);
  gtk_widget_show(fromlistbutton);
  gtk_table_attach_defaults(GTK_TABLE(table),customsizebutton,0,1,1,2);
  gtk_widget_show(customsizebutton);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fromlistbutton),TRUE);

  /* Create combobox for predefined sizes */
  combo=gtk_combo_new ();
  gtk_widget_set_usize(combo, 160, 0);
  gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(combo)->entry),FALSE);
  glist = g_list_append(glist, SMALL_FLOPPY_DESC);
  glist = g_list_append(glist, BIG_FLOPPY_DESC);
  gtk_combo_set_popdown_strings( GTK_COMBO(combo), glist) ;
  gtk_table_attach(GTK_TABLE(table),combo,1,2,0,1,0,0,0,0);
  gtk_widget_show(combo);

  /* Create text entry for user-defined size */
  entry = gtk_entry_new ();
  gtk_entry_set_max_length (GTK_ENTRY (entry), 10);
  gtk_widget_set_usize(entry, 80, 0); 
  gtk_entry_set_text (GTK_ENTRY (entry), "1400000");
  gtk_table_attach(GTK_TABLE(table),entry,1,2,1,2,0,0,0,0);
  gtk_widget_show (entry);

  okbutton = gtk_button_new_with_label (OK);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), okbutton,
		      TRUE, FALSE, 0);
  GTK_WIDGET_SET_FLAGS (okbutton, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (okbutton);
  msg[0].mvar = &flag;
  msg[0].msg = 1;
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      GTK_SIGNAL_FUNC (dialog_event), msg);
  gtk_signal_connect (GTK_OBJECT (entry), "activate",
		      GTK_SIGNAL_FUNC (dialog_event), msg);
  gtk_widget_show (okbutton);

  cancelbutton = gtk_button_new_with_label (CANCEL);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      cancelbutton, TRUE, FALSE, 0);
  msg[1].mvar = &flag;
  msg[1].msg = 2;
  gtk_signal_connect (GTK_OBJECT (cancelbutton), "clicked",
		      GTK_SIGNAL_FUNC (dialog_event), msg + 1);
  gtk_widget_show (cancelbutton);

  gtk_grab_add (dialog);
#ifndef OLDGTK
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);
#endif
  gtk_widget_show (dialog);

#ifndef NOPIXMAPS
  gdk_window_set_icon (dialog->window, NULL, mtoolsfmpix, mtoolsfmmask);
#endif

  while (!flag) {
    while (gtk_events_pending ())
      gtk_main_iteration ();
  }
  /* strcpy (answer, gtk_entry_get_text (GTK_ENTRY (entry))); */
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fromlistbutton))) {
    if(!strcmp(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo)->entry)),SMALL_FLOPPY_DESC))
      *splitsize=1400000;
    else
      *splitsize=1200000;
  } else 
    *splitsize=atol(gtk_entry_get_text(GTK_ENTRY(entry)));
  gtk_grab_remove (dialog);
  gtk_widget_destroy (dialog);
  if (debug)
    printf ("End entersplitsize()\n");
  return (flag);
}

int pathlength (side * whichside) {
  /* Get the string length of the path list for 'whichside' */
  int i;
  int n = 1;
  if (debug)
    printf ("In pathlength()\n");
  for (i = 0; i < whichside->length; i++)
    n += strlen (whichside->path[i]) + 1;
  if (debug) {
    printf ("  n: %i\n", n);
    printf ("End pathlength()\n");
  }
  return (n);
}

void getpath (side * whichside, char **path) {
  /* Print path list for file list 'whichside' into the string path. 
   * Allocate memory for it.
   */
  int i;
  if (debug)
    printf ("In getpath()\n");
  *path = (char *) malloc ((pathlength (whichside) + 300) * sizeof (char));
  strcpy (*path, "/");
  for (i = 0; i < whichside->length; i++) {
    strcat (*path, whichside->path[i]);
    strcat (*path, "/");
  }
  if (debug) {
    printf ("  path: %s+\n", *path);
    printf ("End getpath()\n");
  }
}

void clearpath (side * whichside) {
  /* Clear path list for file list 'whichside' */
  int i;
  if (debug) {
    printf ("In clearpath()\n");
    printf ("  length: %i\n", whichside->length);
  }
  for (i = 0; i < whichside->length; i++)
    free (whichside->path[i]);
  whichside->length = 0;
  if (debug)
    printf ("End clearpath()\n");
}

void gethdpath (side * whichside) {
  /* Get cwd and store it in the path list for file list 'whichside' */
  char *path = NULL;
  char *position;
  char *nextposition;
  unsigned int path_length=50;
  unsigned int path_add=50;

  if (debug) {
    printf ("In gethdpath()\n");
    printf ("  whichside: %p\n", whichside);
  }
  clearpath (whichside);
  errno = 0;
  path = malloc (path_length * sizeof (char));
  while ((!getcwd (path, path_length - 2)) && (errno == ERANGE))
	{
		if (debug) printf("  getcwd buffer resize: errno=%d, path_length=%d, path=%s\n",errno,path_length,path);
		path = g_realloc (path, (path_length+=path_add) * sizeof (char));
	}
  strcat (path, "/");
  if (debug)
    printf ("  path: %s\n", path);
  position = path + 1;
  nextposition = strstr (position, "/");
  while (nextposition && (whichside->length < DIR_DEPTH - 1)) {
    whichside->path[whichside->length] =
      malloc (sizeof (char) * ((nextposition - position) + 1));
    strncpy (whichside->path[whichside->length], position,
	     nextposition - position);
    whichside->path[whichside->length][nextposition - position] = '\0';
    whichside->length += 1;
    position = nextposition + 1;
    nextposition = strstr (position, "/");
  }
  free (path);
  if (debug) {
    printf ("  length: %i\n", whichside->length);
    printf ("End gethdpath()\n");
  }
  return;
}

int read_configfile (side * leftside, const char *cfname) {
  /* Read configfile ... */
  int i;
  char buff[120];
  char *pos;
  FILE *cfile;
  if (debug) {
    printf ("In read_configfile()\n");
    printf ("  leftside: %p\n", leftside);
  }
  if ((cfile = fopen (cfname, "r"))) {
    strcpy (drives, "");
    while (fgets (buff, 119, cfile)) {
      if ((pos = strchr (buff, '#')))
	*pos = '\0';
      if ((pos = strchr (buff, '\n')))
	*pos = '\0';
      if (!strncmp (buff, "DRIVES=\"", 8))
	for (i = 8;(pos = strchr ("abcdefghijklmnopqrstuvwxyz", buff[i])); i++)
	  if (!strchr (drives, *pos)) {
	    drives[strlen (drives) + 1] = '\0';
	    drives[strlen (drives)] = *pos;
	  }
      /* XXX if (!strncmp (buff, "MPATH=\"", 7)) { */
      /* XXX   for (i = 0;(buff[i + 7] != '\"') && buff[i + 7] && (buff[i + 7] != '\n'); i++) */
      /* XXX     mpath[i] = buff[i + 7]; */
      /* XXX   mpath[i] = '\0'; */
      /* XXX } */
      if (!strncmp (buff, "LEFTDRIVE=\"", 11))
	leftside->drive = buff[11];
      if (!strncmp (buff, "RIGHTDRIVE=\"", 12))
	leftside->other->drive = buff[12];
    }
    fclose (cfile);
    if (!strchr (drives, leftside->drive))
      leftside->drive = '\0';
    if (!strchr (drives, leftside->other->drive))
      leftside->other->drive = '\0';
    if (debug) {
      printf ("  found %s\n", cfname);
      printf ("  drives %s\n", drives);
      printf ("  leftside->drive %c\n", leftside->drive);
      printf ("  leftside->other->drive %c\n", leftside->other->drive);
      printf ("End read_configfile()\n");
    }
    return (0);
  }
  else {
    if (debug) {
      printf ("  didnt find %s\n", cfname);
      printf ("End read_configfile()\n");
    }
    return (1);
  }
}

void save_config (side * leftside) {
  /* Save config file. This is not pretty. We discard all comments 
   * that the user might have put into his file. Eventually replace this 
   * by a nice lexer / parser which will read the original file and leave 
   * comments intact. 
   */
  char *cfname;
  FILE *cfile;
  cfname = malloc ((strlen (homedir) + 11) * sizeof (char));
  strcpy (cfname, homedir);
  strcat (cfname, "/.mtoolsfm");
  if (debug)
    printf ("In save_config()\n");
  if ((cfile = fopen (cfname, "w"))) {
    fprintf (cfile,
	     "# MToolsFM config file. comments start with a hash sign.\n");
    fprintf (cfile, "# \n");
    fprintf (cfile,
	     "# This variable sets the allowed driveletters (all lowercase). Example:\n");
    fprintf (cfile, "# DRIVES=\"ab\"\n");
    fprintf (cfile, "DRIVES=\"%s\"\n", drives);
    fprintf (cfile, "# \n");
    fprintf (cfile,
	     "# This variable sets the driveletter upon startup in the left window. \n");
    fprintf (cfile,
	     "# An empty string or space is for the hardisk. Example: \n");
    fprintf (cfile, "# LEFTDRIVE=\"a\"\n");
    fprintf (cfile, "LEFTDRIVE=\"%c\"\n",
	     leftside->drive ? leftside->drive : ' ');
    fprintf (cfile, "# \n");
    fprintf (cfile,
	     "# This variable sets the driveletter upon startup in the right window. \n");
    fprintf (cfile,
	     "# An empty string or space is for the hardisk. Example: \n");
    fprintf (cfile, "# RIGHTDRIVE=\"a\"\n");
    fprintf (cfile, "RIGHTDRIVE=\"%c\"\n",
	     leftside->other->drive ? leftside->other->drive : ' ');
    /* XXX fprintf (cfile,"# This variable sets the path to the mtools commands. \n"); */
    /* XXX fprintf (cfile, "# If left empty, " MTOOLSDIR " is assumed.\n"); */
    /* XXX fprintf (cfile, "MPATH=\"%s\"\n", mpath); */
    fclose (cfile);
  }
  free (cfname);
}

void set_combo_entries (side * whichside) {
  /* Set the entries in the combo box for the drive letter 
   * associated with the file list 'whichside' to the driveletters
   * from the 'drives' global variable
   */
  char *pos, *buff;
  char curdrive[3] = " :";
  GList *listpos, *bufflist;
  if (debug)
    printf ("In set_combo_entries()\n");
  listpos = NULL;
  listpos = g_list_append (listpos, "Harddisk");
  for (pos = drives; *pos; pos++) {
    buff = malloc (3 * sizeof (char));
    buff[0] = *pos;
    buff[1] = ':';
    buff[2] = '\0';
    listpos = g_list_append (listpos, buff);
  }
  bufflist = whichside->comboglist;
  gtk_combo_set_popdown_strings (GTK_COMBO (whichside->combo), listpos);
  for (listpos = bufflist; listpos; listpos = listpos->next)
    free (listpos->data);
  g_list_free (bufflist);
  if (!whichside->drive)
    gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (whichside->combo)->entry),
			"Harddisk");
  else {
    curdrive[0] = whichside->drive;
    gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (whichside->combo)->entry),
			curdrive);
  }
  if (debug)
    printf ("End set_combo_entries()\n");
}

int delete_recursive (const char *path) {
  /* Recursively delete a UNIX directory */
  DIR *directory;
  char *fullpath;
  struct dirent *entry;
  struct stat buf;
  int result = 0;
  
  if (debug)
    printf ("In delete_recursive()\n");
  fullpath = malloc ((strlen (path) + 258) * sizeof (char));
  directory = opendir (path);
  if (directory) {
    entry = readdir (directory);
    while (entry) {
      strcpy (fullpath, path);
      strcat (fullpath, "/");
      strcat (fullpath, entry->d_name);
      if (strcmp (entry->d_name, "..") && strcmp (entry->d_name, ".")) {
	stat (fullpath, &buf);
	if (S_ISDIR (buf.st_mode)) {
	  if (delete_recursive (fullpath)) {
	    break;
	    result = 1;
	  }
	}
	else {
	  if (unlink (fullpath)) {
	    break;
	    result = 1;
	  }
	}
      }
      entry = readdir (directory);
    }
    if (rmdir (path))
      result = 1;
  }
  free (fullpath);
  if (debug)
    printf ("End delete_recursive()\n");
  return (result);
}

void destroy_dentry (gpointer data) {
  /* When a row in a file list is because the file list is 
   * being removed because the file list is being rebuilt as 
   * a result of a call to refresh_event(), GTK needs to know how
   * to remove the data associated with that row. This is what this 
   * function does. 
   */
  if (debug)
    printf ("In destroy_dentry()\n");
  free (data);
  if (debug)
    printf ("End destroy_dentry()\n");
}

void selectall_event (GtkWidget * widget, side * whichside) {
  /* Handle the select -> all menu item */
  if (debug)
    printf ("In selectall_event()\n");
  if (!GTK_CLIST (whichside->list)->rows)
    return;
  gtk_clist_select_all (GTK_CLIST (whichside->list));
}

void selectnone_event (GtkWidget * widget, side * whichside) {
  /* Handle the select -> none menu item */
  if (debug)
    printf ("In selectnone_event()\n");
  gtk_clist_unselect_all (GTK_CLIST (whichside->list));
}

void refresh_event (GtkWidget * widget, side * whichside) {
  /* Read in directory contents and display them in the file
   * list 'whichside'.
   */
  char *path, *filebegin;
  dentry *current;

  if (debug)
    printf ("In refresh_event()\n");

  gtk_clist_clear (GTK_CLIST (whichside->list));

  getpath (whichside, &path);
  if (whichside->drive) {
    shiftstring (path, 2);
    path[0] = whichside->drive;
    path[1] = ':';
  }
  filebegin = path + strlen (path);

  if (!whichside->drive) {
    DIR *directory;
    struct stat buf;
    struct dirent *entry;
    char *position;
    char size[16] = "";
    char date[11] = "";
    char time[6] = "";
    int pathlen;
    gint row;
    gchar *tmppoint[5];
    if (debug)
      printf ("  reading from unix-filesystem...\n");
    tmppoint[0] = NULL;
    tmppoint[2] = (gchar *) & size;
    tmppoint[3] = (gchar *) & date;
    tmppoint[4] = (gchar *) & time;
    pathlen = pathlength (whichside);
    position = path + strlen (path);
    gtk_statusbar_pop (GTK_STATUSBAR (whichside->status),
		       whichside->context);
    gtk_statusbar_push (GTK_STATUSBAR (whichside->status),
			whichside->context, path);
    directory = opendir (path);
    if (directory) {
      struct tm *zeitStruct;
      gtk_clist_freeze (GTK_CLIST (whichside->list));
      if (debug)
	printf ("  entering loop and reading directory contents...\n");
      entry = readdir (directory);
      while (entry) {
	strcpy (position, entry->d_name);
	if (debug)
	  printf ("  filename: %s+\n", path);
	if ((GTK_CHECK_MENU_ITEM (showdots)->active
	     || !strcmp (position, "..") || (*position != '.'))
	    && strcmp (position, ".")
	    && (!((pathlen == 1) && (!strcmp (position, ".."))))) {
	  current = malloc (sizeof (dentry));
	  strcpy (current->name, entry->d_name);
	  stat (path, &buf);
	  if (S_ISDIR (buf.st_mode))
	    current->dir = 1;
	  else
	    current->dir = 0;
	  tmppoint[1] = current->name;
	  sprintf (size, "%li", buf.st_size);
	  current->size = buf.st_size;
          zeitStruct=localtime(&(buf.st_mtime));
	  sprintf (date, "%-2.2i-%-2.2i-%-4.4i",
		   zeitStruct->tm_mon+1,
                   zeitStruct->tm_mday,
		   zeitStruct->tm_year + 1900);
	  sprintf (time, "%-2.2i:%-2.2i",
		   zeitStruct->tm_hour,
		   zeitStruct->tm_min);
	  row= gtk_clist_append (GTK_CLIST (whichside->list), tmppoint);
	  if (!strcmp (position, ".."))
	    gtk_clist_set_selectable (GTK_CLIST (whichside->list),
				      row, FALSE);
	  lstat (path, &buf);
	  if (current->dir) {
	    if (S_ISLNK (buf.st_mode)) {
	      gtk_clist_set_foreground (GTK_CLIST
					(whichside->list), row,
					whichside->linkcolor);
#ifndef NOPIXMAPS
	      gtk_clist_set_pixmap (GTK_CLIST (whichside->list),
				    row, 0, linkdirpix,
				    linkdirmask);
#endif
	    }
	    else {
	      gtk_clist_set_foreground (GTK_CLIST
					(whichside->list), row,
					whichside->dircolor);
#ifndef NOPIXMAPS
	      gtk_clist_set_pixmap (GTK_CLIST (whichside->list),
				    row, 0, dirpix, dirmask);
#endif
	    }
	  }
	  else {
	    if (S_ISLNK (buf.st_mode)) {
	      gtk_clist_set_foreground (GTK_CLIST
					(whichside->list), row,
					whichside->linkcolor);
#ifndef NOPIXMAPS
	      gtk_clist_set_pixmap (GTK_CLIST (whichside->list),
				    row, 0, linkfilepix,
				    linkfilemask);
#endif
	    }
	    else {
#ifndef NOPIXMAPS
	      gtk_clist_set_pixmap (GTK_CLIST (whichside->list),
				    row, 0, filepix, filemask);
#endif
	    }
	  }
	  gtk_clist_set_row_data_full (GTK_CLIST (whichside->list),
				       row, (gpointer) current,
				       destroy_dentry);
	}
	entry = readdir (directory);
      }
      closedir (directory);
      if (debug)
	printf ("  end of loop\n");
      gtk_clist_thaw (GTK_CLIST (whichside->list));
    }
    else if (whichside->length) {
      if (debug) {
	printf ("  Opening of directory not successfull.\n");
	printf ("  cd to parent and recurse.\n");
      }
      whichside->length -= 1;
      free (whichside->path[whichside->length]);
      free (path);
      refresh_event (whichside->list, whichside);
      if (debug)
	printf ("End refresh_event()\n");
      return;
    }
  }
  else {
    FILE *mdirout;
    char dosname[9];
    char dosext[4];
    char size[10];
    char date[11];
    char time[6];
    char vfatname[298];
    int entcount = 0;
    gint row;
    gchar *tmppoint[5];

    int status;
    pid_t childpid;
    int mdirpipe[2];

    if (debug)
      printf ("  reading from floppy...\n");
    tmppoint[0] = NULL;
    tmppoint[1] = (gchar *) & vfatname;
    tmppoint[2] = (gchar *) & size;
    tmppoint[3] = (gchar *) & date;
    tmppoint[4] = (gchar *) & time;

    gtk_statusbar_pop (GTK_STATUSBAR (whichside->status),
		       whichside->context);
    gtk_statusbar_push (GTK_STATUSBAR (whichside->status),
			whichside->context, path);

    if (pipe (mdirpipe) < 0) {
      printf ("  Error with pipe()\n");
      gtk_main_quit ();
    }
    if ((childpid = fork ()) < 0) {
      printf ("  Error with fork()\n");
      exit (-1);
    }
    else if (childpid == 0) {
      if (debug)
	printf ("  in child\n");
      lc_change(1);
      close (mdirpipe[0]);
      if (mdirpipe[1] != STDOUT_FILENO) {
	if (dup2 (mdirpipe[1], STDOUT_FILENO) != STDOUT_FILENO) {
	  printf ("  Error with dup2()\n");
	  gtk_main_quit ();
	}
      }
      if (mdirpipe[1] != STDERR_FILENO) {
	if (dup2 (mdirpipe[1], STDERR_FILENO) != STDERR_FILENO) {
	  printf ("  Error with dup2()\n");
	  gtk_main_quit ();
	}
	close (mdirpipe[1]);
      }
      execlp("mtools", "mdir", path, NULL);
      printf ("  error in execlp()\n");
      printf ("  errno:%d\n", errno);
      _exit (-1);
    }
    else {
      if (debug)
	printf ("  in parent. childpid:%i\n", childpid);
      close (mdirpipe[1]);
      if ((mdirout = fdopen (mdirpipe[0], "r")) == NULL) {
	printf ("  Error while opening pipe for reading\n");
	gtk_main_quit ();
      }
      if (debug)
	printf ("  entering loop and reading directory contents...\n");
      gtk_clist_freeze (GTK_CLIST (whichside->list));
      while( er_interface(mdirout,stdout)==255 ) {
	if (debug)
	  printf ("  read line: %s+\n", ertext);
	entcount += 1;
	strncpy (dosname, ertext, 8);
	strncpy (dosext, ertext + 9, 3);
	strncpy (size, ertext + 13, 9);
	strncpy (date, ertext + 23, 10);
	strncpy (time, ertext + 35, 5);
	if (*time == ' ')
	  *time = '0';
	dosname[8] = '\0';
	dosext[3] = '\0';
	size[9] = '\0';
	date[10] = '\0';
	time[5] = '\0';
	removespace (dosname);
	removespace (dosext);
	removespace (size);
	removespace (time);
	if (strlen(ertext) > 42) {
	  strncpy (vfatname, ertext + 42, strlen(ertext+42));
	  vfatname[strlen(ertext+42)] = '\0';
	}
	else {
	  strcpy (vfatname, dosname);
	  if (strlen (dosext)) {
	    strcat (vfatname, ".");
	    strcat (vfatname, dosext);
	  }
	}
	if (strcmp (vfatname, ".")) {
	  current = malloc (sizeof (dentry));
	  strcpy (current->name, vfatname);
	  if (strcmp (size, "<DIR>"))
	    current->dir = 0;
	  else {
	    current->dir = 1;
	    strcpy (size, "0");
	  }
	  current->size = atol (size);
	  row=gtk_clist_append (GTK_CLIST (whichside->list), tmppoint);
	  if (!strcmp (vfatname, ".."))
	    gtk_clist_set_selectable (GTK_CLIST (whichside->list),
				      row, FALSE);
#ifndef NOPIXMAPS
	  if (current->dir)
	    gtk_clist_set_pixmap (GTK_CLIST (whichside->list), row, 0,
				  dirpix, dirmask);
	  else
	    gtk_clist_set_pixmap (GTK_CLIST (whichside->list), row, 0,
				  filepix, filemask);
#endif
	  gtk_clist_set_row_data_full (GTK_CLIST (whichside->list),
				       row, (gpointer) current,
				       destroy_dentry);
	}
      }
      if (debug)
	printf ("  end of loop\n");
      if (!entcount && whichside->length) {
	if (debug)
	  printf ("  strange output: zero entries in subdir\n");
	clearpath (whichside);
	gtk_clist_thaw (GTK_CLIST (whichside->list));
	if (debug)
	  printf ("  trying again...\n");
	refresh_event (whichside->list, whichside);
      }
      else
	gtk_clist_thaw (GTK_CLIST (whichside->list));
      if (waitpid (childpid, &status, WNOHANG) == childpid)
	waitpid (childpid, &status, WUNTRACED);
    }
  }
  free (path);
  gtk_clist_sort (GTK_CLIST (whichside->list));
  if (debug)
    printf ("End refresh_event()\n");
  return;
}

void delete_event (GtkWidget * widget, GdkEvent * event, side * whichside) {
  /* Handle the delete_event of the main window. */
  if (debug)
    printf ("In delete_event()\n");
  if (!nosave)
    save_config (whichside);
  if (debug)
    printf ("End delete_event()\n");
  gtk_main_quit ();
}

void quit_event (GtkWidget * widget, side * whichside) {
  /* Handle the file -> quit menu item */
  if (debug)
    printf ("In quit_event()\n");
  if (!nosave)
    save_config (whichside);
  if (debug)
    printf ("End quit_event()\n");
  gtk_main_quit ();
}

void copy_event (GtkWidget * widget, side * from) {
  /* Handle the file -> copy >>> menu item. and the two copy 
   * buttons between the file lists. 
   * NOTE: when copying many small files from / to floppy, the
   * algorithm is quite ineffecient, since it will call mcopy 
   * for every single file. mcopy seems to spend quite a lot 
   * of time on initialization. 
   * This might be fixed by calling mcopy with several files, but 
   * will make the progressbar more or less useless. (BTW, it 
   * doesn't work anyway when we are copying directory structures... 
   */
  side *to = from->other;
  GList *items;
  gint row;
  msgenv msg;
  GtkWidget *progressdialog, *progressbar, *progresslabel, *cancelbutton;
  long copiedbytes = 0;
  char *text, *frompath, *topath, *frombeginfile, *tobeginfile, *buff;
  int status, i, j, flag = 0, lex_result;
  int copypipe[2];
  FILE *mcopyout;
  pid_t childpid;
  int mtv,allflag=0,allrflag=0,dir,askresult;
  char *warning;

  if (debug)
    printf ("In copy_event()\n");

  /* Allocate a string which is long enough to hold 
   * the warning */
  warning=malloc(max(strlen(OLD_COPY_1)+strlen(OLD_COPY_2),
		     max(strlen(NEW_F_COPY_1)+strlen(NEW_F_COPY_2),
			 strlen(NEW_D_COPY_1)+strlen(NEW_D_COPY_2)))*sizeof(char)
		 +MAX_FILE_LENGTH*sizeof(char));

  /* Check which version of mtools we use */
  mtv=mtools_version_check();

  msg.mvar = &flag;
  msg.msg = 1;

  /* Get pathnames for target and source */
  getpath (from, &frompath);
  if (from->drive) {
    shiftstring (frompath, 2);
    frompath[0] = from->drive;
    frompath[1] = ':';
  }
  frombeginfile = frompath + strlen (frompath);
  getpath (to, &topath);
  if (to->drive) {
    shiftstring (topath, 2);
    topath[0] = to->drive;
    topath[1] = ':';
  }
  tobeginfile = topath + strlen (topath);

  /* Create a dialog with a progressbar */
  if (debug)
    printf ("  creating dialog\n");
  progressdialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (progressdialog),COPYING_FILES);
  gtk_widget_set_usize (GTK_WIDGET (progressdialog), 300, 0);
  /* This enables us to react to the cancel button of the dialog */
  gtk_signal_connect (GTK_OBJECT (progressdialog), "delete_event",
		      GTK_SIGNAL_FUNC (dialogclose_event), &msg);
#ifndef OLDGTK
  gtk_window_set_position (GTK_WINDOW (progressdialog), GTK_WIN_POS_CENTER);
  gtk_container_set_border_width (GTK_CONTAINER (progressdialog), 10);
#endif
  progressbar=gtk_progress_bar_new ();
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (progressdialog)->vbox),
		      progressbar, TRUE, TRUE, 5);
  gtk_widget_show (progressbar);
  gtk_progress_bar_update (GTK_PROGRESS_BAR (progressbar),0);
  progresslabel=gtk_label_new(COPY_PROGRESS_LABEL);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (progressdialog)->vbox),
		      progresslabel, TRUE, TRUE, 5);
  gtk_widget_show (progresslabel);
  cancelbutton = gtk_button_new_with_label (CANCEL);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (progressdialog)->action_area),
		      cancelbutton, TRUE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (cancelbutton), "clicked",
		      GTK_SIGNAL_FUNC (dialog_event), &msg);
  gtk_widget_show (cancelbutton);
  GTK_WIDGET_SET_FLAGS (cancelbutton, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (cancelbutton);
  gtk_widget_show (progressdialog);
#ifndef NOPIXMAPS
  gdk_window_set_icon (progressdialog->window, NULL, mtoolsfmpix, mtoolsfmmask);
#endif
  gtk_grab_add (progressdialog);

  /* Run over all selected files in the source area */
  if (debug)
    printf ("  entering loop...\n");
  items = GTK_CLIST (from->list)->selection;
  while (items && (!flag)) {
    /* Make sure that the dialog shows up */
    while (gtk_events_pending ())
      gtk_main_iteration ();
    /* Get current row in the selection */
    row = (gint) items->data;
    gtk_clist_get_text (GTK_CLIST (from->list), row, 1, &text);
    dir=((dentry *) gtk_clist_get_row_data (GTK_CLIST (from->list),row))->dir;
    /* i-loop over all rows in the target-area to check whether 
     * the file already exists in the target area 
     * After the loop has terminated, i==-1 indicates that a file 
     * with the same name already exists in the target area 
     * j indicates wether row number i exists. If this is not the
     * case, we have dealt with everything in the target area */
    i = 0;
    j = gtk_clist_get_text (GTK_CLIST (to->list), i, 1, &buff);
    while (j) {
      if((!from->drive)&&(!to->drive)) {
	/* Un*x to Un*x */
	if(!strcmp(buff,text)) {
	  i=-1;
	  break;
	}
      } else {
	/* Floppy involved */
	if(!strcasecmp(buff, text)) {
	  i=-1;
	  break;
	}
      }
      i += 1;
      j = gtk_clist_get_text (GTK_CLIST (to->list), i, 1, &buff);
    }
    if (i==-1) {
      if(mtv&&(from->drive||to->drive)) {
	/* This version of mtools is too old and will hang if 
	 * started in the background and the target file already 
	 * exists - even if the -n or -o options are given. Tell 
	 * the user about it. */
	if (debug)
	  printf ("  file exists\n");
	strcpy (warning,OLD_COPY_1);
	strcat (warning, text);
	strcat (warning,OLD_COPY_2);
	askresult=display_message(warning,FILE_EXISTS_TITLE,
				  BUTTON_CANCEL|BUTTON_YES);
	if(askresult & BUTTON_CANCEL)
	  break;
	else {
	  items = items->next;
	  continue;
	}
      }
      else {
	/* This version of mtools will allow us to overwrite files.
	 * Good. Ask the user whether we shall go ahead. */
	askresult = BUTTON_CANCEL;
	if (!allrflag && dir) {
	  strcpy (warning,NEW_D_COPY_1);
	  strcat (warning, text);
	  strcat (warning,NEW_D_COPY_2);
	  askresult=display_message(warning,FILE_EXISTS_TITLE,
				    BUTTON_SKIP|BUTTON_CANCEL|BUTTON_YES|BUTTON_ALL);
	  if (askresult & BUTTON_CANCEL)
	    break;
	}
	if (!allflag && !dir) {
	  strcpy (warning,NEW_F_COPY_1);
	  strcat (warning, text);
	  strcat (warning,NEW_F_COPY_2);
	  askresult=display_message(warning,FILE_EXISTS_TITLE,
				    BUTTON_SKIP|BUTTON_CANCEL|BUTTON_YES|BUTTON_ALL);
	  if (askresult & BUTTON_CANCEL)
	    break;
	}
	if ((askresult & BUTTON_ALL) && dir)
	  allrflag = 1;
	if ((askresult & BUTTON_ALL) && !dir)
	  allflag = 1;
	if (!((askresult & BUTTON_YES) || (askresult & BUTTON_ALL) || 
	      (allrflag && dir)|| (allflag && !dir))) {
	  items = items->next;
	  continue;
	}
      }
    }
    /* Apend filenames to path */
    strcpy (frombeginfile, text);
    strcpy (tobeginfile, text);

    /* Go ahead and call mcopy */
    if (pipe (copypipe) < 0) {
      printf ("  Error with pipe()\n");
      gtk_main_quit ();
    }
    if ((childpid = fork ()) < 0) {
      printf ("  Error with fork()\n");
      exit (-1);
    }
    else if (childpid == 0) {
      if (debug)
	printf ("  in child\n");
      lc_change(1);
      close (copypipe[0]);
      if (copypipe[1] != STDERR_FILENO) {
	if (dup2 (copypipe[1], STDERR_FILENO) != STDERR_FILENO)	{
	  printf ("  Error with dup2()\n");
	  gtk_main_quit ();
	}
	close (copypipe[1]);
      }
      if((!from->drive)&&(!to->drive)) {
        /* Un*x to Un*x */
	if (debug)
          printf ("  Un*x to Un*x\n");
	execlp("cp", "cp", "-Rf", frompath, topath, NULL);
      } else {
	/* mtools involved */
        if (debug)
          printf ("  Copying with mcopy\n");
	if (GTK_CHECK_MENU_ITEM (textmode)->active)
	  execlp("mtools", "mcopy", "-nmot", frompath, topath, NULL);
	else
	  execlp("mtools", "mcopy", "-nmo", frompath, topath, NULL);
      }
      printf ("  error in execlp()\n");
      printf ("  errno:%d\n", errno);
      _exit (-1);
    }
    else {
      if (debug)
	printf ("  in parent. childpid:%i\n", childpid);
      close (copypipe[1]);
      if ((mcopyout = fdopen (copypipe[0], "r")) == NULL) {
	printf ("  Error while opening pipe for reading\n");
	gtk_main_quit ();
      }
      lex_result = er_interface (mcopyout,stdout);
      while (1) {
	if (waitpid (childpid, &status, WNOHANG) == childpid) {
	  waitpid (childpid, &status, WUNTRACED);
	  break;
	}
      }
    }
    if (!(lex_result & BUTTON_RETRY))
	copiedbytes+=((dentry *) gtk_clist_get_row_data (GTK_CLIST (from->list),
							 (int) (items->data)))->size;
    if (from->totsize)
      gtk_progress_bar_update (GTK_PROGRESS_BAR (progressbar),
			       (float) copiedbytes / (from->totsize));
    if(lex_result & BUTTON_CANCEL) 
      items=NULL;
    else if(lex_result & BUTTON_RETRY)
      continue;
    else
      items = items->next;
  }

  gtk_grab_remove (progressdialog);
  gtk_widget_destroy (progressdialog);

  if (debug)
    printf ("  freeing memory...\n");
  free (frompath);
  free (topath);
  free (warning);
  if (debug)
    printf ("  calling refresh_event\n");
  refresh_event (to->list, to);
  if (debug)
    printf ("End copy_event()\n");
}

void config_event (GtkWidget * widget, side * leftside) {
  /* Handle the options -> configure MToolsFM menu item. 
   * display adialog which will let the user specify which 
   * drives are available.
   */
  GtkWidget *dialog, *button, *entrydrive, *entrympath, *box;
  GtkWidget *label;
  msgenv msg[2];
  int flag = 0;
  int i;
  char *buttonlabels[] = { _("OK"), _("Cancel") };
  char newdrives[27];
  char *pos;
  if (debug)
    printf ("In config_event()\n");
  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), CONFIGURE_TITLE);
#ifndef OLDGTK
  gtk_container_set_border_width (GTK_CONTAINER (dialog), 10);
#endif

  /* Display help */
  box = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),box,TRUE,TRUE,5);
  gtk_widget_show (box);
  label = gtk_label_new (CONFIGURE_DRIVES_1);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

  box = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),box,TRUE,TRUE,0);
  gtk_widget_show (box);
  label = gtk_label_new (CONFFILE);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

  box = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),box,TRUE,TRUE,0);
  gtk_widget_show (box);
  label = gtk_label_new (CONFIGURE_DRIVES_2);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

  /* Create textfield for driveletters */
  box = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),box,TRUE,TRUE,0);
  gtk_widget_show (box);
  entrydrive = gtk_entry_new_with_max_length (26);
  gtk_widget_set_usize (entrydrive, 150, 0);
  gtk_entry_set_text (GTK_ENTRY (entrydrive), drives);
  gtk_entry_select_region (GTK_ENTRY (entrydrive), 0, strlen (drives));
  gtk_box_pack_start (GTK_BOX (box), entrydrive, TRUE, FALSE, 0);
  gtk_widget_show (entrydrive); 

  /* XXX Display help */
  /* XXX box = gtk_hbox_new (FALSE, 0); */
  /* XXX gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),box,TRUE,TRUE,0); */
  /* XXX gtk_widget_show (box); */
  /* XXX label = gtk_label_new (CONFIGURE_PATH_1); */
  /* XXX gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT); */
  /* XXX gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 0); */
  /* XXX gtk_widget_show (label); */

  /* XXX box = gtk_hbox_new (FALSE, 0); */
  /* XXX gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),box,TRUE,TRUE,0); */
  /* XXX gtk_widget_show (box); */
  /* XXX label = gtk_label_new (MTOOLSDIR); */
  /* XXX gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT); */
  /* XXX gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 0); */
  /* XXX gtk_widget_show (label); */

  /* XXX box = gtk_hbox_new (FALSE, 0); */
  /* XXX gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),box,TRUE,TRUE,0); */
  /* XXX gtk_widget_show (box); */
  /* XXX label = gtk_label_new (CONFIGURE_PATH_2); */
  /* XXX gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT); */
  /* XXX gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 0); */
  /* XXX gtk_widget_show (label); */

  /* XXX Create textfield for path */
  /* XXX box = gtk_hbox_new (FALSE, 0); */
  /* XXX gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),box,TRUE,TRUE,5); */
  /* XXX gtk_widget_show (box); */
  /* XXX entrympath = gtk_entry_new_with_max_length (255); */
  /* XXX gtk_widget_set_usize (entrympath, 150, 0); */
  /* XXX gtk_entry_set_text (GTK_ENTRY (entrympath), mpath); */
  /* XXX gtk_box_pack_start (GTK_BOX (box), entrympath, TRUE, FALSE, 0); */
  /* XXX gtk_widget_show (entrympath); */

  /* Create buttons */
  for (i = 0; i <= 1; i++)
    {
      msg[i].mvar = &flag;
      msg[i].msg = i + 1;
      button = gtk_button_new_with_label (buttonlabels[i]);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), button,
			  TRUE, TRUE, 0);
      gtk_signal_connect (GTK_OBJECT (button), "clicked",
			  GTK_SIGNAL_FUNC (dialog_event), msg + i);
      if (!i)
	{
	  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	  gtk_widget_grab_default (button);
	}
      gtk_widget_show (button);
    }
  gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
		      GTK_SIGNAL_FUNC (dialogclose_event), msg + 1);

  gtk_grab_add (dialog);
#ifndef OLDGTK
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);
#endif
  gtk_widget_show (dialog);

#ifndef NOPIXMAPS
  gdk_window_set_icon (dialog->window, NULL, mtoolsfmpix, mtoolsfmmask);
#endif

  while (!flag)
    {
      while (gtk_events_pending ())
	gtk_main_iteration ();
    }
  if (flag == 1)
    {
      strcpy (newdrives, gtk_entry_get_text (GTK_ENTRY (entrydrive)));
      strcpy (drives, "");
      for (pos = newdrives; *pos; pos++)
	if (strchr ("abcdefghijklmnopqrstuvwxyz", *pos))
	  {
	    drives[strlen (drives) + 1] = '\0';
	    drives[strlen (drives)] = *pos;
	  }
      /* XXX strcpy (mpath, gtk_entry_get_text (GTK_ENTRY (entrympath))); */
      /* XXX strcpy (mtoolscommand, mpath); */
      /* XXX strcat (mtoolscommand, "/mtools"); */
      if (!strchr (drives, leftside->drive) && leftside->drive)
	leftside->drive = '\0';
      if (!strchr (drives, leftside->other->drive) && leftside->other->drive)
	leftside->other->drive = '\0';
      set_combo_entries (leftside);
      set_combo_entries (leftside->other);
    }
  gtk_grab_remove (dialog);
  gtk_widget_destroy (dialog);
  if (debug)
    printf ("End config_event()\n");
}

void filedelete_event (GtkWidget * widget, side * whichside) {
  /* Handle the file -> delete menu item. */
  GList *items;
  gint row;
  int allflag = 0;
  int allrflag = 0;
  int askresult;
  int status, dir, lex_result;
  pid_t childpid;
  int copypipe[2];
  FILE *mcopyout;
  char *text, *path, *beginfile;
  char *warning;

  if (debug) {
    printf ("In filedelete_event()\n");
    printf ("  whichside %p\n", whichside);
  }

  /* Allocate a string which is long enough to hold 
   * the warning */
  warning=malloc(max(strlen(D_DELETE),strlen(F_DELETE_1)+strlen(F_DELETE_2))*sizeof(char)
		 +MAX_FILE_LENGTH*sizeof(char));

  /* Get path */
  getpath (whichside, &path);
  if (whichside->drive) {
    shiftstring (path, 2);
    path[0] = whichside->drive;
    path[1] = ':';
  }

  if (debug)
    printf ("  path: %s+\n", path);
  beginfile = path + strlen (path);

  /* Loop over all selected items */
  items = GTK_CLIST (whichside->list)->selection;
  while (items) {
    row = (gint) items->data;
    gtk_clist_get_text (GTK_CLIST (whichside->list), row, 1, &text);
    strcpy (beginfile, text);
    askresult=BUTTON_CANCEL;
    dir = ((dentry *) gtk_clist_get_row_data (GTK_CLIST (whichside->list), row))->dir;
    if (!allrflag && dir) {
      strcpy (warning,text);
      strcat (warning,D_DELETE);
      askresult=display_message(warning,DELETE_TITLE,
				BUTTON_SKIP|BUTTON_CANCEL|BUTTON_YES|BUTTON_ALL);
      if (askresult & BUTTON_CANCEL) 
	break;
    }
    if (!allflag && !dir) {
      strcpy (warning,F_DELETE_1);
      strcat (warning, text);
      strcat (warning,F_DELETE_2);
      askresult=display_message(warning,DELETE_TITLE,
				BUTTON_SKIP|BUTTON_CANCEL|BUTTON_YES|BUTTON_ALL);
      if (askresult & BUTTON_CANCEL) 
	break;
    }
    if ((askresult & BUTTON_ALL) && dir)
      allrflag = 1;
    if ((askresult & BUTTON_ALL) && !dir)
      allflag = 1;
    if((askresult & BUTTON_YES) || (askresult & BUTTON_ALL) || 
       (allrflag && dir)|| (allflag && !dir)) {
      if (whichside->drive) {
	if (pipe (copypipe) < 0) {
	  printf ("  Error with pipe()\n");
	  gtk_main_quit ();
	}
	if ((childpid = fork ()) < 0) {
	  printf ("  Error with fork()\n");
	  exit (-1);
	}
	else if (childpid == 0)	{
	  if (debug)
	    printf ("  in child\n");
	  lc_change(1);
	  close (copypipe[0]);
	  if (copypipe[1] != STDERR_FILENO) {
	    if (dup2 (copypipe[1], STDERR_FILENO) != STDERR_FILENO) {
	      printf ("  Error with dup2()\n");
	      gtk_main_quit ();
	    }
	    close (copypipe[1]);
	  }
	  execlp("mtools", dir ? "mdeltree" : "mdel", path, NULL);
	  printf ("  error in execlp()\n");
	  printf ("  errno:%d\n", errno);
	  _exit (-1);
	}
	else {
	  if (debug)
	    printf ("  in parent\n");
	  close (copypipe[1]);
	  if ((mcopyout = fdopen (copypipe[0], "r")) == NULL) {
	    printf ("  Error while opening pipe for reading\n");
	    gtk_main_quit ();
	  }
	  lex_result = er_interface (mcopyout,stdout);
	  while (1) {
	    while (gtk_events_pending ())
	      gtk_main_iteration ();
	    if (waitpid (childpid, &status, WNOHANG) == childpid) {
	      waitpid (childpid, &status, WUNTRACED);
	      break;
	    }
	  }
	}
      }
      else {
	if (dir)
	  delete_recursive (path);
	else
	  unlink (path);
      }
    }
    items = items->next;
  }
  free (path);
  free (warning);
  if (debug)
    printf ("  calling refresh_event()\n");
  refresh_event (whichside->list, whichside);
  refresh_event (whichside->other->list, whichside->other);
  if (debug)
    printf ("End filedelete_event()\n");
}

void filerename_event (GtkWidget * widget, side * whichside) {
  /* Handle the file -> rename menu item. */
  GList *items;
  gint row;
  int flag, status, lex_result;
  pid_t childpid;
  int copypipe[2];
  FILE *mcopyout;
  char *text, *path, *pathren, *hello, *filebegin, *newfile;

  if (debug)
    printf ("In filerename_event()\n");

  getpath (whichside, &path);
  if (whichside->drive) {
    shiftstring (path, 2);
    path[0] = whichside->drive;
    path[1] = ':';
  }
  filebegin = path + strlen (path);
  getpath (whichside, &pathren);
  if (whichside->drive) {
    shiftstring (pathren, 2);
    pathren[0] = whichside->drive;
    pathren[1] = ':';
  }
  newfile = pathren + strlen (pathren);
  if (debug)
    printf ("  path: %s+\n", path);

  hello=malloc((MAX_FILE_LENGTH+1)*sizeof(char)+strlen(RENAME_1)+strlen(RENAME_2));
  items=GTK_CLIST (whichside->list)->selection;
  while (items) {
    row = (gint) items->data;
    gtk_clist_get_text (GTK_CLIST (whichside->list), row, 1, &text);
    strcpy (filebegin, text);
    strcpy (newfile, text);
    strcpy (hello, RENAME_1);
    strcat (hello, text);
    strcat (hello, RENAME_2);
    if ((flag = entertext (RENAME_TITLE, hello, newfile, 255))== 1) {
      if (whichside->drive) {
	if (pipe (copypipe) < 0) {
	  printf ("  Error with pipe()\n");
	  gtk_main_quit ();
	}
	if ((childpid = fork ()) < 0) {
	  printf ("  Error with fork()\n");
	  exit (-1);
	}
	else if (childpid == 0) {
	  if (debug)
	    printf ("  in child\n");
	  close (copypipe[0]);
	  lc_change(1);
	  if (copypipe[1] != STDERR_FILENO) {
	    if (dup2 (copypipe[1], STDERR_FILENO) != STDERR_FILENO) {
	      printf ("  Error with dup2()\n");
	      gtk_main_quit ();
	    }
	    close (copypipe[1]);
	  }
	  execlp("mtools", "mren", path, pathren, NULL);
	  printf ("  error in execlp()\n");
	  printf ("  errno:%d\n", errno);
	  _exit (-1);
	}
	else {
	  if (debug)
	    printf ("  in parent\n");
	  close (copypipe[1]);
	  if ((mcopyout = fdopen (copypipe[0], "r")) == NULL) {
	    printf ("  Error while opening pipe for reading\n");
	    gtk_main_quit ();
	  }
	  lex_result = er_interface (mcopyout,stdout);
	  while (1) {
	    while (gtk_events_pending ())
	      gtk_main_iteration ();
	    if (waitpid (childpid, &status, WNOHANG) == childpid) {
	      waitpid (childpid, &status, WUNTRACED);
	      break;
	    }
	  }
	}
      }
      else
	rename (path, pathren);
    }
    else
      break;
    items = items->next;
  }
  free (path);
  free (pathren);
  refresh_event (whichside->list, whichside);
  if (debug)
    printf ("End filerename_event()\n");
}

void fileprint_event (GtkWidget * widget, side * whichside) {
  /* Handle the file -> print menu item. Printing from floppy is
   * done with the mtype command. Output is piped to lpr.
   */
  GList *items;
  gint row;
  char *text;
  char *path;
  char *command;
  char lprcommand[21] = "lpr";

  if (debug)
    printf ("In fileprint_event()\n");

  if (entertext (PRINT_TITLE,PRINT_QUESTION, lprcommand, 20) == 1) {
    getpath (whichside, &path);
    /* XXX */
    command=malloc((strlen("mtype \" :")+strlen(path)+256+strlen("\" | ")+strlen(lprcommand)+1)*sizeof(char));
    items = GTK_CLIST (whichside->list)->selection;
    while (items) {
      row = (gint) items->data;
      gtk_clist_get_text (GTK_CLIST (whichside->list), row, 1, &text);
      if (! ((dentry *)gtk_clist_get_row_data (GTK_CLIST (whichside->list),row))->dir) {
	if (whichside->drive) {
	  strcpy (command, "mtype \" :");
	  command[7] = whichside->drive;
	  strcat (command, path);
	  strcat (command, text);
	  strcat (command, "\" | ");
	  strcat (command, lprcommand);
	  /* XXX */
	  lc_change(1);
	  set_main_window_state(0);
	  system (command);
	  set_main_window_state(1);
	  lc_change(2);
	}
	else {
	  strcpy (command, lprcommand);
	  strcat (command, " \"");
	  strcat (command, path);
	  strcat (command, text);
	  strcat (command, "\"");
	  lc_change(1);
	  set_main_window_state(0);
	  system (command);
	  set_main_window_state(1);
	  lc_change(2);
	}
      }
      items = items->next;
    }
    free (path);
    free (command);
  }
  if (debug)
    printf ("End fileprint_event()\n");
}

void util1_event (GtkWidget * widget, gpointer data) {
  /* This function handles the gzip, gunzip, bzip2, bunzip2
   * items in the utility menu
   */
  side * whichside = ((callbackopt *) data)->whichside;
  int msg = ((callbackopt *) data)->message;
  GList *items;
  gint row;
  char *text;
  char *path;
  char *filename;
  int outpipe[2];
  int childpid,status,lex_result;
  FILE *outfile;

  if (debug)
    printf ("In util1_event()\n");

  /* for the moment, this is only possible on a mounted unix filesystem */
  if (!whichside->drive) {
    getpath (whichside, &path);
    filename=malloc ((strlen(path) + 300) * sizeof (char));
    items = GTK_CLIST (whichside->list)->selection;
    while (items) {
      row = (gint) items->data;
      gtk_clist_get_text (GTK_CLIST (whichside->list), row, 1, &text);
      strcpy (filename, path);
      strcat (filename, text);
      if (! ((dentry *)gtk_clist_get_row_data (GTK_CLIST (whichside->list),row))->dir) {
	if (pipe (outpipe) < 0) {
	  printf ("  Error with pipe()\n");
	  gtk_main_quit ();
	}
	if ((childpid = fork ()) < 0) {
	  printf ("  Error with fork()\n");
	  exit (-1);
	}
	else if (childpid == 0) {
	  if (debug)
	    printf ("  in child\n");
	  lc_change(1);
	  close (outpipe[0]);
	  if (outpipe[1] != STDERR_FILENO)
	    if (dup2 (outpipe[1], STDERR_FILENO) != STDERR_FILENO) {
	      printf ("  Error with dup2()\n");
	      gtk_main_quit ();
	    }
	  if (outpipe[1] != STDOUT_FILENO) 
	    if (dup2 (outpipe[1], STDOUT_FILENO) != STDOUT_FILENO) {
	      printf ("  Error with dup2()\n");
	      gtk_main_quit ();
	    }
	  close (outpipe[1]);
	  if (msg==0) 
	    execlp("gzip","gzip","-f",filename,NULL);
	  else if (msg==1) 
	    execlp("gunzip","gunzip","-f",filename,NULL);
	  else if (msg==2) 
	    execlp("bzip2","bzip2","-f",filename,NULL);
	  else  
	    execlp("bunzip2","bunzip2","-f",filename,NULL);
	  perror ("  error in execlp()\n");
	  _exit (-1);
	}
	else {
	  if (debug)
	    printf ("  in parent\n");
	  close (outpipe[1]);
	  if ((outfile = fdopen (outpipe[0], "r")) == NULL) {
	    perror ("  Error while opening pipe for reading\n");
	    gtk_main_quit ();
	  }
	  lex_result = er_interface (outfile,stdout);
	  while(1) {
	    while (gtk_events_pending ())
	      gtk_main_iteration ();
	    if (waitpid (childpid, &status, WNOHANG) == childpid) {
	      waitpid (childpid, &status, WUNTRACED);
	      break;
	    }
	  }
	}
      }
      items = items->next;
    }
    free (path);
    free (filename);
    if (debug)
      printf ("  calling refresh_event()\n");
    refresh_event (whichside->list, whichside);
    refresh_event (whichside->other->list, whichside->other);
  } else 
    warnme(ONLY_ON_UNIX_TITLE,ONLY_ON_UNIX_MSG);
  if (debug)
    printf ("End util1_event()\n");
}

void util2_event (GtkWidget * widget, gpointer data) {
  /* This function handles the tar (create) and zip
   * items in the utility menu
   */
  side * whichside = ((callbackopt *) data)->whichside;
  int msg = ((callbackopt *) data)->message;
  GList *items;
  gint row;
  char *text;
  char *path;
  char outfilename[300];
  int outpipe[2];
  int childpid,status,lex_result;
  FILE *outfile;

  if (debug)
    printf ("In util2_event()\n");

  /* for the moment, this is only possible on a mounted unix filesystem */
  if (!whichside->drive) {
    getpath (whichside, &path);
    items = GTK_CLIST (whichside->list)->selection;
    while (items) {
      row = (gint) items->data;
      gtk_clist_get_text (GTK_CLIST (whichside->list), row, 1, &text);
      if(items==GTK_CLIST(whichside->list)->selection) {
	strcpy(outfilename,text);
	if(msg==0) {
	  strcat(outfilename,".tar");
	  if ((entertext (TAR_TITLE,TAR_QUESTION, outfilename, 259) != 1)||(strlen(outfilename)<1)) 
	    break;
	} else {
	  strcat(outfilename,".zip");
	  if ((entertext (ZIP_TITLE,ZIP_QUESTION, outfilename, 259) != 1)||(strlen(outfilename)<1)) 
	    break;
	}
      }
      if (pipe (outpipe) < 0) {
	printf ("  Error with pipe()\n");
	gtk_main_quit ();
      }
      if ((childpid = fork ()) < 0) {
	printf ("  Error with fork()\n");
	exit (-1);
      }
      else if (childpid == 0) {
	if (debug)
	  printf ("  in child\n");
	lc_change(1);
	close (outpipe[0]);
	if (outpipe[1] != STDERR_FILENO)
	  if (dup2 (outpipe[1], STDERR_FILENO) != STDERR_FILENO) {
	    printf ("  Error with dup2()\n");
	    gtk_main_quit ();
	  }
	if (outpipe[1] != STDOUT_FILENO) 
	  if (dup2 (outpipe[1], STDOUT_FILENO) != STDOUT_FILENO) {
	    printf ("  Error with dup2()\n");
	    gtk_main_quit ();
	  }
	close (outpipe[1]);
	if(msg==0) {
	  chdir(path);
	  if(items==GTK_CLIST(whichside->list)->selection)
	    execlp ("tar","tar","cf", outfilename, text, NULL);
	  else
	    execlp ("tar","tar","rf", outfilename, text, NULL);
	}
	else {
	  chdir(path);
	  execlp ("zip","zip","-r9","-q",outfilename, text, NULL);
	}
	perror ("  error in execlp()\n");
	_exit (-1);
      }
      else {
	if (debug)
	  printf ("  in parent\n");
	close (outpipe[1]);
	if ((outfile = fdopen (outpipe[0], "r")) == NULL) {
	  perror ("  Error while opening pipe for reading\n");
	  gtk_main_quit ();
	}
	lex_result = er_interface (outfile,stdout);
	while(1) {
	  while (gtk_events_pending ())
	    gtk_main_iteration ();
	  if (waitpid (childpid, &status, WNOHANG) == childpid) {
	    waitpid (childpid, &status, WUNTRACED);
	    break;
	  }
	}
      }
      items = items->next;
    }
    free (path);
    if (debug)
      printf ("  calling refresh_event()\n");
    refresh_event (whichside->list, whichside);
    refresh_event (whichside->other->list, whichside->other);
  } else 
    warnme(ONLY_ON_UNIX_TITLE,ONLY_ON_UNIX_MSG);
  if (debug)
    printf ("End util1_event()\n");
}

void util3_event (GtkWidget * widget, gpointer data) {
  /* This function handles the tar (extract) and unzip
   * items in the utility menu
   */
  side * whichside = ((callbackopt *) data)->whichside;
  int msg = ((callbackopt *) data)->message;
  GList *items;
  gint row;
  char *text;
  char *path;
  int outpipe[2];
  int childpid,status,lex_result;
  FILE *outfile;

  if (debug)
    printf ("In util2_event()\n");

  /* for the moment, this is only possible on a mounted unix filesystem */
  if (!whichside->drive) {
    getpath (whichside, &path);
    items = GTK_CLIST (whichside->list)->selection;
    while (items) {
      row = (gint) items->data;
      gtk_clist_get_text (GTK_CLIST (whichside->list), row, 1, &text);
      if (pipe (outpipe) < 0) {
	printf ("  Error with pipe()\n");
	gtk_main_quit ();
      }
      if ((childpid = fork ()) < 0) {
	printf ("  Error with fork()\n");
	exit (-1);
      }
      else if (childpid == 0) {
	if (debug)
	  printf ("  in child\n");
	lc_change(1);
	close (outpipe[0]);
	if (outpipe[1] != STDERR_FILENO)
	  if (dup2 (outpipe[1], STDERR_FILENO) != STDERR_FILENO) {
	    printf ("  Error with dup2()\n");
	    gtk_main_quit ();
	  }
	if (outpipe[1] != STDOUT_FILENO) 
	  if (dup2 (outpipe[1], STDOUT_FILENO) != STDOUT_FILENO) {
	    printf ("  Error with dup2()\n");
	    gtk_main_quit ();
	  }
	close (outpipe[1]);
	chdir(path);
	if(msg==0) 
	  execlp ("tar","tar","xf", text, NULL);
	else 
	  execlp ("unzip","unzip","-qq",text, NULL);
	perror ("  error in execlp()\n");
	_exit (-1);
      }
      else {
	if (debug)
	  printf ("  in parent\n");
	close (outpipe[1]);
	if ((outfile = fdopen (outpipe[0], "r")) == NULL) {
	  perror ("  Error while opening pipe for reading\n");
	  gtk_main_quit ();
	}
	lex_result = er_interface (outfile,stdout);
	while(1) {
	  while (gtk_events_pending ())
	    gtk_main_iteration ();
	  if (waitpid (childpid, &status, WNOHANG) == childpid) {
	    waitpid (childpid, &status, WUNTRACED);
	    break;
	  }
	}
      }
      items = items->next;
    }
    free (path);
    if (debug)
      printf ("  calling refresh_event()\n");
    refresh_event (whichside->list, whichside);
    refresh_event (whichside->other->list, whichside->other);
  } else 
    warnme(ONLY_ON_UNIX_TITLE,ONLY_ON_UNIX_MSG);
  if (debug)
    printf ("End util1_event()\n");
}

void util_split_event (GtkWidget * widget, side * whichside) {
  /* This function handles the split item in the utility menu */
  GList *items;
  gint row;
  char *text,*prefix;
  char *path,*pathbak;
  int outpipe[2];
  int childpid,status,lex_result;
  long int splitsize=0;
  static int i=0;
  char sizestring[30];
  FILE *outfile,*batfile;

  if (debug)
    printf ("In util_split_event()\n");

  /* for the moment, this is only possible on a mounted unix filesystem */
  if (!whichside->drive) {
    if((entersplitsize(&splitsize)==1)&&splitsize) {
      snprintf(sizestring,29,"-b%i",splitsize);
      getpath (whichside, &path);
      pathbak=path+strlen(path);
      items = GTK_CLIST (whichside->list)->selection;
      while (items) {
	row = (gint) items->data;
	gtk_clist_get_text (GTK_CLIST (whichside->list), row, 1, &text);
	snprintf(pathbak,300,"split-%i.bat",i);
	if(!(batfile=fopen(path,"w"))) {
	  warnme(NOT_EN_MEM_TIT,NOT_EN_MEM_MSG);
	  break;
	}
	snprintf(pathbak,300,"split-%i.",i);
	fprintf(batfile,"copy /b ");
	if (pipe (outpipe) < 0) {
	  printf ("  Error with pipe()\n");
	  gtk_main_quit ();
	}
	if ((childpid = fork ()) < 0) {
	  printf ("  Error with fork()\n");
	  exit (-1);
	}
	else if (childpid == 0) {
	  if (debug)
	    printf ("  in child\n");
	  lc_change(1);
	  close (outpipe[0]);
	  if (outpipe[1] != STDERR_FILENO)
	    if (dup2 (outpipe[1], STDERR_FILENO) != STDERR_FILENO) {
	      printf ("  Error with dup2()\n");
	      gtk_main_quit ();
	    }
	  if (outpipe[1] != STDOUT_FILENO) 
	    if (dup2 (outpipe[1], STDOUT_FILENO) != STDOUT_FILENO) {
	      printf ("  Error with dup2()\n");
	      gtk_main_quit ();
	    }
	  close (outpipe[1]);
	  prefix=strdup(pathbak);
	  *pathbak='\0';
	  chdir(path);
	  execlp ("split","split","--verbose",sizestring, text, prefix, NULL);
	  perror ("  error in execlp()\n");
	  _exit (-1);
	}
	else {
	  if (debug)
	    printf ("  in parent\n");
	  close (outpipe[1]);
	  if ((outfile = fdopen (outpipe[0], "r")) == NULL) {
	    perror ("  Error while opening pipe for reading\n");
	    gtk_main_quit ();
	  }
	  lex_result = er_interface (outfile,batfile);
	  while(1) {
	    while (gtk_events_pending ())
	      gtk_main_iteration ();
	    if (waitpid (childpid, &status, WNOHANG) == childpid) {
	      waitpid (childpid, &status, WUNTRACED);
	      break;
	    }
	  }
	}
	items = items->next;
	i++;
	*pathbak='\0';
	fprintf(batfile," %s\n",text);
	fclose(batfile);
      }
      free (path);
      if (debug)
	printf ("  calling refresh_event()\n");
      refresh_event (whichside->list, whichside);
      refresh_event (whichside->other->list, whichside->other);
    } else if (!splitsize) {
      warnme(NULL_FILESIZE_TITLE,NULL_FILESIZE_MSG);
    }
  } else 
    warnme(ONLY_ON_UNIX_TITLE,ONLY_ON_UNIX_MSG);
  if (debug)
    printf ("End util1_event()\n");
}

void mkdir_event (GtkWidget * widget, side * whichside) {
  /* This function handles Make directory item in the file menu */
  int flag;
  char *path, *filebegin;
  pid_t childpid;
  int copypipe[2];
  FILE *mcopyout;
  int status, lex_result;

  if (debug)
    printf ("In mkdir_event()\n");

  getpath (whichside, &path);
  if (whichside->drive) {
    shiftstring (path, 2);
    path[0] = whichside->drive;
    path[1] = ':';
  }
  filebegin = path + strlen (path);

  strcpy (filebegin,NEW_DIRECTORY_NAME);
  if((flag=entertext(MKDIR_TITLE,MKDIR_QUESTION,
			 filebegin, 255)) == 1) {
    if (whichside->drive) {
      if (pipe (copypipe) < 0) {
	printf ("  Error with pipe()\n");
	gtk_main_quit ();
      }
      if ((childpid = fork ()) < 0) {
	printf ("  Error with fork()\n");
	exit (-1);
      }
      else if (childpid == 0) {
	if (debug)
	  printf ("  in child\n");
	lc_change(1);
	close (copypipe[0]);
	if (copypipe[1] != STDERR_FILENO) {
	  if (dup2 (copypipe[1], STDERR_FILENO) != STDERR_FILENO) {
	    printf ("  Error with dup2()\n");
	    gtk_main_quit ();
	  }
	  close (copypipe[1]);
	}
	execlp("mtools", "mmd", path, NULL);
	printf ("  error in execlp()\n");
	printf ("  errno:%d\n", errno);
	_exit (-1);
      }
      else {
	if (debug)
	  printf ("  in parent\n");
	close (copypipe[1]);
	if ((mcopyout = fdopen (copypipe[0], "r")) == NULL) {
	  printf ("  Error while opening pipe for reading\n");
	  gtk_main_quit ();
	}
	lex_result = er_interface (mcopyout,stdout);
	while (1) {
	  while (gtk_events_pending ())
	    gtk_main_iteration ();
	  if (waitpid (childpid, &status, WNOHANG) == childpid) {
	    waitpid (childpid, &status, WUNTRACED);
	    break;
	  }
	}
      }
    }
    else 
      mkdir (path, 0777);
  }
  free (path);
  refresh_event (whichside->list, whichside);
  if (debug)
    printf ("End mkdir_event()\n");
}

void about_event (GtkWidget * widget, GdkEvent * event, gpointer Data) {
  /* This function handles the about item in the help menu */
  char *string=malloc(strlen(ABOUTMTOOLSFM_1)+strlen(ABOUTMTOOLSFM_2)+sizeof(char));
  if (debug)
    printf ("In about_event()\n");
  strcpy(string,ABOUTMTOOLSFM_1);
  
  strcat(string,ABOUTMTOOLSFM_2);
  warnme (ABOUT_TITLE, string);
  free(string);
}

void use_event (GtkWidget * widget, GdkEvent * event, gpointer Data) {
  /* This function handles the How to use item in the help menu */
  if (debug)
    printf ("In use_event()\n");
  warnme (USE_TITLE, HELP_USE);
}

void largefile_event (GtkWidget * widget, GdkEvent * event, gpointer Data) {
  /* This function handles the Copying large files item in the help menu */
  if (debug)
    printf ("In largefile_event()\n");
  warnme (LARGEFILE_TITLE, LARGEFILE_HELP);
}

void command_event (GtkWidget * widget, GdkEvent * event, gpointer Data) {
  /* This function handles the Command line options item in the help menu */
  char *string=malloc(strlen(MTOOLSFMOPTIONS_1)+strlen(MTOOLSFMOPTIONS_2)+strlen(CONFFILE)+sizeof(char));
  if (debug)
    printf ("In command_event()\n");
  strcpy(string,MTOOLSFMOPTIONS_1);
  strcat(string,CONFFILE);
  strcat(string,MTOOLSFMOPTIONS_2);
  warnme (COMMAND_TITLE, string);
  free(string);
}

void combo_change (GtkWidget * widget, side * whichside) {
  /* This function reacts to changes in the combobox for the driveletter. 
   * It will will clear the list where the current path for the concerned 
   * window part is stored, get the cwd if the new drive letter is on the
   * UNIX filesystem and refresh directory contents
   */
  char *string;
  if (debug)
    printf ("In combo_change()\n");
  string = gtk_entry_get_text (GTK_ENTRY (widget));
  if (strcmp (string, "Harddisk")) {
    whichside->drive = string[0];
    clearpath (whichside);
  }
  else {
    whichside->drive = '\0';
    clearpath (whichside);
    gethdpath (whichside);
  }
  refresh_event (whichside->list, whichside);
  if (debug)
    printf ("End combo_change()\n");
  return;
}

gint dclick_callback (GtkWidget * widget, gint row,
		      gint column, GdkEventButton * event, side * whichside) {
  /* This functions reacts to a doubleclick in the filelists. It will
   * cd if the item that was clicked on is a directory or a link pointing
   * at a directory.
   */
  long totsize = 0;
  GList *items;
  char *path, *drivepath;
  if (debug)
    printf ("In dclick_callback()\n");
  items = GTK_CLIST (whichside->list)->selection;
  while (items) {
    totsize+=((dentry *)gtk_clist_get_row_data (GTK_CLIST (whichside->list),
						(int) (items->data)))->size;
    items = items->next;
  }
  whichside->totsize = totsize;
  getpath (whichside, &path);
  drivepath = malloc(strlen (path)+strlen(SELECTED_IN)+30*sizeof (char));
  sprintf (drivepath, "%li %s ", totsize, SELECTED_IN);
  if (whichside->drive)
    sprintf (drivepath + strlen (drivepath), "%c:", whichside->drive);
  strcat (drivepath, path);
  gtk_statusbar_pop (GTK_STATUSBAR (whichside->status), whichside->context);
  gtk_statusbar_push (GTK_STATUSBAR (whichside->status),
		      whichside->context, drivepath);
  free (path);
  free (drivepath);
  if (event && (event->type == GDK_2BUTTON_PRESS)) {
    gchar *text;
    if (debug)
      printf ("  doubleclick\n");
    gtk_clist_unselect_row (GTK_CLIST (widget), row, column);
    gtk_clist_get_text (GTK_CLIST (widget), row, 1, &text);
    if ( ((dentry *) gtk_clist_get_row_data (GTK_CLIST (whichside->list), row))->dir) {
      if (strcmp (text, "..") && (whichside->length < DIR_DEPTH - 1)) {
	whichside->path[whichside->length] =
	  (gchar *) malloc ((strlen (text) + 1) * sizeof (gchar));
	strcpy (whichside->path[whichside->length], text);
	whichside->length += 1;
      }
      else if (whichside->length) {
	whichside->length -= 1;
	free (whichside->path[whichside->length]);
      }
      refresh_event (widget, whichside);
    }
  }
  if (debug)
    printf ("End dclick_callback()\n");
  return (FALSE);
}

gint rclick_callback (GtkWidget * widget, GdkEventButton * event, side * whichside) {
  /* This function reacts to a click with the right mouse button in one of 
   * the two filelists. It will display a popup menu.
   */
  if (debug)
    printf ("In rclick_callback()\n");
  if (event && (event->type == GDK_BUTTON_PRESS) && (event->button == 3)) {
    gtk_menu_popup (GTK_MENU (whichside->contextmenu),
		    NULL, NULL, NULL, NULL, event->button, event->time);
    return (TRUE);
  }
  else
    return (FALSE);
}

gint sort_callback (GtkWidget * widget, gint column, side * whichside) {
  /* This function will be called when the user clicks onto the column titles 
   * in one of the two file lists. The sort_column will then be set to the 
   * column the user clicked onto and the list will be sorted. 
   */
  if (debug)
    printf ("In sort_callback()\n");
  if (column > 0) {
    gtk_clist_set_sort_column (GTK_CLIST (whichside->list), column);
    gtk_clist_sort (GTK_CLIST (whichside->list));
  }
  return (TRUE);
}

void sort_now( GtkCheckMenuItem * MenuItem, side * left ) {
  /* This function reacts to the List directories always first
   * option in the main menu. It will just trigger a new sort of 
   * list since the sort algorithm asks for the status of that 
   * toggle menu item itself.
   */
  gtk_clist_sort( GTK_CLIST(left->list) );
  gtk_clist_sort( GTK_CLIST(left->other->list) );
}

int datecompare (const char *text1, const char *text2) {
  /* This function compares to date strings as stored and displayed in 
   * the file lists.
   */
  int comp;
  if (!text2)
    return (text1 != NULL);
  if (!text1)
    return -1;
  if ((comp = memcmp (text1 + 6, text2 + 6, 4)) < 0)
    return -1;
  else if (comp > 0)
    return 1;
  if ((comp = memcmp (text1, text2, 2)) < 0)
    return -1;
  else if (comp > 0)
    return 1;
  if ((comp = memcmp (text1 + 3, text2 + 3, 2)) < 0)
    return -1;
  else if (comp > 0)
    return 1;
  return 0;
}

static gint sortnew (GtkCList * clist, gconstpointer ptr1, gconstpointer ptr2) {
  /* This is the sort algorithm for the file lists which replaces the built-in 
   * function of GTK. 
   */
  char *name1 = NULL;
  char *name2 = NULL;
  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;
  dentry *d1 = (dentry *) row1->data;
  dentry *d2 = (dentry *) row2->data;
  name1 = GTK_CELL_TEXT (row1->cell[1])->text;
  name2 = GTK_CELL_TEXT (row2->cell[1])->text;
  if(GTK_CHECK_MENU_ITEM (dirfirst)->active)
    if( (d1->dir + d2->dir) & 1 )
      return (d1->dir < d2->dir);
  if (clist->sort_column == 2)
    return(d1->size < d2->size);
  else if ((clist->sort_column == 3) || (clist->sort_column == 4)) {
    char *textdate1 = NULL;
    char *textdate2 = NULL;
    char *texttime1 = NULL;
    char *texttime2 = NULL;
    int comp;
    textdate1 = GTK_CELL_TEXT (row1->cell[3])->text;
    textdate2 = GTK_CELL_TEXT (row2->cell[3])->text;
    texttime1 = GTK_CELL_TEXT (row1->cell[4])->text;
    texttime2 = GTK_CELL_TEXT (row2->cell[4])->text;
    if ((comp = datecompare (textdate1, textdate2)))
      return comp;
    return (strcmp (texttime1, texttime2));
  }
  else
    return (*default_compare_func) (clist, ptr1, ptr2);
}

void resize_event(GtkWidget *widget, GdkEventConfigure *event, side *left) {
  /* This function will be called whenever the main window is resized
   * and makes sure that the left and the right file list always have 
   * the same size.
   */
  side *right=left->other;
  int boxwidth;
  if (debug)
    printf ("In resize_event()\n");
  boxwidth=(widget->allocation.width-30-middlebox->allocation.width)/2;
  gtk_widget_set_usize (left->box, boxwidth, 200);
  gtk_widget_set_usize (right->box, boxwidth, 200);
}

GtkWidget *create_side (side * whichside, char *copytext) {
  /* This will create a file list. It will be called twice 
   * from main() to create the two file lists (left and right). 
   * It also creates the menus for the list and the popup menu
   * as well as the combo boy for the drive letter.
   */
  GtkItemFactory *item_factory;
  GtkWidget *popup_item;
  GtkWidget *box, *inbox, *menubar;
  callbackopt *msg; 
#ifndef OLDGTK
  GtkWidget *scroll;
#endif
  GtkItemFactoryEntry side_menu_items[] = 
    {{_("/_File"),                  NULL, NULL, 0, "<Branch>"},
     {_("/File/Delete"),            NULL, NULL, 0, NULL      },
     {_("/File/Rename"),            NULL, NULL, 0, NULL      },
     {_("/File/Print"),             NULL, NULL, 0, NULL      },
     {_("/File/Make directory"),    NULL, NULL, 0, NULL      },
     {_("/_View"),                  NULL, NULL, 0, "<Branch>"},
     {_("/View/Refresh"),           NULL, NULL, 0, NULL      },
     {_("/_Select"),                NULL, NULL, 0, "<Branch>"},
     {_("/Select/All"),             NULL, NULL, 0, NULL      },
     {_("/Select/None"),            NULL, NULL, 0, NULL      },
     {_("/_Utility"),               NULL, NULL, 0, "<Branch>"},
     {_("/Utility/tar (create)"),   NULL, NULL, 0, NULL      },
     {_("/Utility/tar (extract)"),  NULL, NULL, 0, NULL      },
     {_("/Utility/gzip"),           NULL, NULL, 0, NULL      },
     {_("/Utility/gunzip"),         NULL, NULL, 0, NULL      },
     {_("/Utility/bzip2"),          NULL, NULL, 0, NULL      },
     {_("/Utility/bunzip2"),        NULL, NULL, 0, NULL      },
     {_("/Utility/split"),          NULL, NULL, 0, NULL      },
     {_("/Utility/zip"),            NULL, NULL, 0, NULL      },
     {_("/Utility/unzip"),          NULL, NULL, 0, NULL      }};

  int i;

  if (debug)
    printf ("In create_side()\n");

  msg=malloc(4*sizeof(callbackopt));
  for(i=0;i<=3;i++) {
    msg[i].message=i;
    msg[i].whichside=whichside;
  }
    
  box = gtk_vbox_new (FALSE, 5);
  whichside->box=box;

  /* menubar, combobox for drive */
  inbox = gtk_hbox_new (FALSE, 0);
  item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", NULL);
  gtk_item_factory_create_items (item_factory,
				 sizeof (side_menu_items) /
				 sizeof (side_menu_items[0]), side_menu_items, NULL);
  menubar = gtk_item_factory_get_widget (item_factory, "<main>");
  gtk_signal_connect (GTK_OBJECT
		      (gtk_item_factory_get_widget
		       (item_factory, _("/File/Delete"))),
		      "activate", GTK_SIGNAL_FUNC (filedelete_event), whichside);
  gtk_signal_connect (GTK_OBJECT
		      (gtk_item_factory_get_widget
		       (item_factory, _("/File/Rename"))),
		      "activate", GTK_SIGNAL_FUNC (filerename_event), whichside);
  gtk_signal_connect (GTK_OBJECT
		      (gtk_item_factory_get_widget
		       (item_factory, _("/File/Print"))),
		      "activate", GTK_SIGNAL_FUNC (fileprint_event), whichside);
  gtk_signal_connect (GTK_OBJECT
		      (gtk_item_factory_get_widget
		       (item_factory, _("/File/Make directory"))),
		      "activate", GTK_SIGNAL_FUNC (mkdir_event), whichside);
  gtk_signal_connect (GTK_OBJECT
		      (gtk_item_factory_get_widget
		       (item_factory, _("/View/Refresh"))),
		      "activate", GTK_SIGNAL_FUNC (refresh_event), whichside);
  gtk_signal_connect (GTK_OBJECT
		      (gtk_item_factory_get_widget
		       (item_factory, _("/Select/All"))),
		      "activate", GTK_SIGNAL_FUNC (selectall_event), whichside);
  gtk_signal_connect (GTK_OBJECT
		      (gtk_item_factory_get_widget
		       (item_factory, _("/Select/None"))),
		      "activate", GTK_SIGNAL_FUNC (selectnone_event), whichside);
  gtk_signal_connect (GTK_OBJECT
		      (gtk_item_factory_get_widget
		       (item_factory, _("/Utility/tar (create)"))),
		      "activate", GTK_SIGNAL_FUNC (util2_event), msg);
  gtk_signal_connect (GTK_OBJECT
		      (gtk_item_factory_get_widget
		       (item_factory, _("/Utility/tar (extract)"))),
		      "activate", GTK_SIGNAL_FUNC (util3_event), msg);
  gtk_signal_connect (GTK_OBJECT
		      (gtk_item_factory_get_widget
		       (item_factory, _("/Utility/gzip"))),
		      "activate", GTK_SIGNAL_FUNC (util1_event), msg);
  gtk_signal_connect (GTK_OBJECT
		      (gtk_item_factory_get_widget
		       (item_factory, _("/Utility/gunzip"))),
		      "activate", GTK_SIGNAL_FUNC (util1_event), msg+1);
  gtk_signal_connect (GTK_OBJECT
		      (gtk_item_factory_get_widget
		       (item_factory, _("/Utility/bzip2"))),
		      "activate", GTK_SIGNAL_FUNC (util1_event), msg+2);
  gtk_signal_connect (GTK_OBJECT
		      (gtk_item_factory_get_widget
		       (item_factory, _("/Utility/bunzip2"))),
		      "activate", GTK_SIGNAL_FUNC (util1_event), msg+3);
  gtk_signal_connect (GTK_OBJECT
		      (gtk_item_factory_get_widget
		       (item_factory, _("/Utility/split"))),
		      "activate", GTK_SIGNAL_FUNC (util_split_event), whichside);
  gtk_signal_connect (GTK_OBJECT
		      (gtk_item_factory_get_widget
		       (item_factory, _("/Utility/zip"))),
		      "activate", GTK_SIGNAL_FUNC (util2_event), msg+1);
  gtk_signal_connect (GTK_OBJECT
		      (gtk_item_factory_get_widget
		       (item_factory, _("/Utility/unzip"))),
		      "activate", GTK_SIGNAL_FUNC (util3_event), msg+1);
  gtk_box_pack_start (GTK_BOX (inbox), menubar, TRUE, TRUE, 5);
  whichside->combo = gtk_combo_new ();
  whichside->comboglist = NULL;
#ifndef OLDGTK
  gtk_widget_set_usize (whichside->combo, 80, 0);
#endif
  gtk_entry_set_editable (GTK_ENTRY
			  (GTK_COMBO (whichside->combo)->entry), FALSE);
  set_combo_entries (whichside);
  if (!whichside->drive)
    gethdpath (whichside);
  gtk_box_pack_end (GTK_BOX (inbox), whichside->combo, FALSE, TRUE, 5);
  gtk_widget_show (menubar);
  gtk_widget_show (whichside->combo);
  gtk_box_pack_start (GTK_BOX (box), inbox, FALSE, TRUE, 0);
  gtk_widget_show (inbox);
  gtk_signal_connect (GTK_OBJECT
		      (GTK_COMBO (whichside->combo)->entry), "changed",
		      GTK_SIGNAL_FUNC (combo_change), whichside);
  /* clist and scrollbars */
#ifndef OLDGTK
  scroll = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW
				  (scroll),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start (GTK_BOX (box), scroll, TRUE, TRUE, 0);
#endif
  whichside->list = gtk_clist_new (5);
  gtk_clist_column_titles_show (GTK_CLIST (whichside->list));
  gtk_clist_set_selection_mode (GTK_CLIST
				(whichside->list), GTK_SELECTION_EXTENDED);
  gtk_clist_column_titles_passive (GTK_CLIST (whichside->list));
#ifndef OLDGTK
  gtk_container_add (GTK_CONTAINER (scroll), whichside->list);
#else
  gtk_clist_set_policy (GTK_CLIST (whichside->list),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start (GTK_BOX (box), whichside->list, TRUE, TRUE, 0);
#endif
  gtk_clist_set_column_title (GTK_CLIST (whichside->list), 0, (gchar *) "");
  gtk_clist_set_column_title (GTK_CLIST
			      (whichside->list), 1, (gchar *) FILENAME);
  gtk_clist_set_column_title (GTK_CLIST
			      (whichside->list), 2, (gchar *) SIZE);
  gtk_clist_set_column_title (GTK_CLIST
			      (whichside->list), 3, (gchar *) DATE);
  gtk_clist_set_column_title (GTK_CLIST
			      (whichside->list), 4, (gchar *) TIME);
#ifdef NOPIXMAPS
  gtk_clist_set_column_width (GTK_CLIST (whichside->list), 0, 0);
#else
  gtk_clist_set_column_width (GTK_CLIST (whichside->list), 0, 20);
#endif
  gtk_clist_set_column_width (GTK_CLIST (whichside->list), 1, 110);
  gtk_clist_set_column_width (GTK_CLIST (whichside->list), 2, 50);
  gtk_clist_set_column_width (GTK_CLIST (whichside->list), 3, 75);
  gtk_clist_set_column_width (GTK_CLIST (whichside->list), 4, 30);
  gtk_clist_set_column_justification (GTK_CLIST
				      (whichside->list),
				      2, GTK_JUSTIFY_RIGHT);
  gtk_clist_set_sort_column (GTK_CLIST (whichside->list), 1);
  gtk_clist_set_auto_sort (GTK_CLIST (whichside->list), FALSE);
  gtk_signal_connect (GTK_OBJECT (whichside->list),
		      "select_row",
		      GTK_SIGNAL_FUNC (dclick_callback), whichside);
  gtk_signal_connect (GTK_OBJECT (whichside->list),
		      "unselect_row",
		      GTK_SIGNAL_FUNC (dclick_callback), whichside);
  gtk_signal_connect (GTK_OBJECT (whichside->list),
		      "button-press-event",
		      GTK_SIGNAL_FUNC (rclick_callback), whichside);
  gtk_signal_connect (GTK_OBJECT (whichside->list),
		      "click-column",
		      GTK_SIGNAL_FUNC (sort_callback), whichside);
  default_compare_func = GTK_CLIST (whichside->list)->compare;
  gtk_clist_set_compare_func (GTK_CLIST (whichside->list), sortnew);
  gtk_widget_show (whichside->list);
#ifndef OLDGTK
  gtk_widget_show (scroll);
#endif

  /* status bar */
  whichside->status = gtk_statusbar_new ();
  gtk_box_pack_start (GTK_BOX (box), whichside->status, FALSE, TRUE, 0);
  whichside->context=gtk_statusbar_get_context_id (GTK_STATUSBAR
						   (whichside->status), "left window");
  gtk_statusbar_pop (GTK_STATUSBAR (whichside->status), whichside->context);
  gtk_statusbar_push (GTK_STATUSBAR (whichside->status),
		      whichside->context, "");
  gtk_widget_show (whichside->status);
  gtk_widget_show (box);
  /* context menu */
  whichside->contextmenu = gtk_menu_new ();
  popup_item = gtk_menu_item_new_with_label (DELETE);
  gtk_menu_append (GTK_MENU (whichside->contextmenu), popup_item);
  gtk_signal_connect (GTK_OBJECT (popup_item),"activate",
		      GTK_SIGNAL_FUNC (filedelete_event), whichside);
  gtk_widget_show (popup_item);
  popup_item = gtk_menu_item_new_with_label (RENAME);
  gtk_menu_append (GTK_MENU (whichside->contextmenu), popup_item);
  gtk_signal_connect (GTK_OBJECT (popup_item),"activate",
		      GTK_SIGNAL_FUNC (filerename_event), whichside);
  gtk_widget_show (popup_item);
  popup_item = gtk_menu_item_new_with_label (PRINT);
  gtk_menu_append (GTK_MENU (whichside->contextmenu), popup_item);
  gtk_signal_connect (GTK_OBJECT (popup_item),"activate",
		      GTK_SIGNAL_FUNC (fileprint_event), whichside);
  gtk_widget_show (popup_item);
  popup_item = gtk_menu_item_new_with_label (copytext);
  gtk_menu_append (GTK_MENU (whichside->contextmenu), popup_item);
  gtk_signal_connect (GTK_OBJECT (popup_item),"activate", 
		      GTK_SIGNAL_FUNC (copy_event), whichside);
  gtk_widget_show (popup_item);
  popup_item = gtk_menu_item_new_with_label (MKDIR);
  gtk_menu_append (GTK_MENU (whichside->contextmenu), popup_item);
  gtk_signal_connect (GTK_OBJECT (popup_item),"activate", 
		      GTK_SIGNAL_FUNC (mkdir_event), whichside);
  gtk_widget_show (popup_item);

/*   popup_item = gtk_menu_item_new_with_label ("Utility"); */
/*   gtk_menu_append (GTK_MENU (whichside->contextmenu), popup_item); */
/*   gtk_widget_show (popup_item); */
/*   gtk_menu_item_set_submenu(GTK_MENU_ITEM(popup_item), */
/* 			    gtk_item_factory_get_widget */
/* 			    (item_factory,_("/Utility"))); */

  if (debug)
    printf ("End create_side()\n");
  return (box);
}

int main (int argc, char *argv[]) {
  /* This is the main function. Its only purpose is to read in the config file,
   * display and create the widgets, connect some signals and then call 
   * gtk_main().
   */
  GtkWidget *menubar;
  GtkWidget *box, *inbox, *hbox;
  GtkWidget *button;
  GtkTooltips *tooltips;
  GtkWidget *outscrollbar, *vpaned;
#ifndef NOPIXMAPS
  GtkStyle *style;
#endif
  GdkColor dircolor, linkcolor;
  side left, right;
  GtkItemFactory *item_factory;
  GtkAccelGroup *accel_group;
  char *cfname;
  int i, nosysconf = 0, nouserconf = 0, aflag = 1, bflag = 1;
  gtk_set_locale();
  gtk_init (&argc, &argv);
  bindtextdomain (PACKAGE, LOCALEDIR);
  textdomain (PACKAGE);
  putenv ("MTOOLS_DATE_STRING=mm-dd-yyyy");
  putenv ("MTOOLS_TWENTY_FOUR_HOUR_CLOCK=1");
  for (i = 1; i < argc; i++) {
    if (!strcmp (argv[i], "--nosysconf"))
      nosysconf = 1;
    else if (!strcmp (argv[i], "--nouserconf"))
      nouserconf = 1;
    else if (!strcmp (argv[i], "--save"))
      nosave = 0;
    else if (!strcmp (argv[i], "--nosave"))
      nosave = 1;
    else if (!strcmp (argv[i], "-v"))
      debug = 1;
    else if (!strcmp (argv[i], "--debug"))
      debug = 1;
    else if (!strcmp (argv[i], "--help")) {
      g_print ("\n%s%s\n%s%s%s\n",ABOUTMTOOLSFM_1,ABOUTMTOOLSFM_2,
	       MTOOLSFMOPTIONS_1,CONFFILE,MTOOLSFMOPTIONS_2);
      exit (0);
    }
    else {
      g_print ("\n%s %s\n", UNKNOWN_OPTION, argv[i]);
      g_print ("\n%s%s%s\n", MTOOLSFMOPTIONS_1,CONFFILE,MTOOLSFMOPTIONS_2);
      exit (0);
    }
  }
  left.other = &right;
  right.other = &left;
  if (debug) {
    printf ("In main():\n");
    printf ("  left : %p\n", &left);
    printf ("  right: %p\n", &right);
    printf ("  left.other : %p\n", left.other);
    printf ("  right.other: %p\n", right.other);
  }
  left.length = 0;
  right.length = 0;
  left.drive = '\0';
  right.drive = '\0';
  /* XXX strcpy (mpath, MTOOLSDIR); */
  left.comboglist = NULL;
  right.comboglist = NULL;
  if (!nosysconf)
    aflag = read_configfile (&left, CONFFILE);
  homedir = g_get_home_dir ();
  cfname = malloc ((strlen (homedir) + 11) * sizeof (char));
  strcpy (cfname, homedir);
  strcat (cfname, "/.mtoolsfm");
  if (!nouserconf)
    bflag = read_configfile (&left, cfname);
  /* XXX if (!(*mpath)) */
  /* XXX   strcpy (mpath, MTOOLSDIR); */
  /* XXX strcpy (mtoolscommand, mpath);*/
  /* XXX strcat (mtoolscommand, "/mtools"); */
  if (aflag && bflag)
    strcpy (drives, "a");
  if (debug) {
    /* XXX printf ("  mpath: %s+\n", mpath); */
    printf ("  cfname: %s+\n", cfname);
    printf ("  drives: %s+\n", drives);
  }
  free (cfname);
  mainwindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_events(GTK_WIDGET(mainwindow),GDK_EXPOSURE_MASK);
  gtk_signal_connect (GTK_OBJECT(mainwindow), "configure_event", GTK_SIGNAL_FUNC (resize_event), &left);
  gtk_window_set_title (GTK_WINDOW (mainwindow), "MToolsFM " VERSION);
  gtk_signal_connect (GTK_OBJECT (mainwindow),
		      "delete_event",
		      GTK_SIGNAL_FUNC (delete_event),
		      &left); vpaned = gtk_vpaned_new ();
  gtk_container_add (GTK_CONTAINER (mainwindow), vpaned);
  gtk_widget_show (vpaned);
  gtk_widget_set_usize (GTK_WIDGET (mainwindow), 750, 400);
  box = gtk_vbox_new (FALSE, 0);
  gtk_paned_pack1 (GTK_PANED (vpaned), box, TRUE, TRUE);
  tooltips = gtk_tooltips_new ();
  /* menu */
  {
    GtkItemFactoryEntry main_menu_items[] = {
      {_("/_File"),                             NULL,         NULL,            0,     "<Branch>"    },
      {_("/File/Quit"),                         "<control>Q", NULL,            0,     NULL          },
      {_("/_Options"),                          NULL,         NULL,            0,     "<Branch>"    },
      {_("/Options/Directories first in list"), NULL,         NULL,            0,     "<CheckItem>" },
      {_("/Options/Show dot files"),            "<control>D", NULL,            0,     "<CheckItem>" },
      {_("/Options/Text mode for copying"),     "<control>T", NULL,            0,     "<CheckItem>" },
      {_("/Options/Separator"),                 NULL,         NULL,            0,     "<Separator>" },
      {_("/Options/Configure MToolsFM ..."),    "<control>C", NULL,            0,     NULL          },
      {_("/_Help"),                             NULL,         NULL,            0,     "<LastBranch>"},
      {_("/_Help/Command line options"),        NULL,         command_event,   0,     NULL          },
      {_("/_Help/How to use"),                  NULL,         use_event,       0,     NULL          },
      {_("/_Help/Copying large files"),         NULL,         largefile_event, 0,     NULL          },
      {_("/_Help/About"),                       NULL,         about_event,     0,     NULL          }};
    
    accel_group = gtk_accel_group_new ();
    item_factory=gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", accel_group);
    gtk_item_factory_create_items (item_factory,
				   sizeof (main_menu_items) /
				   sizeof (main_menu_items[0]), main_menu_items, NULL);
    gtk_accel_group_attach (accel_group, GTK_OBJECT (mainwindow));
    menubar = gtk_item_factory_get_widget (item_factory, "<main>");
    gtk_signal_connect (GTK_OBJECT(gtk_item_factory_get_widget(item_factory,_("/File/Quit"))),
			"activate", GTK_SIGNAL_FUNC (quit_event), &left);
    gtk_signal_connect (GTK_OBJECT(gtk_item_factory_get_widget(item_factory,_("/Options/Configure MToolsFM ..."))),
			"activate", GTK_SIGNAL_FUNC (config_event), &left);
     
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(gtk_item_factory_get_widget(item_factory, _("/Options/Directories first in list"))),TRUE);
    dirfirst=gtk_item_factory_get_widget (item_factory,_("/Options/Directories first in list"));
    showdots=gtk_item_factory_get_widget (item_factory,_("/Options/Show dot files"));
    textmode=gtk_item_factory_get_widget (item_factory,_("/Options/Text mode for copying"));
    gtk_signal_connect (GTK_OBJECT (showdots), "toggled",
			GTK_SIGNAL_FUNC (refresh_event), &left);
    gtk_signal_connect (GTK_OBJECT (showdots), "toggled",
			GTK_SIGNAL_FUNC (refresh_event), &right);
    gtk_signal_connect (GTK_OBJECT (dirfirst), "toggled",
			GTK_SIGNAL_FUNC (sort_now), &left);
     
    gtk_box_pack_start (GTK_BOX (box), menubar, FALSE, TRUE, 0);
    gtk_widget_show (menubar);
  }
  inbox = gtk_hbox_new (FALSE, 0);
#ifndef OLDGTK
  gtk_container_set_border_width (GTK_CONTAINER (inbox), 5);
#endif
  gtk_box_pack_start (GTK_BOX (box), inbox, TRUE, TRUE, 0);
  gtk_widget_show (box);
  /* left */
  gtk_box_pack_start (GTK_BOX (inbox),
		      create_side (&left, COPY_L2R_CONTEXT), TRUE, TRUE, 0);
  /* middle */
  middlebox = gtk_vbox_new (FALSE, 10);
  gtk_box_pack_start (GTK_BOX (inbox), middlebox, FALSE, TRUE, 10);
  button = gtk_button_new_with_label (COPY_L2R_BUTTON);
  gtk_tooltips_set_tip (tooltips, button,COPY_L2R_TOOLTIP, NULL);
  gtk_box_pack_start (GTK_BOX (middlebox), button, TRUE, FALSE, 10);
  gtk_widget_show (button);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (copy_event), &left);
#ifndef NOPIXMAPS
  logobutton=gtk_button_new();
  button = gtk_button_new_with_label (COPY_R2L_BUTTON);
  gtk_box_pack_start (GTK_BOX (middlebox), logobutton, TRUE, FALSE, 10);
  gtk_widget_show (logobutton);
#endif
  gtk_tooltips_set_tip (tooltips, button,
			COPY_R2L_TOOLTIP, NULL);
  gtk_box_pack_start (GTK_BOX (middlebox), button, TRUE, FALSE, 10);
  gtk_widget_show (button);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (copy_event), &right);
  gtk_widget_show (middlebox);
  /* right */
  gtk_box_pack_end (GTK_BOX (inbox),
		    create_side (&right, COPY_R2L_CONTEXT), TRUE, TRUE, 0);
  gtk_widget_show (inbox);
  /* a text widget for the stderr output of subprocesses */
  hbox = gtk_hbox_new (FALSE, 0);
#ifndef OLDGTK
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
#endif
  gtk_paned_pack2 (GTK_PANED (vpaned), hbox, FALSE, TRUE);
  gtk_widget_set_usize (GTK_WIDGET (hbox), -1, 70);
  outtext = gtk_text_new (NULL, NULL);
  gtk_text_set_editable (GTK_TEXT (outtext), FALSE);
  gtk_box_pack_start (GTK_BOX (hbox), outtext, TRUE, TRUE, 0);
  gtk_text_insert (GTK_TEXT (outtext), NULL, NULL, NULL, ERRORWINDOW_INTRO, -1);
  outscrollbar = gtk_vscrollbar_new (GTK_TEXT (outtext)->vadj);
  gtk_box_pack_start (GTK_BOX (hbox), outscrollbar, FALSE, FALSE, 0);
  gtk_widget_show (outscrollbar);
  gtk_widget_show (outtext);
  gtk_widget_show (hbox);
  /* allocate colors */
  dircolor.red = 0;
  dircolor.green = 0;
  dircolor.blue = 65535;
  dircolor.pixel = (gulong) 255;
  gdk_color_alloc (gtk_widget_get_colormap (mainwindow), &dircolor);
  left.dircolor = &dircolor;
  right.dircolor = &dircolor;
  linkcolor.red = 98 * 255;
  linkcolor.green = 170 * 255;
  linkcolor.blue = 78 * 255;
  linkcolor.pixel = (gulong) 255;
  gdk_color_alloc (gtk_widget_get_colormap (mainwindow), &linkcolor);
  left.linkcolor = &linkcolor;
  right.linkcolor = &linkcolor;
  /*  show all */
  gtk_widget_show (mainwindow);
#ifndef NOPIXMAPS
  style = gtk_widget_get_style (mainwindow);
  logopix=gdk_pixmap_create_from_xpm_d (mainwindow->window, &logomask,
				       &style->bg[GTK_STATE_NORMAL],
				       (gchar **) xpm_logo);
  logopixwid = gtk_pixmap_new (logopix, logomask);
  gtk_widget_show(logopixwid);
  gtk_container_add(GTK_CONTAINER(logobutton),logopixwid);
  gtk_signal_connect (GTK_OBJECT (logobutton), "clicked",
		      GTK_SIGNAL_FUNC (about_event), NULL);

  clock1pix=gdk_pixmap_create_from_xpm_d (mainwindow->window, &clock1mask,
				       &style->bg[GTK_STATE_NORMAL],
				       (gchar **) xpm_clock1);
  clock1pixwid = gtk_pixmap_new (clock1pix, clock1mask);
  gtk_widget_show(clock1pixwid);
  gtk_widget_ref(clock1pixwid);

  clock2pix=gdk_pixmap_create_from_xpm_d (mainwindow->window, &clock2mask,
				       &style->bg[GTK_STATE_NORMAL],
				       (gchar **) xpm_clock2);
  clock2pixwid = gtk_pixmap_new (clock2pix, clock2mask);
  gtk_widget_show(clock2pixwid);
  gtk_widget_ref(clock2pixwid);

  clock3pix=gdk_pixmap_create_from_xpm_d (mainwindow->window, &clock3mask,
				       &style->bg[GTK_STATE_NORMAL],
				       (gchar **) xpm_clock3);
  clock3pixwid = gtk_pixmap_new (clock3pix, clock3mask);
  gtk_widget_show(clock3pixwid);
  gtk_widget_ref(clock3pixwid);

  dirpix=gdk_pixmap_create_from_xpm_d (mainwindow->window, &dirmask,
				       &style->bg[GTK_STATE_NORMAL],
				       (gchar **) xpm_dir);
  filepix=gdk_pixmap_create_from_xpm_d (mainwindow->window,
					&filemask,
					&style->bg[GTK_STATE_NORMAL],
					(gchar **) xpm_file);
  linkdirpix=gdk_pixmap_create_from_xpm_d (mainwindow->window,
					   &linkdirmask,
					   &style->bg[GTK_STATE_NORMAL],
					   (gchar **) xpm_linkdir);
  linkfilepix=gdk_pixmap_create_from_xpm_d (mainwindow->window,
					    &linkfilemask,
					    &style->bg[GTK_STATE_NORMAL],
					    (gchar **) xpm_linkfile);
  mtoolsfmpix=gdk_pixmap_create_from_xpm_d (mainwindow->window, &mtoolsfmmask,
					    &style->bg[GTK_STATE_NORMAL],
					    (gchar **) xpm_mtoolsfm);
  gdk_window_set_icon (mainwindow->window, NULL, mtoolsfmpix, mtoolsfmmask);
#endif
  while (gtk_events_pending ())
    gtk_main_iteration ();
  mtools_version_check();
  refresh_event (left.list, &left);
  refresh_event (right.list, &right);
  gtk_main ();

  if (debug)
    printf ("End main()\n");
  return (0);
}
