/* Copyright (C) 1999 Beau Kuiper

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "../../config.h"

#ifndef HAVE_STRERROR

#include "strerror.h"

/* this was generated using vi on a linux system. May not work on yours */

char *strerror(int errnum)
{
	switch (errnum)
	{
		case EPERM : { return("Operation not permitted"); }; 
		case ENOENT : { return("No such file or directory"); }; 
		case ESRCH : { return("No such process"); }; 
		case EINTR : { return("Interrupted system call"); }; 
		case EIO : { return("I/O error"); }; 
		case ENXIO : { return("No such device or address"); }; 
		case E2BIG : { return("Arg list too long"); };
		case ENOEXEC : { return("Exec format error"); }; 
		case EBADF : { return("Bad file number"); }; 
		case ECHILD : { return("No child processes"); }; 
		case EAGAIN : { return("Try again"); }; 
		case ENOMEM : { return("Out of memory"); }; 
		case EACCES : { return("Permission denied"); }; 
		case EFAULT : { return("Bad address"); }; 
		case ENOTBLK : { return("Block device required"); }; 
		case EBUSY : { return("Device or resource busy"); }; 
		case EEXIST : { return("File exists"); }; 
		case EXDEV : { return("Cross-device link"); }; 
		case ENODEV : { return("No such device"); }; 
		case ENOTDIR : { return("Not a directory"); }; 
		case EISDIR : { return("Is a directory"); }; 
		case EINVAL : { return("Invalid argument"); }; 
		case ENFILE : { return("File table overflow"); }; 
		case EMFILE : { return("Too many open files"); }; 
		case ENOTTY : { return("Not a typewriter"); }; 
		case ETXTBSY : { return("Text file busy"); }; 
		case EFBIG : { return("File too large"); }; 
		case ENOSPC : { return("No space left on device"); }; 
		case ESPIPE : { return("Illegal seek"); }; 
		case EROFS : { return("Read-only file system"); }; 
		case EMLINK : { return("Too many links"); }; 
		case EPIPE : { return("Broken pipe"); }; 
		case EDOM : { return("Math argument out of domain of func"); }; 
		case ERANGE : { return("Math result not representable"); }; 
		case EDEADLK : { return("Resource deadlock would occur"); }; 
		case ENAMETOOLONG : { return("File name too long"); }; 
		case ENOLCK : { return("No record locks available"); }; 
		case ENOSYS : { return("Function not implemented"); }; 
		case ENOTEMPTY : { return("Directory not empty"); }; 
		case ELOOP : { return("Too many symbolic links encountered"); }; 
		case ENOMSG : { return("No message of desired type"); }; 
		case EIDRM : { return("Identifier removed"); }; 
		case ENOSTR : { return("Device not a stream"); }; 
		case ETIME : { return("Timer expired"); }; 
		case ENOSR : { return("Out of streams resources"); }; 
		case ENONET : { return("Machine is not on the network"); }; 
		case EREMOTE : { return("Object is remote"); }; 
		case ENOLINK : { return("Link has been severed"); }; 
		case EADV : { return("Advertise error"); }; 
		case ESRMNT : { return("Srmount error"); }; 
		case ECOMM : { return("Communication error on send"); }; 
		case EPROTO : { return("Protocol error"); }; 
		case EMULTIHOP : { return("Multihop attempted"); }; 
		case EDOTDOT : { return("RFS specific error"); }; 
		case EBADMSG : { return("Not a data message"); }; 
		case EREMCHG : { return("Remote address changed"); }; 
		case EUSERS : { return("Too many users"); }; 
		case ENOTSOCK : { return("Socket operation on non-socket"); }; 
		case EDESTADDRREQ : { return("Destination address required"); }; 
		case EMSGSIZE : { return("Message too long"); }; 
		case EPROTOTYPE : { return("Protocol wrong type for socket"); }; 
		case ENOPROTOOPT : { return("Protocol not available"); }; 
		case EPROTONOSUPPORT : { return("Protocol not supported"); }; 
		case ESOCKTNOSUPPORT : { return("Socket type not supported"); }; 
		case EOPNOTSUPP : { return("Operation not supported on transport endpoint"); }; 
		case EPFNOSUPPORT : { return("Protocol family not supported"); }; 
		case EAFNOSUPPORT : { return("Address family not supported by protocol"); }; 
		case EADDRINUSE : { return("Address already in use"); }; 
		case EADDRNOTAVAIL : { return("Cannot assign requested address"); }; 
		case ENETDOWN : { return("Network is down"); }; 
		case ENETUNREACH : { return("Network is unreachable"); }; 
		case ENETRESET : { return("Network dropped connection because of reset"); }; 
		case ECONNABORTED : { return("Software caused connection abort"); }; 
		case ECONNRESET : { return("Connection reset by peer"); }; 
		case ENOBUFS : { return("No buffer space available"); }; 
		case EISCONN : { return("Transport endpoint is already connected"); }; 
		case ENOTCONN : { return("Transport endpoint is not connected"); }; 
		case ESHUTDOWN : { return("Cannot send after transport endpoint shutdown"); }; 
		case ETOOMANYREFS : { return("Too many references: cannot splice"); }; 
		case ETIMEDOUT : { return("Connection timed out"); }; 
		case ECONNREFUSED : { return("Connection refused"); }; 
		case EHOSTDOWN : { return("Host is down"); }; 
		case EHOSTUNREACH : { return("No route to host"); }; 
		case EALREADY : { return("Operation already in progress"); }; 
		case EINPROGRESS : { return("Operation now in progress"); }; 
		case ESTALE : { return("Stale NFS file handle"); }; 
		case EDQUOT : { return("Quota exceeded"); }; 
		default : { return("Unknown Error"); };
	}
}

#endif /* HAVE_STRERROR */
