/* 
   MultiSync Opie Plugin - Synchronize Opie/Zaurus Devices
   Copyright (C) 2003 Tom Foottit <tom@foottit.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License version 2 as
   published by the Free Software Foundation;

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF THIRD PARTY RIGHTS.
   IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) AND AUTHOR(S) BE LIABLE FOR ANY
   CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES 
   WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN 
   ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF 
   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

   ALL LIABILITY, INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PATENTS, 
   COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS, RELATING TO USE OF THIS 
   SOFTWARE IS DISCLAIMED.
*/

/*
 *  $Id: opie_log.c,v 1.1 2003/07/11 21:21:04 irix Exp $
 */

#include "opie_log.h"
#include <stdio.h>
#include <sys/time.h>

void debug_msg(opie_conn* conn, const char* msg, const char* file, const int line)
{
#ifdef _OPIE_LOG_DEBUG
  char* filename;
  FILE* fd;
  struct tm* now;
  time_t now_t;
  
  if(!msg)
    return;
  
  now_t = time(0);
  now = gmtime(&now_t);

  filename = g_strdup_printf("%s/opie_sync.log",
                             sync_get_datapath(conn->sync_pair));

  if(fd = fopen(filename, "a"))
  {
    fprintf(fd, "(%s[%d] - %04d/%02d/%02d %02d:%02d.%02d)  %s\n",
            file,
            line,
            now->tm_year + 1900,
            now->tm_mon + 1,
            now->tm_mday,
            now->tm_hour,
            now->tm_min,
            now->tm_sec,
            msg);
    fflush(fd);
    fclose(fd); 
  }
  
  g_free(filename);
  
#endif
}
