//waveform.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010
 *
 *  This file is part of RoarD,
 *  a sound server daemon for using the RoarAudio protocol.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  or (at your option) any later version as published by
 *  the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include "muroard.h"

int16_t * g_waveform_mixercore = NULL;

int waveform_init(void) {
 g_abuffer_size = g_sa_channels * 2 * MUROAR_DEFAULT_FRAMES_PER_CYCLE;

 if ( (g_waveform_mixercore = muroard_malloc(g_abuffer_size)) == NULL )
  return -1;

 return 0;
}

int waveform_free(void) {
 if ( g_waveform_mixercore != NULL )
  muroard_free(g_waveform_mixercore);

 return 0;
}

int waveform_update(void) {
#ifdef MUROAR_FEATURE_OPTIMIZE
 static ssize_t last_scount = -1;
#endif
 int16_t * out;
 int16_t * streams[MUROAR_MAX_STREAMS];
 size_t scount = 0;
 int i;

 for (i = 0; i < MUROAR_MAX_STREAMS; i++) {
  if ( stream_get_datadir(i) == STREAM_DATADIR_IN ) {
   streams[scount] = stream_get_iobuf(i);
   if ( streams[scount] != NULL )
    scount++;
  }
 }

#ifdef MUROAR_FEATURE_OPTIMIZE
 if ( last_scount == 0 ) {
  out = g_waveform_mixercore;
 } else {
#endif
  if ( scount == 1 ) {
   out = streams[0];
  } else {
   if ( dsp_mixer(g_waveform_mixercore, streams, scount) == -1 )
    return -1;
   out = g_waveform_mixercore;
  }
#ifdef MUROAR_FEATURE_OPTIMIZE
 }

 last_scount = scount;
#endif

 if ( driver_write(out) == -1 )
  return -1;

#ifdef MUROAR_FEATURE_MONITOR
 for (i = 0; i < MUROAR_MAX_STREAMS; i++) {
  if ( stream_get_datadir(i) == STREAM_DATADIR_OUT ) {
   stream_write(i, out);
  }
 }
#endif

 return 0;
}

//ll
