/********************************************************************
 *                                                                  *
 * cardtools.h                                                      *
 *                                                                  *
 ********************************************************************
 *                                                                  *
 * Authors:                                                         *
 *   Mario Strasser       <mast@gmx.net>                            *
 *   Martin Sgesser      <m.sagi@bluemail.ch>                      *
 *                                                                  *
 ********************************************************************
 *                                                                  *
 * Cardtools library.                                               *
 *                                                                  *
 * Usefull library for SmartCard-Programs.                          *
 *                                                                  *
 ********************************************************************/

#ifndef CARDTOOLS_H
#define CARDTOOLS_H

#include <winscard.h>
#include <stdlib.h>

#define VARIABLEEF  0x19
#define DIRFILE     0x20
#define BINARYFILE  0x02

#define MAXVALUES 11
#define PIN_SIZE  8

/**
* Establish a new context to the card reader.
*
* @param reader Which number of cardreader should be used
*
* @return 0 on success, -1 if failed
*
*/
int pcsc_init(MSCLPTokenConnection pConnection, int reader);

/**
* Release the card context
*
*/
void pcsc_release(MSCLPTokenConnection pConnection);

#endif
