//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: audionode.h,v 1.2 2001/11/20 15:19:31 muse Exp $
//
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __AUDIONODE_H__
#define __AUDIONODE_H__

#include "plugins/plugin.h"
#include "ssource.h"

class Xml;

//---------------------------------------------------------
//   AudioNode
//    Audio Producer  (source)
//    Audio Consumer  (sink)
//---------------------------------------------------------

class AudioNode : public SoundSource {
      Q_OBJECT
      AudioNode* _route;      // connection to consumer

   protected:
      Pipeline _efxPipe;
      double _volume;
      double _pan;            // stereoism
      bool _prefader;

   public:
      AudioNode();
      virtual ~AudioNode();

      virtual void segmentSizeChanged();

      // source
      void setRoute(AudioNode*);
      AudioNode* route() const    { return _route; }

      virtual void getData(float*, int) {}
      virtual void fillBuffer(int channel, float* buffer, int idx);

      virtual void setChannels(int c);
      void setPrefader(bool flag);
      bool prefader() const       { return _prefader; }
      double pan() const          { return _pan; }
      void setPan(double val)     { _pan = val; }
      double volume() const       { return _volume; }
      void setVolume(double val)  { _volume = val; }
      Pipeline* efxPipe()         { return &_efxPipe; }

      // sink
      virtual void connect(AudioNode*) {}
      virtual void disconnect(AudioNode*) {}

      void writeConfiguration(int, Xml&) const;
      void readConfiguration(Xml&);
      void readVolume(Xml& xml);
      };

QString node2String(AudioNode*);
AudioNode* string2Node(const QString&);

#endif

