//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: audiodev.h,v 1.2 2001/11/20 15:19:32 muse Exp $
//
//  (C) Copyright 1999/2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __AUDIODEV_H__
#define __AUDIODEV_H__

#include <list>
#include "device.h"

//---------------------------------------------------------
//   AudioDevice
//---------------------------------------------------------

class AudioDevice : public Device {

   protected:
      int _rwFlags;
      void init();

   public:
      int volL;
      int volR;
      int maxVolL;
      int maxVolR;
      int overflowL;
      int overflowR;

      AudioDevice();
      AudioDevice(const QString&);
      virtual ~AudioDevice();

      virtual int read(unsigned char* p, int n) = 0;
      virtual int write(const unsigned char* p, int n) = 0;
      virtual int selectrfd() const = 0;
      virtual int selectwfd() const = 0;
      virtual void start() const = 0;
      virtual void stop () const = 0;

      int rwFlags() const;
      void setrwFlags(int val) { _rwFlags = val; }
      };


class AudioDeviceList : public std::list<AudioDevice*> {
   public:
      void add(AudioDevice* dev) {
            push_back(dev);
            }
      AudioDevice* find(const QString& name);
      };

typedef AudioDeviceList::iterator iAudioDevice;

extern AudioDeviceList audioDevices;
#endif

