//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: mididev.cpp,v 1.4 2002/02/28 09:02:25 muse Exp $
//
//  (C) Copyright 1999/2000 Werner Schweer (ws@seh.de)
//=========================================================

#include <config.h>

#include <stdio.h>
#include <unistd.h>
#include <errno.h>

#include "midictrl.h"
#include "song.h"
#include "midi.h"
#include "seq.h"
#include "midiport.h"
#include "mididev.h"
#include "minstrument.h"
#include "config.h"
#include "event.h"

#ifdef MIDI_DRIVER_MIDI_SERIAL
extern void initMidiSerial();
#endif
#ifdef ALSA
extern void initMidiAlsa();
#endif

MidiDeviceList midiDevices;

//---------------------------------------------------------
//   init
//---------------------------------------------------------

void MidiDevice::init()
      {
      _rwFlags   = 0;
      _masterVol = 16383;
      _port      = -1;
      }

int MidiDevice::rwFlags() const
      {
      return _rwFlags;
      }
void MidiDevice::setrwFlags(int val)
      {
      _rwFlags = val;
      }

//---------------------------------------------------------
//   MidiDevice
//---------------------------------------------------------

MidiDevice::MidiDevice()
      {
      init();
      }

MidiDevice::MidiDevice(const QString& n)
   : Device(n, Device::MidiDevice)
      {
      init();
      }

MidiDevice::~MidiDevice()
      {
      }

//---------------------------------------------------------
//   setMasterVol
//---------------------------------------------------------

void MidiDevice::setMasterVol(int val)
      {
      _masterVol = val;
      unsigned char data[6] = { 0x7f, 0x7f, 0x04, 0x01, 0x00, 0x00 };
      data[4] = val & 0x7f;
      data[5] = (val >> 7) & 0x7f;
      MidiEvent event(0, 0, 0, MidiEvent::Sysex, 6, data);
      putEvent(&event);
      }

//---------------------------------------------------------
//   find
//---------------------------------------------------------

MidiDevice* MidiDeviceList::find(const QString& s)
      {
      for (iMidiDevice i = begin(); i != end(); ++i)
            if ((*i)->name() == s)
                  return *i;
      return 0;
      }

//---------------------------------------------------------
//   initMidiDevices
//---------------------------------------------------------

void initMidiDevices()
      {
#ifdef MIDI_DRIVER_MIDI_SERIAL
      initMidiSerial();
#endif
#ifdef ALSA
      initMidiAlsa();
#endif
      }

