//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: midictrl.h,v 1.2 2001/11/20 15:19:31 muse Exp $
//
//  (C) Copyright 1999/2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __MIDICTRL_H__
#define __MIDICTRL_H__

#include <list>
#include <qstring.h>
#include "ccontrolbase.h"

const int CTRL_HBANK = 0x00;
const int CTRL_MODULATION = 0x01;
const int CTRL_PORTAMENTO_TIME = 0x05;
const int CTRL_HDATA = 0x06;
const int CTRL_VOLUME = 0x07;
const int CTRL_PANPOT = 0x0a;
const int CTRL_EXPRESSION = 0x0b;
const int CTRL_LBANK = 0x20;
const int CTRL_LDATA = 0x26;
const int CTRL_SUSTAIN = 0x40;
const int CTRL_PORTAMENTO = 0x41;
const int CTRL_SOSTENUTO = 0x42;
const int CTRL_SOFT_PEDAL = 0x43;
const int CTRL_HARMONIC_CONTENT = 0x47;
const int CTRL_RELEASE_TIME = 0x48;
const int CTRL_ATTACK_TIME = 0x49;
const int CTRL_BRIGHTNESS = 0x4a;
const int CTRL_PORTAMENTO_CONTROL = 0x54;
const int CTRL_REVERB_SEND = 0x5b;
const int CTRL_CHORUS_SEND = 0x5d;
const int CTRL_VARIATION_SEND = 0x5e;
const int CTRL_LNRPN = 0x62;
const int CTRL_HNRPN = 0x63;
const int CTRL_LRPN = 0x64;
const int CTRL_HRPN = 0x65;

class Xml;

//---------------------------------------------------------
//   MidiController
//---------------------------------------------------------

class MidiController {
   public:
      enum ControllerType {
            Controller7, Controller14, RPN, NRPN, XgSysex,
            Sysex, Velo, Pitch
            };

   private:
      ControllerType _type;
      QString _name;
      int _hnum;        // MSB Controller Number
      int _lnum;        // LSB Controller Number
      int _minVal;
      int _maxVal;

   public:
      MidiController(ControllerType t, const QString& n)
         : _type(t), _name(n) {
            _hnum = 0;
            _minVal = 0;
            _maxVal = 127;
            }
      MidiController() : _name("Velocity") {
            _type   = Velo;
            _hnum   = 0;
            _lnum   = 0;
            _minVal = 0;
            _maxVal = 127;
            }
      ControllerType type() const         { return _type; }
      const QString& name() const         { return _name; }
      int hnum() const                    { return _hnum; }
      int lnum() const                    { return _lnum; }
      void setType(ControllerType t)      { _type = t; }
      void setName(const QString& s)      { _name = s; }
      void setHNum(int v)                 { _hnum = v; }
      void setLNum(int v)                 { _lnum = v; }
      void write(int level, Xml& xml) const;
      void read(Xml& xml);
      int minVal() const                  { return _minVal; }
      int maxVal() const                  { return _maxVal; }
      void setMinVal(int val)             { _minVal = val; }
      void setMaxVal(int val)             { _maxVal = val; }
      };

//---------------------------------------------------------
//   MidiControllerList
//---------------------------------------------------------

typedef std::list<MidiController*>::iterator iMidiController;

class MidiControllerList : public std::list<MidiController*> {
   public:
      };

//---------------------------------------------------------
//   MidiControllerEditDialog
//---------------------------------------------------------

class MidiControllerEditDialog : public MidiControllerEditDialogBase {
    Q_OBJECT

      void addControllerToView(MidiController* mctrl);

   private slots:
      void ctrlNew();
      void ctrlDelete();
      virtual void accept();
      void nameChanged(const QString&);
      void typeChanged(const QString&);
      void valueHChanged(int);
      void valueLChanged(int);
      void controllerChanged(QListViewItem*);
      void minChanged(int);
      void maxChanged(int);
      void saveAs();
      void load();

   public:
      MidiControllerEditDialog(QWidget* parent = 0, const char* name = 0, bool modal = false, WFlags fl = 0);
      };

extern void writeMidiController(int level, Xml& xml);
extern MidiController* readMidiController(Xml&);

extern MidiControllerList midiControllerList;
extern MidiControllerEditDialog* midiControllerEditDialog;
extern void configMidiController();
extern void addMidiController(MidiController::ControllerType
   type, int hval, int lval);
extern QString midiCtrl7Name(int);
extern QString midiCtrl14Name(int,int);

#endif

