//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: drumedit.h,v 1.2 2001/11/20 15:19:33 muse Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __DRUM_EDIT_H__
#define __DRUM_EDIT_H__

#include "midieditor.h"
#include "noteinfo.h"
#include "cobject.h"
#include "tools.h"
#include "header.h"

#include <qwidget.h>
#include <qmainwindow.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

class MidiEvent;
class MidiPart;
class QLabel;
class DrumCanvas;
class Track;
class ScrollScale;
class ScoreConfig;
class QToolButton;
class MTScale;
class Splitter;
class PartList;
class Toolbar1;
class CtrlCanvas;
class Xml;
class QPopupMenu;
class DList;
class Header;
class CtrlEdit;
class Event;
class Part;

//---------------------------------------------------------
//   DWhatsThis
//---------------------------------------------------------

class DWhatsThis : public QWhatsThis {
      Header* header;
   protected:
      QString text(const QPoint&);
   public:
      DWhatsThis(QWidget* parent, Header* h) : QWhatsThis(parent) {
            header = h;
            }
      };

//----------------------------------------------------------
//   DHeaderTip
//----------------------------------------------------------

class DHeaderTip : public QToolTip {
   public:
      DHeaderTip(QWidget * parent) : QToolTip(parent) {}
   protected:
      void maybeTip(const QPoint &);
      };

//---------------------------------------------------------
//   DrumEdit
//---------------------------------------------------------

class DrumEdit : public MidiEditor {
      MidiEvent* selEvent;
      MidiPart* selPart;
      int selTick;
      QPopupMenu* menuEdit;

      NoteInfo* info;
      QToolButton* srec;
      QToolButton* midiin;

      Toolbar1* toolbar;
      Splitter* split1;
      Splitter* split2;

      DList* dlist;
      Header* header;
      QToolBar* tools;

      static int _quantInit, _rasterInit;

      Q_OBJECT

      virtual void closeEvent(QCloseEvent*);
      QWidget* genToolbar(QWidget* parent);

   private slots:
      void setRaster(int);
      void setQuant(int);
      void noteinfoChanged(NoteInfo::ValType type, int val);
      CtrlEdit* addCtrl();
      void removeCtrl(CtrlEdit* ctrl);
      void cmd(int);
      void clipboardChanged(); // enable/disable "Paste"
      void selectionChanged(); // enable/disable "Copy" & "Paste"
      void load();
      void save();
      void setTime(int);
      void follow(int);
      void newCanvasWidth(int);

   public slots:
      void setSelection(int, Event*, Part*);
      void soloChanged(bool);       // called by Solo button
      void soloChanged(Track*);     // called by Song

   signals:
      void deleted(int);

   public:
      DrumEdit(PartList*, QWidget* parent = 0, const char* name = 0);
      ~DrumEdit();
      virtual void readStatus(Xml&);
      virtual void writeStatus(int, Xml&) const;
      static void readConfiguration(Xml& xml);
      static void writeConfiguration(int, Xml&);
      };

#endif
