//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: ecanvas.h,v 1.2 2001/11/20 15:19:33 muse Exp $
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __ECANVAS_H__
#define __ECANVAS_H__

#include "canvas.h"

class MidiPart;
class MidiTrack;
class MidiEditor;

//---------------------------------------------------------
//   EventCanvas
//---------------------------------------------------------

class EventCanvas : public Canvas {
      Q_OBJECT
      virtual void leaveEvent(QEvent*e);
      virtual void enterEvent(QEvent*e);
      virtual QPoint raster(const QPoint&) const;
      virtual void startUndo(bool);
      virtual void endUndo(bool);
      virtual void mouseMove(const QPoint&);

   protected:
      bool _playEvents;
      MidiEditor* editor;
      int start_tick, end_tick;
      int curVelo;
      bool _steprec;
      bool _midiin;

      void updateSelection();
      virtual void addItem(Part*, Event*) = 0;

   public slots:
      void setQuant(int)      { redraw(); }
      void setSteprec(bool f) { _steprec = f; }
      void setMidiin(bool f)  { _midiin = f; }

   signals:
      void pitchChanged(int);       // current cursor position
      void timeChanged(int);
      void selectionChanged(int, Event*, Part*);
      void enterCanvas();

   public:
      EventCanvas(MidiEditor*, QWidget*, int, int, const char* name = 0);
      MidiTrack* track() const;
      int start() const       { return start_tick; }
      int end() const         { return end_tick; }
      bool midiin() const     { return _midiin; }
      bool steprec() const    { return _steprec; }
      QString getCaption() const;
      void songChanged(int);
      void range(int* s, int* e) const { *s = start_tick; *e = end_tick; }
      void playEvents(bool flag) { _playEvents = flag; }
      };

#endif

