//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: amixer.h,v 1.2 2001/11/20 15:19:33 muse Exp $
//
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __AMIXER_H__
#define __AMIXER_H__

#include <qlayout.h>
#include <qpixmap.h>
#include <qlistbox.h>
#include <list>
#include "audiomix.h"

#include "cobject.h"
#include "synth.h"
#include "audioport.h"

#include <qtooltip.h>

class Xml;
class QWidget;
class QHBoxLayout;
class QScrollView;
class AudioThread;
class AudioNode;
class QGridLayout;

#define EFX_HEIGHT     16
#define MAX_CHANNEL     2     // only mono/stereo
#define MAX_PLUGINS     4

//---------------------------------------------------------
//   AudioMixerApp
//---------------------------------------------------------

class AudioMixerApp : public TopWin {
      QScrollView* view;
      QWidget* central;
      QHBoxLayout* lbox;
      QGridLayout* grid;

      Q_OBJECT

      virtual void closeEvent(QCloseEvent* e);
      void readStatus(Xml&);
      void writeStatus(int, Xml&) const;
      void genStrip(const QString& txt, int col, AudioNode*, int);
      void createMixer();

   signals:
      void deleted(int);

   private slots:
      void heartBeat();
      void recordToggled(bool, AudioNode*);
      void soloToggled(bool, AudioNode*);
      void muteToggled(bool, AudioNode*);
      void stereoToggled(bool, AudioNode*);
      void preToggled(bool, AudioNode*);
      void recFileDialog();

   public slots:
      void songChanged(int);

   public:
      AudioMixerApp();
      void updateMixer();
      };

#endif

