//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: meter.cpp,v 1.1 2002/01/30 12:08:38 muse Exp $
//
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#include <stdio.h>

#include <math.h>

#include "meter.h"
#include <qpainter.h>

extern int minMeter;

//---------------------------------------------------------
//   Meter
//---------------------------------------------------------

Meter::Meter(QWidget* parent)
   : QFrame(parent, "", WRepaintNoErase)
      {
      overflow    = false;
      val         = 0.0;
      maxVal      = 0.0;
      minScale    = minMeter;      // min value in dB
      maxScale    = 10;
      yellowScale = -10;
      redScale    = 0;
      setLineWidth(1);
      setMidLineWidth(0);
      setFrameStyle(Box | Raised);
      }

//---------------------------------------------------------
//   setVal
//---------------------------------------------------------

void Meter::setVal(int v, int max, bool ovl)
      {
      overflow = ovl;
      val      = double(v)/32767.0;
      maxVal   = double(max)/32767.0;
      update();
      }

//---------------------------------------------------------
//   resetPeaks
//    reset peak and overflow indicator
//---------------------------------------------------------

void Meter::resetPeaks()
      {
      maxVal   = val;
      overflow = val > 0.0;
      update();
      }

//---------------------------------------------------------
//   setRange
//---------------------------------------------------------

void Meter::setRange(double min, double max)
      {
      minScale = min;
      maxScale = max;
      update();
      }

//---------------------------------------------------------
//   paintEvent
//---------------------------------------------------------

void Meter::drawContents(QPainter* p)
      {
      double range = maxScale - minScale;

      int fw = frameWidth();
      int h  = height() - 2* fw;
      int yv = val == 0 ? h : int(((maxScale - (log10(val) * 20)) * h)/range);

      bitBlt(this, fw, fw,    &bgPm, 0, 0,  -1, yv,   CopyROP, true);
      bitBlt(this, fw, fw+yv, &fgPm, 0, yv, -1, h-yv, CopyROP, true);

      int ymax = maxVal == 0 ? 0 : int(((maxScale - (log10(maxVal) * 20)) * h)/range);
      p->setPen(white);
      p->drawLine(0, ymax, width()-2*fw, ymax);
      }

//---------------------------------------------------------
//   resizeEvent
//---------------------------------------------------------

void Meter::resizeEvent(QResizeEvent* ev)
      {
      int fw = frameWidth();

      double range = maxScale - minScale;
      int h  = ev->size().height() - 2*fw;
      int w  = ev->size().width()  - 2*fw;
      bgPm.resize(w, h);
      fgPm.resize(w, h);
      int y1 = int((maxScale - redScale) * h / range);
      int y2 = int((maxScale - yellowScale) * h / range);
      int y3 = h;

      QPainter p1(&fgPm);
      QPainter p2(&bgPm);

      p1.fillRect(0, 0,  w, y1,    QBrush(0xff0000));  // red
      p1.fillRect(0, y1, w, y2-y1, QBrush(0xffff00));  // yellow
      p1.fillRect(0, y2, w, y3-y2, QBrush(0x00ff00));  // green

      p2.fillRect(0, 0,  w, y1,    QBrush(0x8e0000));  // red
      p2.fillRect(0, y1, w, y2-y1, QBrush(0x8e8e00));  // yellow
      p2.fillRect(0, y2, w, y3-y2, QBrush(0x007000));  // green
      }

//---------------------------------------------------------
//   mousePressEvent
//---------------------------------------------------------

void Meter::mousePressEvent(QMouseEvent*)
      {
      emit mousePress();
      }

