//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: mixer.h,v 1.2 2001/11/20 15:19:33 muse Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __MIXER_H__
#define __MIXER_H__

#include <qmainwindow.h>
#include <qwidget.h>
#include "cobject.h"

#include <list>

#define QDial Dial

#define CHANNELS  16

class IntLabel;
class QSlider;
class QPushButton;
class QPixmap;
class File;
class Xml;

struct MixerLine {
      int index;
      int port;
      int channel;
      QSlider* volume;
      IntLabel* panpos;
      IntLabel* chorus;
      IntLabel* reverb;
      IntLabel* variation;
      QPushButton* mute;
      };

typedef std::list<MixerLine*> MixerLineList;
typedef MixerLineList::iterator iMixerLine;

//---------------------------------------------------------
//   Mixer
//---------------------------------------------------------

class Mixer: public TopWin {
      MixerLineList lines;

      QSlider* master;
      int port;
      virtual void closeEvent(QCloseEvent* e);

      Q_OBJECT
      void readStatus(Xml&);
      void writeStatus(int, Xml&) const;

   private slots:
      void valChanged(int);
      void masterChanged(int val);

   signals:
      void deleted(int);
      void ctrlChanged(int port, int chan, int ctrl, int val);
      void masterVolChanged(int val);

   public:
      Mixer();
      void updateValues(bool current = true);
      };

#endif

