//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: routecombo.cpp,v 1.1 2002/01/30 12:08:38 muse Exp $
//
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#include "../audiothread.h"
#include "routecombo.h"
#include <stdio.h>
#include "audioport.h"
#include "../driver/audiodev.h"
#include "song.h"

//---------------------------------------------------------
//   RouteComboBox
//---------------------------------------------------------

RouteComboBox::RouteComboBox(QWidget* parent, AudioNode* s)
   : QComboBox(false, parent, "route")
      {
      src = s;
      connect(this, SIGNAL(activated(const QString&)), SLOT(setRoute(const QString&)));
      }

//---------------------------------------------------------
//   setRoute
//---------------------------------------------------------

void RouteComboBox::setRoute(const QString& r)
      {
      AudioPort* port  = &audioPort;
      AudioDevice* dev = port->device();
      if (dev && (port->rwFlags() & 1)) {
            if (dev->name() == r) {
                  audioThread->msgAddRoute(src, port);
                  return;
                  }
            }
      if (r == "Master")
            audioThread->msgAddRoute(src, song->master());
      else if (r == "Group A")
            audioThread->msgAddRoute(src, song->group(0));
      else if (r == "Group B")
            audioThread->msgAddRoute(src, song->group(1));
      else if (r == "Group C")
            audioThread->msgAddRoute(src, song->group(2));
      else if (r == "Group D")
            audioThread->msgAddRoute(src, song->group(3));
      }


