//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: palettes.cpp,v 1.1 2002/01/30 12:08:38 muse Exp $
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#include <qbuttongroup.h>
#include <qpixmap.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include "palettes.h"
#include "score.h"
#include "symbols.h"

//---------------------------------------------------------
//   openDynamicsPalette
//---------------------------------------------------------

void Score::openDynamicsPalette()
      {
      if (dynPalette == 0) {
            WFlags f = WStyle_Customize
               | WStyle_DialogBorder
               | WStyle_Title;
            dynPalette        = new QWidget(0, "palette", f);
            QGridLayout* grid = new QGridLayout(dynPalette);
            dynPalette->setCaption(tr("Dynamics"));
            for (int i = 0; i < 12; ++i) {
                  QToolButton* b = new QToolButton(dynPalette);
                  b->setPixmap(*dynBM[i]);
                  b->setToggleButton(true);
                  paletteBg->insert(b, i);
                  grid->addWidget(b, i/3, i%3);
                  }
            }
      dynPalette->show();
      }

