//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: audioconf.cpp,v 1.3 2002/02/27 15:53:45 muse Exp $
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#include <qlabel.h>
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qgroupbox.h>

#include "audioconf.h"
#include "driver/audiodev.h"
#include "audioport.h"
#include "song.h"
#include "audiothread.h"

static int srate[] = { 44100, 48000, 96000 };
static int framesize[] = {
      32, 64, 128, 256, 512, 1024, 2048, 4096
      };

//---------------------------------------------------------
//   AudioConf
//    comboDelay
//    comboSampleRate
//    comboFrameSize
//    buttonRecord   (button group)
//    comboDevice
//---------------------------------------------------------

AudioConf::AudioConf(QWidget* parent, const char* name = 0)
   : AudioConfBase(parent, name, true)
      {
      updateValues();

      connect(buttonApply, SIGNAL(clicked()), SLOT(apply()));
      connect(comboDelay, SIGNAL(activated(int)), SLOT(delayChanged(int)));
      connect(comboFrameSize, SIGNAL(activated(int)), SLOT(frameSizeChanged(int)));
      connect(comboSampleRate, SIGNAL(activated(int)), SLOT(sampleRateChanged(int)));
      }

//---------------------------------------------------------
//   updateValues
//---------------------------------------------------------

void AudioConf::updateValues()
      {
      comboDevice->clear();
      comboDevice->insertItem(tr("none"), 0);
      int id = 1;
      int curDev = 0;
      for (iAudioDevice i = audioDevices.begin(); i != audioDevices.end(); ++i) {
            const QString s = (*i)->name();
            comboDevice->insertItem(s, id);
            if (audioPort.device() == *i)
                  curDev = id;
            ++id;
            }
      comboDevice->setCurrentItem(curDev);
      labelStatus->setText(audioPort.state());

      int idx;
      switch(sampleRate) {
            case 44100: idx = 0; break;
            case 48000: idx = 1; break;
            case 96000: idx = 2; break;
            default:
                  printf("illegal sample Rate %d\n", sampleRate);
                  exit(-1);
            }
      comboSampleRate->setCurrentItem(idx);

      switch(segmentSize) {
            case 32:    idx = 0; break;
            case 64:    idx = 1; break;
            case 128:   idx = 2; break;
            case 256:   idx = 3; break;
            case 512:   idx = 4; break;
            case 1024:  idx = 5; break;
            case 2048:  idx = 6; break;
            case 4096:  idx = 7; break;
            default:
                  printf("illegal segment size %d\n", segmentSize);
                  exit(-1);
            }
      comboFrameSize->setCurrentItem(idx);

      for (int i = 0; i < 8; ++i) {
            QString s;
            s.sprintf("%.2f", (double(framesize[i]) / double(sampleRate)) * 1000.0);
            comboDelay->insertItem(s, i);
            }
      comboDelay->setCurrentItem(idx);
      buttonRecord->setButton(audioPort.rwFlags());
      }

//---------------------------------------------------------
//   delayChanged
//---------------------------------------------------------

void AudioConf::delayChanged(int val)
      {
      comboFrameSize->setCurrentItem(val);
      }

//---------------------------------------------------------
//   frameSizeChanged
//---------------------------------------------------------

void AudioConf::frameSizeChanged(int val)
      {
      comboDelay->setCurrentItem(val);
      }

//---------------------------------------------------------
//   sampleRateChanged
//---------------------------------------------------------

void AudioConf::sampleRateChanged(int val)
      {
      double sr = double(srate[val]);
      comboDelay->clear();
      for (int i = 0; i < 8; ++i) {
            QString s;
            s.sprintf("%.2f", (double(framesize[i]) / sr) * 1000.0);
            comboDelay->insertItem(s, i);
            }
      comboDelay->setCurrentItem(comboFrameSize->currentItem());
      }

//---------------------------------------------------------
//   accept
//---------------------------------------------------------

void AudioConf::accept()
      {
      apply();
      AudioConfBase::accept();
      }

//---------------------------------------------------------
//   apply
//---------------------------------------------------------

void AudioConf::apply()
      {
      int frameSizeIndex = comboFrameSize->currentItem();
      int deviceIndex    = comboDevice->currentItem();
      int sampleIndex    = comboSampleRate->currentItem();

      int frameSize = framesize[frameSizeIndex];
      int sR   = srate[sampleIndex];
      int mode = buttonRecord->id(buttonRecord->selected());

      if (deviceIndex == 0) {
            audioPort.setrwFlags(0);
            audioThread->msgSetAudioDevice(&audioPort, 0);
            }
      else {
            int id = 1;
            for (iAudioDevice i = audioDevices.begin(); i != audioDevices.end(); ++i) {
                  if (deviceIndex == id) {
                        AudioDevice* dev = *i;
                        audioPort.setrwFlags(mode);
                        audioThread->msgSetAudioDevice(&audioPort, dev);  // reopen
                        break;
                        }
                  ++id;
                  }
            }
      if ((segmentSize != frameSize) || (sR != sampleRate)) {
            // TODO: this reopens() device again!
            if ((frameSize != segmentSize) || (sR != sampleRate)) {
                  audioThread->msgSetSegSize(frameSize, sR);
                  }
            }
      song->update();  // ??

      updateValues();   // show real values set
      }

