//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: mtscale.h,v 1.2 2001/11/20 15:19:35 muse Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __MTSCALE_H__
#define __MTSCALE_H__

#include "view.h"

class QPainter;

//---------------------------------------------------------
//   MTScale
//    scale for midi track
//---------------------------------------------------------

class MTScale : public View {
      Q_OBJECT
      int* raster;
      int pos[4];
      int button;
      bool barLocator;
      bool waveMode;

   private slots:
      void songChanged(int);

   protected:
      virtual void pdraw(QPainter&, const QRect&);
      virtual void viewMousePressEvent(QMouseEvent* event);
      virtual void viewMouseMoveEvent(QMouseEvent* event);
      virtual void viewMouseReleaseEvent(QMouseEvent* event);
      virtual void leaveEvent(QEvent*e);

   signals:
      void timeChanged(int);

   public slots:
      void setPos(int, int, bool);

   public:
      MTScale(int* raster, QWidget* parent, int xscale, bool f = false);
      void setBarLocator(bool f) { barLocator = f; }
      };
#endif

