//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: tools.cpp,v 1.1 2002/01/30 14:54:04 muse Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#include "tools.h"
#include <qpixmap.h>
#include <qbuttongroup.h>
#include <qtoolbutton.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include "icons.h"
#include "action.h"

const char* infoPointer = "select Pointer Tool:\n"
      "with the pointer tool you can:\n"
      "  select parts\n"
      "  move parts\n"
      "  copy parts";
const char* infoPencil = "select Pencil Tool:\n"
      "with the pencil tool you can:\n"
      "  create new parts\n"
      "  modify length of parts";
const char* infoDel = "select Delete Tool:\n"
      "with the delete tool you can delete parts";
const char* infoCut = "select Cut Tool:\n"
      "with the cut tool you can split a part";
const char* infoGlue = "select Glue Tool:\n"
      "with the glue tool you can glue two parts";
const char* infoScore = "select Score Tool:\n";
const char* infoQuant = "select Quantize Tool:\n"
      "insert display quantize event";
const char* infoDraw = "select Drawing Tool";

struct ToolB {
      QPixmap** icon;
      const char* tip;
      const char* ltip;
      } toolList[] = {
      {&pointerIcon, "pointer", infoPointer },
      {&pencilIcon,  "pencil",  infoPencil },
      {&deleteIcon,  "rubber",  infoDel },
      {&cutIcon,     "cutter",  infoCut },
      {&note1Icon,   "score",   infoScore },
      {&glueIcon,    "glue",    infoGlue },
      {&quantIcon,   "quantize",   infoQuant },
      {&drawIcon,    "draw",   infoDraw },
      };

//---------------------------------------------------------
//   EditToolBar
//---------------------------------------------------------

EditToolBar::EditToolBar(MainWindow* parent, int tools, const char* name = 0)
   : ToolBar("Edit Tools", parent, name)
      {
      QActionGroup* action = new QActionGroup(parent, "editaction", true);

      nactions = 0;
      for (unsigned i = 0; i < sizeof(toolList)/sizeof(*toolList); ++i) {
            if ((tools & (1 << i))==0)
                  continue;
            ++nactions;
            }
      actions = new Action*[nactions];
      bool first = true;
      int n = 0;
      for (unsigned i = 0; i < sizeof(toolList)/sizeof(*toolList); ++i) {
            if ((tools & (1 << i))==0)
                  continue;
            ToolB* t = &toolList[i];

            Action* a = new Action(action, 1<<i, t->tip, true);
            actions[n] = a;
            a->setIconSet(QIconSet(**(t->icon)));
            a->setToolTip(t->tip);
            a->setWhatsThis(t->ltip);
            if (first) {
                  a->setOn(true);
                  first = false;
                  }
            ++n;
            }
      action->addTo(this);
      connect(action, SIGNAL(selected(QAction*)), SLOT(toolChanged(QAction*)));
      }

//---------------------------------------------------------
//   toolChanged
//---------------------------------------------------------

void EditToolBar::toolChanged(QAction* action)
      {
      emit toolChanged(((Action*)action)->id());
      }

//---------------------------------------------------------
//   ~EditToolBar
//---------------------------------------------------------

EditToolBar::~EditToolBar()
      {
      delete actions;
      }

//---------------------------------------------------------
//   set
//---------------------------------------------------------

void EditToolBar::set(int id)
      {
      for (int i = 0; i < nactions; ++i) {
            Action* action = actions[i];
            if (action->id() == id) {
                  action->setOn(true);
                  return;
                  }
            }
      }

