//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: panknob.cpp,v 1.1.1.1 2003/10/29 10:05:23 wschweer Exp $
//
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#include <cmath>
#include "../audio.h"
#include "panknob.h"
#include "globals.h"

//---------------------------------------------------------
//   VolSlider
//---------------------------------------------------------

PanKnob::PanKnob(QWidget* parent, AudioNode* s)
   : Knob(parent, "pan")
      {
      src = s;
      connect(this, SIGNAL(valueChanged(double)), SLOT(valueChanged(double)));
      }

//---------------------------------------------------------
//   panChanged
//---------------------------------------------------------

void PanKnob::valueChanged(double val)
      {
      audio->msgSetPan(src, val);
      }


