/***************************************************************************
                          asyncfile.h  -  description
                             -------------------
    begin                : Sat Sep 1 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifndef __ASYNCFILE_H__
#define __ASYNCFILE_H__

enum {
	//AFM_NONE = 0,
	AFM_READ       = 0x0001,
	AFM_WRITE      = 0x0002,
	AFM_READWRITE  = 0x0003,
	AFM_CREATEPATH = 0x0004 // only valid with 'write' bit on
};

enum AFRType {
	AFR_NONE    = 0x0000,
	AFR_OPEN    = 0x0001,
	AFR_ATTACH  = 0x0002,
	AFR_SEEK    = 0x0004,
	AFR_PREREAD = 0x0008,
	AFR_READ    = 0x0010,
	AFR_WRITE   = 0x0020,
	AFR_CLOSE   = 0x0040,
	AFR_DETACH  = 0x0080,
	AFR_GETBUF  = 0x1000,
	AFR_WAIT    = 0x2000,
	AFR_FREE    = 0x4000, // delete the MAsyncFile object
	AFR_STOP    = 0x8000
};

struct AsyncFileRequest{
	DWORD dwAsyncFileID; // required for call-backs
	int   hFile; // File handle
	// completion info
	int  nErrNo;  // last error
	bool bEoF;    // feof() result after
	int  nReturn; // last value returned by fread or fwrite
	// in-out parameters
	long nFilePos;
	long nFileSize;
	
	// request itself
	//AFRType
	int type;
	int type_compl;
	// open parameters
	char* name;
	int   mode;
	// write/read/pre-read
	char* buffer;
	int   size;
	// seek
	long offset;
	long whence;
	// close has no parameters
};

class MAFThread;
//struct AsyncFileRequest;

class MAsyncFile {
friend class MAFThread;
public:
	MAsyncFile(int mode, int nBufSize = 4096);
	void Destroy(); // async destructor
	
	static void WaitForThreadsStop();
	
	// delayed diagnostics
	bool IsInProgress();
	bool IsReady();
	virtual void OnSuccess();
	virtual void OnError();
	// general purpose diagnostics
	int GetLastError();
	//
	bool Open(LPCSTR szName, bool bBlock = false);
	bool IsOpen();
	//
	bool Attach(int hFile);
	int Detach();
	//
	bool Close(bool bBlock = false);
	bool IsClosed();
	//
	bool Seek(int nOffset, int nWhence, bool bBlock = false);
	int GetPos();
	int GetSize();
	bool EoF();
	//
	int Read(char* pBuffer, int nBytes, bool bOnlyCached = true, bool bBlock = false); // return number of bytes read or -1
	// reads data at the specified location
	int ReadSeek(int nOffset, int nWhence, char* pBuffer, int nBytes, bool bBlock = false); // return number of bytes read or -1
	int BytesAvail();
	char* GetBuffer();
	bool ReleaseBuffer(int nBytesUsed = -1); //
	bool Prefetch(); // puts a pre-read request if there is no data available
	bool PrefetchSeek(int nOffset, int nWhence); //prefetch with seek
	bool Recycle(); // destroyos "pre-read" state
	//
	int Write(char* pBuffer, int nBytes, bool bCopyData = true, bool bAllowBufferResize = true, bool bBlock = false); // return number of bytes written(copied to the buffer in case of nonblocking op) or -1
	// writes data at the specified location
	int WriteSeek(int nOffset, int nWhence, char* pBuffer, int nBytes, bool bCopyData = true, bool bAllowBufferResize = true, bool bBlock = false); // return number of bytes written(copied to the buffer in case of nonblocking op) or -1
	//
	bool WaitTillReady(); // return false when wait failed
protected:
	virtual ~MAsyncFile(); // shell never be called directly
protected:
	MAFThread*     m_pThread;
	MWaitCondition m_waitReady;
	//MMutex         m_mtxWait;
	AsyncFileRequest* m_pRequest;
	//
	MMutex m_mtxBuffer;
	//
	int m_nMode;
	int m_nBufferSize;
	char* m_pBuffer;
	char* m_pData;
	int m_nPreReadBytes;
	char* m_szName;
};

#endif //__ASYNCFILE_H__

