/***************************************************************************
                          mutella.h  -  common include file for the project
                             -------------------
    begin                : Thu May 31 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/
#ifndef __mutella_h_included__
#define __mutella_h_included__

#ifndef _USE_SGI_STL
#include <memory>
#include <vector>
#include <string>
#include <list>
#include <slist>
#include <deque>
#include <queue>
#include <set>
#include <map>
#else
#include <sgi_stl/memory>
#include <sgi_stl/vector>
#include <sgi_stl/string>
#include <sgi_stl/list>
#include <sgi_stl/slist>
#include <sgi_stl/deque>
#include <sgi_stl/queue>
#include <sgi_stl/set>
#include <sgi_stl/map>
#endif //_USE_SGI_STL

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <errno.h>
//#include <time.h>

// library-type includes
#include "defines.h"
#include "tstring.h"
#include "mthread.h"
#include "asyncsocket.h"

#define PROGRAM_SERVER		1
#define PROGRAM_CLIENT		2

#define NETWORK_INTERNET	1
#define NETWORK_LAN			2
#define NETWORK_PRIVATE		3

#define PACKET_PING			1
#define PACKET_PONG			2
#define PACKET_QUERY		3
#define PACKET_QUERYHIT		4
#define PACKET_PUSH			5

#define ALLOW				1
#define DENY				0

#define MAX_TTL_ACCEPTED	15 // be very tolerant
#define MAX_TTL_SELF		7
#define MAX_SHARE			31458312

#define MAX_BUFFERSIZE		0x10000
#define MIN_BUFFERSIZE		0x00800

#define CONNECT_TIMEOUT		10
#define NODECACHE_SIZE		200
#define PACKETCACHE_SIZE	1000

#define LIMIT_NONE			0
#define LIMIT_LESS			1
#define LIMIT_EXACTLY		2
#define LIMIT_MORE			3

#define WM_USER 100
#define SOCK_CONNECTING		(WM_USER + 1)
#define SOCK_NEGOTIATING	(WM_USER + 2)
#define SOCK_CONNECTED		(WM_USER + 3)
#define SOCK_CLOSED			(WM_USER + 4)
#define SOCK_UPDATE			(WM_USER + 5)

#define TRANSFER_QUEUED		(WM_USER + 24)
#define TRANSFER_CONNECTING	(WM_USER + 25)
#define TRANSFER_CONNECTED	(WM_USER + 26)
#define TRANSFER_SENDING	(WM_USER + 27)
#define TRANSFER_RECEIVING  (WM_USER + 28)
#define TRANSFER_PUSH		(WM_USER + 29)
#define TRANSFER_CLOSED		(WM_USER + 30)
#define TRANSFER_COMPLETED	(WM_USER + 31)
#define TRANSFER_COOLDOWN	(WM_USER + 32)
#define TRANSFER_NEW		(WM_USER + 33)
#define TRANSFER_NO_RESULTS (WM_USER + 34)
#define TRANSFER_PUSH_CONNECTED	(WM_USER + 35)
#define TRANSFER_PUSH_CONNECTING (WM_USER + 36)

#define REASON_UNDEFINED 0
#define REASON_STOPPED   1
#define REASON_NO_DATA 2
#define REASON_SOCKET_ERROR 3
#define REASON_NO_RESUME_SUPPORT 4
#define REASON_WRONG_FILE_SIZE 5
#define REASON_FILE_NOT_FOUND 6
#define REASON_SERVER_BUSY 7
#define REASON_UNKNOWN_SERVER_ERROR 8
#define REASON_WRONG_STATE 9
#define REASON_CONNECTION_ERROR 10
#define REASON_REMOTELY_CANCELED 11
#define REASON_FAILED_TO_OPEN_FILE 12
#define REASON_PARTIAL_FILESIZE_DIFFERENT 13
#define REASON_HOST_OCCUPIED 14
#define REASON_FILES_ARE_DIFFERENT 15
#define REASON_WRITE_ERROR 16
#define REASON_COMPLETED 17
#define REASON_CORRUPT 18
#define REASON_NO_RESPONSE 19
#define REASON_BELOW_MINIMUM_SPEED 20

#define UPLOAD_UPDATE		(WM_USER + 21)
#define DOWNLOAD_UPDATE		(WM_USER + 22)
#define PARTIAL_UPDATE		(WM_USER + 23)

#define ERROR_HOPS			(WM_USER + 9)
#define ERROR_LOOPBACK		(WM_USER + 10)
#define ERROR_TTL			(WM_USER + 11)
#define ERROR_DUPLICATE		(WM_USER + 12)
#define ERROR_ROUTING		(WM_USER + 13)

#define PACKET_GOOD			(WM_USER + 6)
#define PACKET_BAD			(WM_USER + 7)
#define PACKET_INCOMING		(WM_USER + 8)

#define SHARE_RELOAD		(WM_USER + 15)
#define SHARE_UPDATE		(WM_USER + 16)
#define SHARE_LOAD			(WM_USER + 17)
#define SHARE_STOP			(WM_USER + 18)

// global variables

extern MMutex g_LibcMutex;

// application includes
#include "common.h"
#include "packet.h"
#include "conversions.h"

#endif //__mutella_h_included__