/***************************************************************************
                          rcobject.h  -  description
                             -------------------
    begin                : Sun Jan 6 2002
    copyright            : (C) 2002 by 
    email                : 
 ***************************************************************************/

#ifndef RCOBJECT_H
#define RCOBJECT_H

#ifdef _REENTRANT
#include "mthread.h"
#endif //_REENTRANT

class MRCObject {
public: 
	MRCObject();
protected:
	virtual ~MRCObject() = 0;
public:
	// references
	inline void AddRef(){
#	ifdef _REENTRANT
	m_mutex.lock();
#	endif //_REENTRANT
	++m_nRefs;
#	ifdef _REENTRANT
	m_mutex.unlock();
#	endif //_REENTRANT
	}
	inline void Release(){
#	ifdef _REENTRANT
	m_mutex.lock();
#	endif //_REENTRANT
	ASSERT(m_nRefs>0);
	if (--m_nRefs<=0)
	{
#		ifdef _REENTRANT
		m_mutex.unlock();
#		endif //_REENTRANT
		delete this;
		return;
	}
#	ifdef _REENTRANT
	m_mutex.unlock();
#	endif //_REENTRANT
	}
protected:
	int m_nRefs;
#	ifdef _REENTRANT
	MMutex m_mutex;
#	endif //_REENTRANT
};

template<class T>
class TSmartPtr {
public:
	TSmartPtr(T* ptr = NULL) : m_ptr(ptr){
		if (m_ptr)
			m_ptr->AddRef();
	}
	TSmartPtr(const TSmartPtr<T>& sptr){
		if (sptr.m_ptr)
			sptr.m_ptr->AddRef();
		m_ptr = sptr.m_ptr;
	}
	~TSmartPtr(){
		if (m_ptr)
			m_ptr->Release();
	}
	// operators
	T* operator=(T* ptr){
		if (ptr)
			ptr->AddRef();
		if (m_ptr)
			m_ptr->Release();
		m_ptr = ptr;
		return m_ptr;
	}
	T* operator=(const TSmartPtr<T>& sptr){
		if (sptr.m_ptr)
			sptr.m_ptr->AddRef();
		if (m_ptr)
			m_ptr->Release();
		m_ptr = sptr.m_ptr;
		return m_ptr;
	}
	operator const T*() const { return m_ptr; }
	operator T*() { return m_ptr; }
	T& operator*() const { return *m_ptr; }
	T* operator->() const { return m_ptr; }

private:
	T* m_ptr;
};

#endif
