/***************************************************************************
                          term.c  -  description
                             -------------------
    begin                : Thu Nov 1 2001
    copyright            : (C) 2001 by Max Zaitsev
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

/* replace this '0' with '1' if you fail to link Mutella because of
   unresolved symbols like
       tigetnum
       tigetflag
       setupterm
   this will disable 'smart' features like automatic detection of
   size of the terminal, but will let Mutella link */

#if 0
#undef HAVE_CURSES_H
#undef HAVE_CURSES_H
#undef HAVE_TERMCAP_H
#endif

#ifndef HAVE_TERMCAP_H
#ifdef HAVE_NCURSES_H
#include <ncurses.h>
#define USE_CURSES
#else /*HAVE_NCURSES_H*/
#ifdef HAVE_CURSES_H
#include <curses.h>
#define USE_CURSES
#endif /*HAVE_CURSES_H*/
#endif /*HAVE_NCURSES_H*/
#ifdef USE_CURSES
#ifdef HAVE_TERM_H
#include <term.h> /* include after <curses.h> */
#endif /*HAVE_TERM_H*/
#endif /*USE_CURSES*/
#else /*HAVE_TERMCAP_H*/
#ifdef HAVE_TERMCAP_H
#include <termcap.h>
#define USE_TERMCAP
#endif /*HAVE_TERMCAP_H*/
#endif

#ifdef HAVE_TERMIOS_H
#include <termios.h>
#endif

#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include "term_help.h"

/* this code copied from "less" */
void raw_mode(int on)
{
  static int curr_on = 0;

  if (on==curr_on) return;

#if HAVE_TERMIOS_H && HAVE_TERMIOS_FUNCS
  {
  struct termios s;
  static struct termios save_term;
  static int saved_term = 0;

  if (on) {
    tcgetattr(2,&s);

    if (!saved_term) {
      save_term=s;
      saved_term=1;
    }

    s.c_lflag &= ~(0
#ifdef ICANON
      | ICANON
#endif
#ifdef ECHO
      | ECHO
#endif
#ifdef ECHOE
      | ECHOE
#endif
#ifdef ECHOK
      | ECHOK
#endif
#if ECHONL
      | ECHONL
#endif
    );

    s.c_oflag |= (0
#ifdef OXTABS
      | OXTABS
#else
#ifdef TAB3
      | TAB3
#else
#ifdef XTABS
      | XTABS
#endif
#endif
#endif
#ifdef OPOST
      | OPOST
#endif
#ifdef ONLCR
      | ONLCR
#endif
    );

    s.c_oflag &= ~(0
#ifdef ONOEOT
      | ONOEOT
#endif
#ifdef OCRNL
      | OCRNL
#endif
#ifdef ONOCR
      | ONOCR
#endif
#ifdef ONLRET
      | ONLRET
#endif
    );
    s.c_cc[VMIN]=1;
    s.c_cc[VTIME]=0;
#ifdef VLNEXT
    s.c_cc[VLNEXT]=0;
#endif
#ifdef VDSUSP
    s.c_cc[VDSUSP] = 0;
#endif
  } else {
    s=save_term;
  }

  tcsetattr(2,TCSADRAIN,&s);
  }
#endif

  curr_on = on;
}

char read_key()
{
  char c;
  raw_mode(1);
  fcntl(STDIN_FILENO,F_SETFL,O_NONBLOCK);

  while (read(STDIN_FILENO,&c,1)<0) {
    usleep(1000);
  }

  fcntl(STDIN_FILENO,F_SETFL,0);
  raw_mode(0);
  return c;
}


#ifdef USE_CURSES

#define GUESS_WILL_WORK

void
my_setupterm(const char *term, int fildes, int *errret) {
     setupterm(term, fildes, errret);
}

int
my_tgetnum(char *s, char *ss) {
     return tigetnum(ss);
}

int
my_tgetflag(char *s, char *ss) {
     return tigetflag(ss);
}

#endif /*USE_CURSES*/

#ifdef USE_TERMCAP

#define GUESS_WILL_WORK

char termbuffer[4096];
char tcbuffer[4096];
char *strbuf = termbuffer;

void
my_setupterm(const char *term, int fildes, int *errret) {
     *errret = tgetent(tcbuffer, term);
}

int
my_tgetnum(char *s, char *ss) {
     return tgetnum(s);
}

int
my_tgetflag(char *s, char *ss) {
     return tgetflag(s);
}

#endif /*USE_TERMCAP*/

void guess_term_size(int* Mcol, int* Lpp)
{
#ifdef GUESS_WILL_WORK
	char *term;
	int dumb;
	u_long ul_opt;
	int ret;
#ifdef TIOCGWINSZ
	struct winsize win;
#endif
	ul_opt = 0;
	dumb = 0;
	term = NULL;
	
	if ((term = getenv("TERM")) == 0) {
		dumb++; ul_opt = 0;
	}
	
	my_setupterm(term, 1, &ret);
	if (ret <= 0) {
		dumb++; ul_opt = 0;
	}
	else
	{
#ifdef TIOCGWINSZ
		if (ioctl(STDOUT_FILENO, TIOCGWINSZ, &win) < 0) {
#endif
			*Lpp = my_tgetnum("li","lines");
			*Mcol = my_tgetnum("co","cols");
#ifdef TIOCGWINSZ
		}
		else
		{
			if ((*Lpp = win.ws_row) == 0)
		    	*Lpp = my_tgetnum("li","lines");
			if ((*Mcol = win.ws_col) == 0)
		    	*Mcol = my_tgetnum("co","cols");
	    }
#endif
		if ((*Lpp <= 0) || my_tgetflag("hc","hc")) {
			*Lpp = -1; /* hardcopy term */
	    }
	    /*if (my_tgetflag("xn","xenl"))
			eatnl++; */ /* Eat newline at last column + 1; dec, concept */
		if (*Mcol <= 0)
			*Mcol = 80;
	}
#else /*GUESS_WILL_WORK*/
	*Mcol = 80;
	*Lpp = 24;
#endif /*GUESS_WILL_WORK*/
}
