/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 controller.h  -  Overall controller class for core and core/UI interaction

    begin                : Mon May 28 2001
    copyright            : (C) 2001 by 
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifndef MCONTROLLER_H
#define MCONTROLLER_H

class MMutex;
class MProperty;
class MPropertyContainer;
class MGnuDirector;
class MGnuPreferences;
class MUI;
class MUIThread;
class MGnutellaThread;
class MGnuLogCentre;
class MSha1Thread;

////////////////////////////////////////////////
// structure for storing UI objects in  the list
struct SUIEntry{
	MUIThread* pThread;
	MUI*       pUI;
};

/////////////////////////////////////////////////////////////////////////
// MController -- the interface class for UIs to access the Network layer
//
class MController {
friend class MGnutellaThread;
friend class MUIThread;
public: 
	MController();
	~MController();
	// called from main()
	bool Init(CString sConfigFile, bool bStartInteractive);
	void Do();
	// interface to the network core
	MGnuPreferences* GetPrefs();
	void Attach(MGnuDirector*);
	void Detach(MGnuDirector*);
	MGnuDirector* GetDirector();
	// callbacks from the director
	bool OnExternalHttpRequest(const IP& ipRemoteHost, LPCSTR szFolder, LPCSTR szHandshake, const char * pBuffRest, HANDLE hSocket, MUI* pUI);
	
	/////////////////////////////////////////
	// interface-related stuff starts here //
	/////////////////////////////////////////
	
	// allows UI-s to register propritary HTTP folders
	// Get/Put requests will be re-directed to these UIs
	bool RegisterHttpFolder(MUI* pUI, LPCSTR szFolder);
	bool UnregisterHttpFolder(MUI* pUI, LPCSTR szFolder);
	// properties
	MProperty* GetProperty(LPCSTR szName);
	MPropertyContainer* GetPropertyContainer(){return m_pPropCont;}
	CString GetRcDirPath();
	// stop all the UIs and exit
	void ForceStop();
	// searches
	bool AddSearchUsr(LPCSTR szSearch, int size, int sizeMode, bool bAutoGet = false);
	bool ModifySearch(DWORD dwID, LPCSTR szSearch);
	void ForEachSearch(void* pData, tEachSearch callback);
	bool GetSearchByID(DWORD dwID, SGnuSearch& gs, ResultVec& rv, ResultGroupVec& gv); /* C: problem */
	int  GetSearchesCount();
	bool GetResultsByID(DWORD dwID, ResultVec& rv); /* C: problem */
	bool RemoveSearchByID(DWORD dwID, bool bDeletePartial);
	bool ClearSearchByID(DWORD dwID);
	// connections
	void ForEachConnection(void* pData, tEachConnection callback);
	bool CloseConnectionByID(DWORD dwID);
	void OpenConnection(LPCSTR zsHost, int port);
	DWORD GetConnRateRecv();
	DWORD GetConnRateSend();
	bool IsUltrapeer();
	int  GetClientStartTime();
	// transfers
	void ForEachUpload(void* pData, tEachUpload callback);
	void ForEachDownload(void* pData, tEachDownload callback);
	bool RemoveTransferByID(DWORD dwID, bool bDelPart);
	bool AddDownload(const ResultVec& results); /* C: problem */
	bool RenameDownload(DWORD dwID, LPCSTR szNewFilename);
	// local file share
	void Rescan();
	void GetSharedFiles(vector<SharedFile>&); /* C: problem */
	// statistics
	void GetCacheStats(int& nCatcherHosts, int& nUltraCatcherHosts, int& nStoreHosts, int& nWebCaches);
	void GetNetStats(int& nHosts, int& nSharingHosts, int& nFiles, int& nSize); /* C: replace those with pointers */
	void GetConnStats(int& nConn, int& nUpl, int& nDownlActive, int& nDownlTotal); /* C: replace those with pointers */
	void GetBandwidthStats(int& nConn, int& nUpl, int& nDownl); /* C: replace those with pointers */
    // host cache
    void GetNodeCache(list<Node>& list); /* C: problem */
protected:
	// data fields
	MGnuDirector *       m_pDirector;
	MGnuPreferences *    m_pPrefs;
	MGnutellaThread *    m_pNetworkThread;
	MGnuLogCentre *      m_pLogCentre;
	MSha1Thread *        m_pSha1Thread;
	MPropertyContainer * m_pPropCont;
	list<SUIEntry>       m_listUI;
	list<MUI*>           m_listStoppedUI;
	MWaitCondition       m_waitForChanges;
	MMutex               m_mutex;
	bool                 m_bExplisitStop;
	CString              m_sConfigFile;
	// protected methods
	void LoadPartials(const CString& partDir);
	void LoadSearches();
	void SaveSearches();
	bool AddSearch(const CString& sSearch, const CString& sOptions);
	void AddUI(MUI* pUI);
	bool OnStopUI(MUI* pUI);
	bool RemoveUI(MUI* pUI);
	void SaveState();
};

#endif //MCONTROLLER_H

