/*
 *   dspio.h -- DSP File I/O prototypes
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */

/****************************************************************************/
/* Defines                                                                  */
/****************************************************************************/
#define TAGSIZE  4
#define TAGHEADERSIZE 8
#define RIFFHDRSIZE 12

/****************************************************************************/
/* Function Prototypes                                                      */
/****************************************************************************/
RC   ReadTagHdr (HFILE hfile, PVOID pTag, PULONG pulBodySize, PULONG pulTagSize);

RC   DspChgFilePtr (HFILE hfile, ULONG ulFileOffset, USHORT usMoveType);
RC   DspCloseFile (HFILE hfile);
RC   DspOpenFile (PSZ pszFilename, PHFILE phfile, USHORT usFlags);
RC   DspReadFile (HFILE hfile, ULONG ulSize, PVOID pBuffer);
RC   DspWriteFile (HFILE hfile, ULONG ulSize, PVOID pBuffer);


/****************************************************************************/
/* Flags for DspOpenFile                                                    */
/*       These flags define the mode of file open to be done. They can      */
/*       be combined using a bitwise OR operator in cases that make sense   */
/*       such as DspOpenBinary | DspOpenCreate. However some combinations   */
/*       are conflicting and will return an error; i.e. DspOpenRdOnly |     */
/*       DspOpenWrOnly.                                                     */
/****************************************************************************/

#define DSPOPENAPPEND 0x0001       // Put file pointer at end of file before
                                   // each write
#define DSPOPENBINARY 0x0002       // Use Binary (untranslated) mode
#define DSPOPENCREATE 0x0004       // Open new file for writing. If file
                                   // already exists, this has no effect
#define DSPOPENRDONLY 0x0008       // Open for reading only
#define DSPOPENRDWR   0x0010       // Open for reading and writing
#define DSPOPENTEXT   0x0020       // Use ASCII (translated) mode
#define DSPOPENTRUNC  0x0040       // Open existing file, destroy contents
                                   // before writing
#define DSPOPENWRONLY 0x0080       // Open for writing only

