/*   This file is public domain and comes with NO WARRANTY of any kind */

#define ODBCVER 0x0250		/* ODBC 3.0 has no installer */
#ifdef APSTUDIO_READONLY_SYMBOLS
#define WIN32			/* Hack for rc files */
#endif

#ifdef __cplusplus
extern "C"
{
#endif
#ifdef RC_INVOKED
#define stdin			/* Don't include stdio */
#endif

#ifdef HAVE_CONFIG_H
#include "myconf.h"
  /* those cause nasty warnings */
#undef PACKAGE
#undef VERSION
#endif

#include <my_global.h>
#include <my_sys.h>
#include <mysql.h>
#include <my_list.h>
#include <m_string.h>
#ifdef THREAD
#include <my_pthread.h>
#else
#define pthread_mutex_lock(A)
#define pthread_mutex_unlock(A)
#define pthread_mutex_init(A,B)
#define pthread_mutex_destroy(A)
#endif

#ifdef __cplusplus
}
#endif

#ifndef _UNIX_
#include <windowsx.h>
#ifndef RC_INVOKED
#pragma pack(1)
#endif
/* #include "w16macro.h" */
#include "sql.h"
#include "sqlext.h"
#endif /* IS NOT UNIX */

#ifdef _UNIX_

/* iodbc or unixODBC? */
#if defined(HAVE_ISQL_H) && defined(HAVE_ISQLEXT_H)
# include <isql.h>
# include <isqlext.h>
#elif defined(HAVE_SQL_H) && defined(HAVE_SQLEXT_H)
# include <sql.h>
# include <sqlext.h>
#endif

#if defined(HAVE_SQLGETPRIVATEPROFILESTRING)
# if defined(HAVE_IODBCINST_H)
#  include <iodbcinst.h>
# elif defined(HAVE_ODBCINST_H)
#  include <odbcinst.h>
# endif
#else
/* fall back to our temporary solution */
#define SQLGetPrivateProfileString _myodbc_SQLGetPrivateProfileString
#endif /* HAVE_IODBCINST */

/* unixODBC doesn't have this */
#if !defined(SQL_API)
# define SQL_API
#endif

#endif /* IS UNIX */

#if defined(_WIN32) || defined(WIN32)
#define INTFUNC  __stdcall
#define EXPFUNC  __stdcall
#else
#define INTFUNC PASCAL
#define EXPFUNC __export CALLBACK
#endif

#undef	SQL_SPEC_STRING			/* Wrong in VC++ 5.0 */
#define SQL_SPEC_STRING    "02.50"	/* String constant for version */
#define DRIVER_VERSION	   "2.50.39"
#define MYSQL_RESET_BUFFERS 1000	/* Intern param to SQLFreeStmt */
#define MYSQL_RESET	    1001	/* Intern param to SQLFreeStmt */
#define MYSQL_3_21_PROTOCOL 10
#define CHECK_IF_ALIVE	    3600	/* Seconds between queries for ping */

#define x_free(A) { gptr tmp=(gptr) (A); if (tmp) my_free(tmp,MYF(MY_WME+MY_FAE)); }

/*  Environment information.  This is allocated by "SQLAllocEnv". */

typedef struct	tagENV {
  short   DummyEntry;
} ENV;


/* Database connection information.  This is allocated by "SQLAllocConnect". */

#define FLAG_FIELD_LENGTH   1	/* field_length instead of max_length */
#define FLAG_FOUND_ROWS     2	/* Access wants can't handle affected_rows */
#define FLAG_DEBUG	    4	/* Put a debug log on C:\myodbc.log */
#define FLAG_BIG_PACKETS    8	/* Allow BIG packets. */
#define FLAG_NO_PROMPT	    16	/* Don't prompt on connection */
#define FLAG_OLD_ODBC_PROG  32	/* The program require ODBC 1.0 syntax */
#define FLAG_NO_SCHEMA		64
#define FLAG_NO_DEFAULT_CURSOR	128
#define FLAG_NO_LOCALE		256
#define FLAG_PAD_SPACE		512  /* Pad CHAR:s with space to max length */
#define FLAG_FULL_COLUMN_NAMES	1024 /* Extends SQLDescribeCol */
#define FLAG_COMPRESSED_PROTO	2048 /* Use compressed protocol */
#define FLAG_IGNORE_SPACE	4096
#define FLAG_NAMED_PIPE		8192
#define FLAG_NO_BIGINT		16384
#define FLAG_NO_CATALOG		32768
#define FLAG_USE_MYCNF		65536L /* Read my.cnf at start */
#define FLAG_SAFE		131072L /* Try to be as safe as possible */
#define FLAG_NO_TRANSACTIONS	(FLAG_SAFE*2)

#define DEFAULT_TXN_ISOLATION	SQL_TXN_READ_COMMITTED

typedef struct stmt_options {
  uint bind_type,rows_in_set,cursor_type;
  ulong max_length,max_rows;
} STMT_OPTIONS;

typedef struct tagDBC {
  ENV *env;
  MYSQL mysql;
  char *dsn,*database,*user,*password,*server;
  uint port;
  ulong flag,login_timeout;
  LIST *statements;
  STMT_OPTIONS stmt_options;
  time_t last_query_time;
  char sqlstate[6];
  char last_error[MYSQL_ERRMSG_SIZE];
  uint last_errno;
  int txn_isolation;
#ifdef THREAD
  pthread_mutex_t lock;
#endif
} DBC;


/* Statment information.  This is allocated by "SQLAllocStmt". */

typedef struct st_bind {
  MYSQL_FIELD *field;
  SQLSMALLINT fCType;
  SQLPOINTER	rgbValue;				/* Save data here */
  SQLINTEGER cbValueMax;
  SQLINTEGER FAR *pcbValue;
  LIST list;
} BIND;

typedef struct st_param_bind {
  SQLSMALLINT SqlType,CType;
  gptr buffer;
  char *pos_in_query,*value;
  SQLINTEGER ValueMax,*actual_len,value_length;
  bool alloced,used;
  bool real_param_done; 
} PARAM_BIND;

enum MY_STATE { ST_UNKNOWN, ST_PREPARED, ST_PRE_EXECUTED, ST_EXECUTED };
enum MY_DUMMY_STATE { ST_DUMMY_UNKNOWN, ST_DUMMY_PREPARED, ST_DUMMY_EXECUTED };

#define MYSQL_MAX_CURSOR_LEN 18
#define MYSQL_STMT_LEN 1024
#define MYSQL_STRING_LEN 1024
#define MYSQL_MAX_SEARCH_STRING_LEN NAME_LEN+10

enum MYSQL_CURSOR_STATE {
  MYSQL_CURSOR_UNDEFINED,       /* cursor is not set */
  MYSQL_CURSOR_DEFINED,         /* cursor was set by SQLSetCursorName */
  MYSQL_CURSOR_IN_EXECUTION,	  /* if it is in fetch/pos update/delete*/
  MYSQL_CURSOR_NEED_DATA       /* when the stmt is needed data */  
};
typedef struct pk_column {
  char name[NAME_LEN+1];
  my_bool bind_done;
} MY_PK_COLUMN;
typedef struct	tagSTMT {
  DBC FAR *dbc;
  MYSQL_RES *result;
  uint current_row,last_getdata_col;
  ulong getdata_offset;
  ulong *result_lengths;
  uint *order,order_count,param_count,current_param,
       rows_found_in_set,position_in_set,bound_columns;
  my_ulonglong affected_rows;
  STMT_OPTIONS stmt_options;
  enum MY_STATE state;
  enum MY_DUMMY_STATE dummy_state;
  MYSQL_ROW array,result_array,current_values;
  MYSQL_ROW (*fix_fields)(struct tagSTMT FAR* stmt,MYSQL_ROW row);
  MYSQL_FIELD *fields;
  MYSQL_ROW_OFFSET end_of_set;		/* end of set for SQLExtendedFetch() */
  DYNAMIC_ARRAY params;			/* For SQLBindParamter */
  BIND *bind;				/* For SQLBindCol */
  SQLSMALLINT *odbc_types;		/* sql types for fields */
  char *query,*query_end;
  const char *table_name;
  LIST list;
  char sqlstate[6];
  char last_error[MYSQL_ERRMSG_SIZE];
  uint last_errno;
  char cursor_name[MYSQL_MAX_CURSOR_LEN]; /* keep the cursor name */
  enum MYSQL_CURSOR_STATE cursor_state;   /* keep track of the cursor state */
  uint pk_count;
  MY_PK_COLUMN pk_col[32];
  SQLUSMALLINT FAR *rgfRowStatus;
  my_bool my_pk_validated;
  my_bool data_cursor;
} STMT;


#ifndef _UNIX_
extern HINSTANCE NEAR s_hModule;	/* DLL handle. */
#endif
extern char *default_locale, *decimal_point, *thousands_sep;
extern uint decimal_point_length,thousands_sep_length;
#ifdef THREAD
extern pthread_mutex_t myodbc_lock;
#endif

/*	Resource defines for "SQLDriverConnect" dialog box. */

#define ID_LISTBOX	100
#define CONFIGDSN	1001
#define CONFIGDEFAULT	1002
#define EDRIVERCONNECT	1003

/* MyODBC internal error numbers */

#define ER_INVALID_CURSOR_NAME	999
#define ER_MULTIPLE_TABLE_IN_RESULT 998

/* MyODBC internal constants */
#define MY_MAX_PK_PARTS 32

/* Prototypes */

SQLRETURN my_SQLExecute(STMT FAR* stmt);
SQLRETURN my_SQLPrepare(SQLHSTMT hstmt,SQLCHAR FAR *szSqlStr,
			SQLINTEGER cbSqlStr);
SQLRETURN SQL_API my_SQLFreeStmt(SQLHSTMT hstmt,SQLUSMALLINT fOption);
SQLRETURN SQL_API my_SQLAllocStmt(SQLHDBC hdbc,SQLHSTMT FAR *phstmt);
SQLRETURN do_query(STMT FAR *stmt,char *query);
char *insert_params(STMT FAR *stmt);
/* Functions in utility.c */

SQLRETURN odbc_stmt(DBC FAR *dbc, const char *query);
void mysql_link_fields(STMT *stmt,MYSQL_FIELD *fields,uint field_count);
void fix_result_types(STMT *stmt);
char *fix_str(char *to,char *from,int length);
char *dupp_str(char *from,int length);
bool empty_str(char *from,int length);
const char *mystr_get_prev_token(const char **szQuery, const char *start);
SQLRETURN my_pos_delete(STMT FAR *stmt, SQLUSMALLINT irow,
												DYNAMIC_STRING dynStr);
SQLRETURN my_pos_update(STMT FAR *stmt, SQLUSMALLINT irow,
												DYNAMIC_STRING dynStr,
			SQLUSMALLINT set_param);
my_bool check_if_positioned_cursor_exists(STMT FAR *stmt,STMT FAR **stmtNew);
char *insert_param(MYSQL *mysql, char *to,PARAM_BIND *param);
char *add_to_buffer(NET *net,char *to,char *from,ulong length);
SQLRETURN copy_result(DBC FAR *dbc, STMT FAR *stmt, SQLCHAR FAR *rgbValue,
		      SQLSMALLINT cbValueMax, SQLSMALLINT FAR *pcbValue,
		      char FAR *src);
SQLRETURN copy_lresult(DBC FAR *dbc,SQLCHAR FAR *rgbValue,
		       SQLINTEGER cbValueMax,
		       SQLINTEGER FAR *pcbValue,char *src,long src_length,
		       long max_length,long fill_length,long *offset,
		       my_bool binary_data);
SQLRETURN copy_binary_result(DBC FAR *dbc,SQLCHAR FAR *rgbValue,
			     SQLINTEGER cbValueMax,
			     SQLINTEGER FAR *pcbValue,char *src,
			     ulong src_length, ulong max_length,ulong *offset);
SQLRETURN set_dbc_error(DBC FAR *dbc,char *state,char *message,uint errcode);
SQLRETURN set_stmt_error(STMT *stmt,char *state,char *message,uint errcode);
void translate_error(char *save_state,char *default_state,uint mysql_err);
int unireg_to_sql_datatype(STMT FAR *stmt, MYSQL_FIELD *field, char *buff,
			   ulong *transfer_length,ulong *precision,
			   ulong *display_size);
SQLRETURN SQL_API my_SQLBindParameter(SQLHSTMT hstmt,SQLUSMALLINT ipar,
				   SQLSMALLINT fParamType,
				   SQLSMALLINT fCType, SQLSMALLINT fSqlType,
				   SQLUINTEGER cbColDef,
				   SQLSMALLINT ibScale, SQLPOINTER  rgbValue,
				   SQLINTEGER cbValueMax,
				   SQLINTEGER FAR *pcbValue);
int unireg_to_c_datatype(MYSQL_FIELD *field);
int default_c_type(int sql_data_type);
ulong bind_length(int sql_data_type,ulong length);
my_bool str_to_date(DATE_STRUCT *rgbValue, const char *str,uint length);
ulong str_to_time(const char *str,uint length);
void init_getfunctions(void);
void myodbc_init(void);
int check_if_server_is_alive(DBC FAR *dbc);
my_bool check_if_dummy_param_exists(STMT FAR *stmt);
