/* Copyright (C) 2000-2005 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   There are special exceptions to the terms and conditions of the GPL as it
   is applied to this software. View the full text of the exception in file
   EXCEPTIONS in the directory of this software distribution.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#include "MYODBCUtil.h"

/*!
    \brief  Read driver from system information.

    \param  pDriver Driver struct.
    \param  pszName User friendly name of driver such as "MySQL ODBC 3.51 Driver (32 bit)"
    
    \note   This will not replace existing values in pDriver.
*/            
BOOL MYODBCUtilReadDriver( MYODBCUTIL_DRIVER *pDriver, LPCSTR pszName )
{
    char    szEntryNames[SQL_MAX_DSN_LENGTH * MYODBCUTIL_MAX_DSN_NAMES];
    char *  pszEntryName;
    char    szValue[4096];

    if ( !pszName || !(*pszName) )
        return FALSE;

    if ( !pDriver->pszName )
        pDriver->pszName = strdup( pszName ) ;

#if defined(__APPLE__)
    /*!
        \note   OSX

                SQLGetPrivateProfileString is the proper call and is available - but
                at this time it appears utterly broken. So we call an alternative
                instead. 
    */
    if ( GetPrivateProfileString( pszName, NULL, NULL, szEntryNames, sizeof( szEntryNames ) - 1, "ODBCINST.INI" ) < 1 )
#else
    if ( SQLGetPrivateProfileString( pszName, NULL, "", szEntryNames, sizeof( szEntryNames ) - 1, "ODBCINST.INI" ) < 1 )
#endif
        return FALSE;

    /*!
        Scan result and return TRUE if we find a match.
    */
    pszEntryName = szEntryNames;
    while ( *pszEntryName )
    {
        *szValue = '\0';
#if defined(__APPLE__)    
        if ( GetPrivateProfileString( pszName, pszEntryName, NULL, szValue, sizeof( szValue ) - 1, "ODBCINST.INI" ) > 0 )
#else
        if ( SQLGetPrivateProfileString( pszName, pszEntryName, "", szValue, sizeof( szValue ) - 1, "ODBCINST.INI" ) > 0 )
#endif
        {
            if ( strcasecmp( pszEntryName, "DRIVER" ) == 0 )
            {
                if ( !pDriver->pszDRIVER )
                    pDriver->pszDRIVER = strdup( szValue ) ;
            }
            else if ( strcasecmp( pszEntryName, "SETUP" ) == 0 )
            {
                if ( !pDriver->pszSETUP )
                    pDriver->pszSETUP = strdup( szValue );
            }
            else
            {
                /* What the ? */
            }
        }
        pszEntryName += strlen( pszEntryName ) + 1;
    } /* while */

    return TRUE;
}

