# Stubs for itsdangerous (Python 3)
#
# NOTE: This dynamically typed stub was automatically generated by stubgen.

from datetime import datetime
from typing import Any, Callable, IO, MutableMapping, Optional, Text, Tuple, TypeVar, Union

PY2 = ...  # type: bool
text_type = str
int_to_byte = Callable[[int], bytes]
number_types = (int, float)
izip = zip

bytes_like = Union[bytearray, bytes]
str_like = Union[str, bytes]
can_become_bytes = Union[str, bytes, bytearray]
comparable_bytes = TypeVar('comparable_bytes', str, Union[bytes, bytearray])

class _CompactJSON:
    def loads(self, payload: Text) -> Any: ...
    def dumps(self, obj: Any) -> Text: ...

compact_json = _CompactJSON
EPOCH = ...  # type: int

def want_bytes(s: can_become_bytes, encoding='', errors='') -> bytes: ...
def is_text_serializer(serializer: Any) -> bool: ...
def constant_time_compare(val1: comparable_bytes, val2: comparable_bytes) -> bool: ...

class BadData(Exception):
    message = ...  # type: str
    def __init__(self, message: str) -> None: ...

class BadPayload(BadData):
    original_error = ...  # type: Optional[Exception]
    def __init__(self, message: str, original_error: Optional[Exception]=None) -> None: ...

class BadSignature(BadData):
    payload = ...  # type: Optional[Any]
    def __init__(self, message: str, payload: Optional[Any]=None) -> None: ...

class BadTimeSignature(BadSignature):
    date_signed = ...  # type: Optional[int]
    def __init__(self, message, payload: Optional[Any]=None, date_signed: Optional[int]=None) -> None: ...

class BadHeader(BadSignature):
    header = ...  # type: Any
    original_error = ...  # type: Any
    def __init__(self, message, payload=None, header=None, original_error=None) -> None: ...

class SignatureExpired(BadTimeSignature): ...

def base64_encode(string: can_become_bytes) -> bytes: ...
def base64_decode(string: can_become_bytes) -> bytes: ...
def int_to_bytes(num: int) -> bytes: ...
def bytes_to_int(bytestr: can_become_bytes) -> bytes: ...

class SigningAlgorithm:
    def get_signature(self, key: bytes_like, value: bytes_like) -> bytes: ...
    def verify_signature(self, key: bytes_like, value: bytes_like, sig: can_become_bytes) -> bool: ...

class NoneAlgorithm(SigningAlgorithm):
    def get_signature(self, key: bytes_like, value: bytes_like) -> bytes: ...

class HMACAlgorithm(SigningAlgorithm):
    default_digest_method = ...  # type: Callable
    digest_method = ...  # type: Callable
    def __init__(self, digest_method: Optional[Callable]=None) -> None: ...
    def get_signature(self, key: bytes_like, value: bytes_like) -> bytes: ...

class Signer:
    default_digest_method = ...  # type: Callable
    default_key_derivation = ...  # type: str
    secret_key = ...  # type: can_become_bytes
    sep = ...  # type: can_become_bytes
    salt = ...  # type: can_become_bytes
    key_derivation = ...  # type: str
    digest_method = ...  # type: Callable
    algorithm = ...  # type: SigningAlgorithm
    def __init__(self, secret_key: can_become_bytes, salt: Optional[can_become_bytes]=None, sep: Optional[can_become_bytes]='',
                 key_derivation: Optional[str]=None,
                 digest_method: Optional[Callable]=None,
                 algorithm: Optional[SigningAlgorithm]=None) -> None: ...
    def derive_key(self) -> bytes: ...
    def get_signature(self, value: bytes_like) -> bytes: ...
    def sign(self, value: bytes_like) -> bytes: ...
    def verify_signature(self, value: bytes_like, sig: can_become_bytes) -> bool: ...
    def unsign(self, signed_value: can_become_bytes) -> str: ...
    def validate(self, signed_value: can_become_bytes) -> bool: ...

class TimestampSigner(Signer):
    def get_timestamp(self) -> int: ...
    def timestamp_to_datetime(self, ts: int) -> datetime: ...
    def sign(self, value: bytes_like) -> bytes: ...
    def unsign(self, value: can_become_bytes, max_age: Optional[int]=None, return_timestamp=False) -> Any: ...
    def validate(self, signed_value: can_become_bytes, max_age: Optional[int]=None) -> bool: ...

class Serializer:
    default_serializer = ...  # type: Any
    default_signer = ...  # type: Callable[..., Signer]
    secret_key = ...  # type: Any
    salt = ...  # type: can_become_bytes
    serializer = ...  # type: Any
    is_text_serializer = ...  # type: bool
    signer = ...  # type: Signer
    signer_kwargs = ...  # type: MutableMapping
    def __init__(self, secret_key: can_become_bytes, salt: Optional[can_become_bytes]=b'', serializer=None, signer: Optional[Callable[..., Signer]]=None, signer_kwargs: Optional[MutableMapping]=None) -> None: ...
    def load_payload(self, payload: Any, serializer=None) -> Any: ...
    def dump_payload(self, *args, **kwargs) -> bytes: ...
    def make_signer(self, salt: Optional[can_become_bytes]=None) -> Signer: ...
    def dumps(self, obj: Any, salt: Optional[can_become_bytes]=None) -> str_like: ...
    def dump(self, obj: Any, f: IO, salt: Optional[can_become_bytes]=None) -> None: ...
    def loads(self, s: can_become_bytes, salt: Optional[can_become_bytes]=None) -> Any: ...
    def load(self, f: IO, salt: Optional[can_become_bytes]=None): ...
    def loads_unsafe(self, s: can_become_bytes, salt: Optional[can_become_bytes]=None) -> Tuple[bool, Any]: ...
    def load_unsafe(self, f: IO, *args, **kwargs) -> Tuple[bool, Any]: ...

class TimedSerializer(Serializer):
    default_signer = ...  # type: Callable[..., TimestampSigner]
    def loads(self, s: can_become_bytes, salt: Optional[can_become_bytes]=None, max_age: Optional[int]=None, return_timestamp=False) -> Any: ...
    def loads_unsafe(self, s: can_become_bytes, salt: Optional[can_become_bytes]=None, max_age: Optional[int]=None) -> Tuple[bool, Any]: ...

class JSONWebSignatureSerializer(Serializer):
    jws_algorithms = ...  # type: MutableMapping[str, SigningAlgorithm]
    default_algorithm = ...  # type: str
    default_serializer = ...  # type: Any
    algorithm_name = ...  # type: str
    algorithm = ...  # type: Any
    def __init__(self, secret_key: can_become_bytes, salt: Optional[can_become_bytes]=None, serializer=None, signer: Optional[Callable[..., Signer]]=None, signer_kwargs: Optional[MutableMapping]=None, algorithm_name: Optional[str]=None) -> None: ...
    def load_payload(self, payload: Any, return_header=False) -> Any: ...
    def dump_payload(self, *args, **kwargs) -> bytes: ...
    def make_algorithm(self, algorithm_name: str) -> SigningAlgorithm: ...
    def make_signer(self, salt: Optional[can_become_bytes]=None, algorithm_name: Optional[str]=None) -> Signer: ...
    def make_header(self, header_fields=Optional[MutableMapping]) -> MutableMapping: ...
    def dumps(self, obj: Any, salt: Optional[can_become_bytes]=None, header_fields=Optional[MutableMapping]) -> str: ...
    def loads(self, s: can_become_bytes, salt: Optional[can_become_bytes]=None, return_header=False) -> Any: ...
    def loads_unsafe(self, s: can_become_bytes, salt: Optional[can_become_bytes]=None, return_header=False) -> Tuple[bool, Any]: ...

class TimedJSONWebSignatureSerializer(JSONWebSignatureSerializer):
    DEFAULT_EXPIRES_IN = ...  # type: int
    expires_in = ...  # type: int
    def __init__(self, secret_key: can_become_bytes, expires_in: Optional[int]=None, **kwargs) -> None: ...
    def make_header(self, header_fields=Optional[MutableMapping]) -> MutableMapping: ...
    def loads(self, s: can_become_bytes, salt: Optional[can_become_bytes]=None, return_header=False) -> Any: ...
    def get_issue_date(self, header: MutableMapping) -> Optional[datetime]: ...
    def now(self) -> int: ...

class URLSafeSerializerMixin:
    def load_payload(self, payload: Any, serializer: Any = ..., **kwargs) -> Any: ...
    def dump_payload(self, *args, **kwargs) -> bytes: ...

class URLSafeSerializer(URLSafeSerializerMixin, Serializer):
    default_serializer = ...  # type: Any

class URLSafeTimedSerializer(URLSafeSerializerMixin, TimedSerializer):
    default_serializer = ...  # type: Any
