program MySQLAdministrator;

uses
  Instance in '..\..\..\mysql-gui-common\source\windows\Instance.pas',
  gnugettext in '..\..\..\mysql-gui-common\source\windows\gnugettext.pas',
  SysUtils,
  Forms,
  Main in 'Main.pas' {MainForm},
  ApplicationDataModule in 'ApplicationDataModule.pas' {ApplicationDM: TDataModule},
  AdditionalClasses in 'AdditionalClasses.pas',
  myx_public_interface in '..\..\..\mysql-gui-common\library\public_interface\windows\myx_public_interface.pas',
  myx_admin_public_interface in '..\..\library\public_interface\windows\myx_admin_public_interface.pas',
  AdvancedEdit in '..\..\..\mysql-gui-common\source\windows\AdvancedEdit.pas' {AdvancedEditFrame: TTntFrame},
  AuxFuncs in '..\..\..\mysql-gui-common\source\windows\AuxFuncs.pas',
  AuxLists in '..\..\..\mysql-gui-common\source\windows\AuxLists.pas',
  MySQLConnection in '..\..\..\mysql-gui-common\source\windows\MySQLConnection.pas',
  ConnectToInstance in '..\..\..\mysql-gui-common\source\windows\ConnectToInstance.pas' {ConnectToInstanceForm},
  SchemataTreeView in '..\..\..\mysql-gui-common\source\windows\SchemataTreeView.pas' {SchemataFrame: TTntFrame},
  Sections in '..\..\..\mysql-gui-common\source\windows\Sections.pas',
  InstanceSections in '..\..\..\mysql-gui-common\source\windows\InstanceSections.pas',
  Translations in '..\..\..\mysql-gui-common\source\windows\Translations.pas',
  OptionsEditor in '..\..\..\mysql-gui-common\source\windows\OptionsEditor.pas' {OptionsForm},
  Options in '..\..\..\mysql-gui-common\source\windows\Options.pas',
  AdminReplication in 'AdminReplication.pas' {AdminReplicationForm},
  AdminServerInfo in 'AdminServerInfo.pas' {AdminServerInfoForm},
  AdminServiceControl in 'AdminServiceControl.pas' {AdminServiceControlForm},
  AdminUsers in 'AdminUsers.pas' {AdminUsersForm},
  AdminServerHealth in 'AdminServerHealth.pas' {AdminServerHealthForm},
  AdminServerConnections in 'AdminServerConnections.pas' {AdminServerConnectionsForm},
  AdminCatalog in 'AdminCatalog.pas' {AdminCatalogForm},
  AdminServerLogs in 'AdminServerLogs.pas' {AdminServerLogsForm},
  AdminStartupVariables in 'AdminStartupVariables.pas' {AdminStartupVariablesForm},
  AdminStartupVariablesInnoDBDatafiles in 'AdminStartupVariablesInnoDBDatafiles.pas' {AdminStartupVariablesInnoDBDatafilesForm},
  AdminStartupVariablesOptionFile in 'AdminStartupVariablesOptionFile.pas' {AdminStartupVariablesOptionFileForm},
  AdminServerHealthLineGraph in 'AdminServerHealthLineGraph.pas' {AdminServerHealthLineGraphFrame: TTntFrame},
  AdminServerHealthBarGraph in 'AdminServerHealthBarGraph.pas' {AdminServerHealthBarGraphFrame: TTntFrame},
  AdminRestore in 'AdminRestore.pas' {AdminRestoreForm},
  AdminBackupProgress in 'AdminBackupProgress.pas' {AdminBackupProgressForm},
  AdminBackup in 'AdminBackup.pas' {AdminBackupForm},
  AuxAdminBackupRestore in 'AuxAdminBackupRestore.pas',
  AdminCatalogTableCheck in 'AdminCatalogTableCheck.pas' {AdminCatalogTableCheckForm},
  Progress in '..\..\..\mysql-gui-common\source\windows\Progress.pas' {ProgressForm},
  About in '..\..\..\mysql-gui-common\source\windows\About.pas' {AboutForm},
  MyxError in '..\..\..\mysql-gui-common\source\windows\MyxError.pas',
  AdminOptionPages in 'AdminOptionPages.pas' {AdminOptionPagesForm},
  AdminServerHealthGraphSettings in 'AdminServerHealthGraphSettings.pas' {AdminServerHealthGraphSettingsForm},
  ScheduleAPI in '..\..\..\mysql-gui-common\source\windows\ScheduleAPI.pas',
  AdminService in 'AdminService.pas',
  EditorTable in '..\..\..\mysql-gui-common\source\windows\EditorTable.pas' {EditorTableForm},
  EditorTableVTFKEdit in '..\..\..\mysql-gui-common\source\windows\EditorTableVTFKEdit.pas',
  EditorTableVTEdit in '..\..\..\mysql-gui-common\source\windows\EditorTableVTEdit.pas',
  CommonFuncs in '..\..\..\mysql-gui-common\source\windows\CommonFuncs.pas',
  AdminRestoreProgress in 'AdminRestoreProgress.pas' {AdminRestoreProgressForm: TTntForm},
  AuxApplicationFuncs in '..\..\..\mysql-gui-common\source\windows\AuxApplicationFuncs.pas',
  NameEditor in 'NameEditor.pas' {NameEditorForm},
  MySQLCommonFuncs in '..\..\..\mysql-gui-common\source\windows\MySQLCommonFuncs.pas',
  Password in 'Password.pas' {PasswordDialog};

{$R *.res}

//Include Common Resource with PNG images, ...
{$R ..\..\..\mysql-gui-common\res\windows\mysqlcommon.res}

//Enable WindowsXP look'n'feel
{$R ..\..\..\mysql-gui-common\res\windows\WindowsXP.res}


//Include Resource with PNG images, ...
{$R ..\..\res\windows\mysqladmin.res}


var
  ConnectionResult: integer;

begin
  //Init the global vars
  InitGlobalVars;

  //Create Common Options
  MYXCommonOptions := TMYXCommonOptions.Create;
  MYXCommonOptionProvider := MYXCommonOptions; // Increases the reference count to 1. This is necessary as we for a short
                                               // period of time need both the interface and the implementing class.
                                               // Once we switch entirely to the interface that problem is gone.
                                               // Without this assignment the class is automatically freed on next access
                                               // so that the access after that crashs badly.

  // Add extra domain for runtime library translations
  AddDomainForResourceString('delphi');

  // Force program to use user defined instead of the current Windows settings
  UseLanguage('en');//MYXCommonOptions.Language);


  //Create Application Data Module
  ApplicationDM:=TApplicationDM.Create(nil);

  ApplicationDM.LoadOptions;

  //Application Title
  Application.Title:='MySQL Administrator';
  Application.HelpFile:='';
  Application.Initialize;

  //Check files
  if(Not(ApplicationDM.CheckFiles))then
    Exit;

  //Load translations
  ApplicationDM.LoadTranslations;

  //Check Common Commandline parameter
  CheckCommonCommandlineParameter;

  //Check Commandline parameter
  ApplicationDM.CheckCommandlineParameter;

  if(ApplicationDM.Options.BackupProfile<>'')then
  begin
    ApplicationDM.MakeBackup;

    Exit;
  end;

  //Create Main Form
  Application.CreateForm(TMainForm, MainForm);
  if(Not(ApplicationDM.Options.ShowOnlyServiceSections))then
  begin
    ConnectionResult:=MainForm.MySQLConn.ConnectToServer(True);

    if(ConnectionResult=1)then
      ApplicationDM.Options.MySQLVersion:=
        IntToStr(MainForm.MySQLConn.MySQLMajorVersion)+'.'+
        IntToStr(MainForm.MySQLConn.MySQLMinorVersion)
    else
    if(ConnectionResult=-1)then
      ApplicationDM.Options.ShowOnlyServiceSections:=True;
  end
  else
    ConnectionResult:=-1;

  if(ConnectionResult=1)or
    (ApplicationDM.Options.ShowOnlyServiceSections)then
  begin
    MainForm.PrepareGUI;
    Application.Run;
  end;

  // We don't need to free the options class. It is refence counted and will automatically be freed.
end.
