package com.mysql.grt.modules;

import java.util.Vector;

import com.mysql.grt.*;
import com.mysql.grt.db.jdbc.*;

/**
 * @author Mike
 * 
 * Java base module
 */
public class BaseJava {

	/**
	 * Static function to return information about this class to the GRT
	 * environment
	 * 
	 * @return returns a GRT XML string containing the infos about this class
	 */
	public static String getModuleInfo() {
		return Grt.getModuleInfoXml(BaseJava.class, "");
	}

	public static String engineVersion() {
		return "Java " + System.getProperty("java.version") + " "
				+ System.getProperty("java.vendor");
	}

	public static GrtList getMessages() {
		GrtList msgList = new GrtList("GrtMessage");
		Vector msgs = Grt.getInstance().getMessages();

		for (int i = 0; i < msgs.size(); i++) {
			msgList.addObject(msgs.get(i));
		}

		msgs.clear();

		return msgList;
	}

	public static RdbmsList getJdbcDrivers() {

		return new BaseJava().doGetJdbcDrivers(null);
	}

	public RdbmsList doGetJdbcDrivers(Object owner) {
		RdbmsList vendors = new RdbmsList();

		// Add MySQL driver
		vendors.add(getRdbmsMysql(owner));

		// Add Oracle driver
		vendors.add(getRdbmsOracle(owner));

		// Add MSSQL driver
		vendors.add(getRdbmsMssql(owner));

		// Add Access driver
		vendors.add(getRdbmsAccess(owner));

		return vendors;
	}

	public Rdbms getRdbmsMysql(Object owner) {
		// create RDBMS
		Rdbms db = new Rdbms(owner);

		db.setName("MySQL");
		db.setCaption("MySQL Server");

		// create driver list for RDBMS
		JdbcDriverList driverList = new JdbcDriverList();
		db.setJdbcDrivers(driverList);

		// add driver to RDBMS and driver list
		JdbcDriver driver = getJdbcDriverMysql(db);
		driverList.add(driver);

		// set default driver
		db.setDefaultJdbcDriver(driver);

		return db;
	}

	public JdbcDriver getJdbcDriverMysql(Object owner) {

		// create driver
		JdbcDriver driver = new JdbcDriver(owner);

		driver.setName("mysql31");
		driver.setCaption("MySQL JDBC Driver 3.1");

		// set driver properties
		driver.setClassName("com.mysql.jdbc.Driver");
		driver.setConnectionStringTemplate("jdbc:mysql://%host%:%port%/?"
				+ "user=%username%&password=%password%");
		driver.setDescription("MySQL JDBC driver to connect to "
				+ "MySQL 4.0, 4.1 and 5.0 servers.");
		driver.setDownloadUrl("http://dev.mysql.com/downloads/"
				+ "connector/j/3.1.html");
		driver.setSchemaStructs("db.mysql");

		// add required files
		GrtStringList files = new GrtStringList(driver);
		files.add("mysql-connector-java-3.1.6-bin.jar");
		driver.setFiles(files);

		// set modules
		driver.setReverseEngineeringModule("ReverseEngineeringMysqlJdbc");
		driver.setMigrationModule("MigrationGeneric");
		driver.setTransformationModule("TransformationMysql");

		// set driver parameters
		JdbcDriverParameterList jdbcParams = new JdbcDriverParameterList();
		driver.setParameters(jdbcParams);

		addJdbcDriverParameterDefaults(driver, jdbcParams, 1);

		// check if driver is installed
		driver.setIsInstalled(driverIsInstalled(driver));

		return driver;
	}

	public Rdbms getRdbmsOracle(Object owner) {
		// create RDBMS
		Rdbms db = new Rdbms(owner);

		db.setName("Oracle");
		db.setCaption("Oracle Database Server");

		// create driver list for RDBMS
		JdbcDriverList driverList = new JdbcDriverList();
		db.setJdbcDrivers(driverList);

		// add driver to RDBMS and driver list
		JdbcDriver driver = getJdbcDriverOracleSid(db);
		driverList.add(driver);

		driverList.add(getJdbcDriverOracleService(db));

		// set default driver
		db.setDefaultJdbcDriver(driver);

		return db;
	}

	public JdbcDriver getJdbcDriverOracleSid(Object owner) {

		// create driver
		JdbcDriver driver = new JdbcDriver(owner);

		driver.setName("OracleThinSid");
		driver.setCaption("Oracle Thin JDBC Driver using SID");

		// set driver properties
		driver.setClassName("oracle.jdbc.OracleDriver");
		driver.setConnectionStringTemplate("jdbc:oracle:thin:"
				+ "%username%/%password%@%host%:%port%:%sid%");
		driver.setDescription("Oracle Thin JDBC driver to connect to "
				+ "Oracle 9i and Oracle 10g servers.");
		driver.setDownloadUrl("http://www.oracle.com/technology/"
				+ "software/tech/java/sqlj_jdbc/htdocs/jdbc101020.html");
		driver.setSchemaStructs("db.oracle");

		// add required files
		GrtStringList files = new GrtStringList(driver);
		files.add("ojdbc14.jar");
		driver.setFiles(files);

		// set modules
		driver.setReverseEngineeringModule("ReverseEngineeringOracle");
		driver.setMigrationModule("MigrationOracle");
		driver.setTransformationModule("");

		// set driver parameters
		JdbcDriverParameterList jdbcParams = new JdbcDriverParameterList();
		driver.setParameters(jdbcParams);
		jdbcParams.add(GetJdbcDriverParameter(driver, "sid", "SID:",
				"Oracle system identifier.", "string", 1));

		addJdbcDriverParameterDefaults(driver, jdbcParams, 2);

		// check if driver is installed
		driver.setIsInstalled(driverIsInstalled(driver));

		return driver;
	}

	public JdbcDriver getJdbcDriverOracleService(Object owner) {

		// create driver
		JdbcDriver driver = new JdbcDriver(owner);

		driver.setName("OracleThinService");
		driver.setCaption("Oracle Thin JDBC Driver using Service Name");

		// set driver properties
		driver.setClassName("oracle.jdbc.OracleDriver");
		driver.setConnectionStringTemplate("jdbc:oracle:thin:"
				+ "%username%/%password%@//%host%:%port%/%service%");
		driver.setDescription("Oracle Thin JDBC driver to connect to "
				+ "Oracle 9i and Oracle 10g servers.");
		driver.setDownloadUrl("http://www.oracle.com/technology/"
				+ "software/tech/java/sqlj_jdbc/htdocs/jdbc101020.html");
		driver.setSchemaStructs("db.oracle");

		// add required files
		GrtStringList files = new GrtStringList(driver);
		files.add("ojdbc14.jar");
		driver.setFiles(files);

		// set modules
		driver.setReverseEngineeringModule("ReverseEngineeringOracle");
		driver.setMigrationModule("MigrationOracle");
		driver.setTransformationModule("");

		// set driver parameters
		JdbcDriverParameterList jdbcParams = new JdbcDriverParameterList();
		driver.setParameters(jdbcParams);
		jdbcParams.add(GetJdbcDriverParameter(driver, "service", "Service:",
				"Oracle service name.", "string", 1));

		addJdbcDriverParameterDefaults(driver, jdbcParams, 2);

		// check if driver is installed
		driver.setIsInstalled(driverIsInstalled(driver));

		return driver;
	}

	public Rdbms getRdbmsMssql(Object owner) {
		// create RDBMS
		Rdbms db = new Rdbms(owner);

		db.setName("MsSqlServer");
		db.setCaption("MS SQL Server");

		// create driver list for RDBMS
		JdbcDriverList driverList = new JdbcDriverList();
		db.setJdbcDrivers(driverList);

		// add driver to RDBMS and driver list
		JdbcDriver driver = getJdbcDriverMssql(db);
		driverList.add(driver);

		// set default driver
		db.setDefaultJdbcDriver(driver);

		return db;
	}

	public JdbcDriver getJdbcDriverMssql(Object owner) {

		// create driver
		JdbcDriver driver = new JdbcDriver(owner);

		driver.setName("MsSql2kSp1");
		driver.setCaption("MS SQL JDBC Driver 2000 SP 1");

		// set driver properties
		driver.setClassName("com.microsoft.jdbc.sqlserver.SQLServerDriver");
		driver.setConnectionStringTemplate("jdbc:microsoft:sqlserver://"
				+ "%host%:%port%;User=%username%;Password=%password%");
		driver.setDescription("MS SQL JDBC driver to connect to "
				+ "MS SQL Server 2000.");
		driver.setDownloadUrl("http://www.microsoft.com/downloads/"
				+ "details.aspx?FamilyID=4f8f2f01-1ed7-4c4d-8f7b-3d47969e66ae&"
				+ "displaylang=en");
		driver.setSchemaStructs("db.mssql");

		// add required files
		GrtStringList files = new GrtStringList(driver);
		files.add("msbase.jar");
		files.add("mssqlserver.jar");
		files.add("msutil.jar");
		driver.setFiles(files);

		// set modules
		driver.setReverseEngineeringModule("ReverseEngineeringMssql");
		driver.setMigrationModule("");
		driver.setTransformationModule("");

		// set driver parameters
		JdbcDriverParameterList jdbcParams = new JdbcDriverParameterList();
		driver.setParameters(jdbcParams);

		addJdbcDriverParameterDefaults(driver, jdbcParams, 1);

		// check if driver is installed
		driver.setIsInstalled(driverIsInstalled(driver));

		return driver;
	}

	public Rdbms getRdbmsAccess(Object owner) {
		// create RDBMS
		Rdbms db = new Rdbms(owner);

		db.setName("MsAccess");
		db.setCaption("MS Access Server");

		// create driver list for RDBMS
		JdbcDriverList driverList = new JdbcDriverList();
		db.setJdbcDrivers(driverList);

		// add driver to RDBMS and driver list
		JdbcDriver driver = getJdbcDriverAccess(db);
		driverList.add(driver);

		// set default driver
		db.setDefaultJdbcDriver(driver);

		return db;
	}

	public JdbcDriver getJdbcDriverAccess(Object owner) {

		// create driver
		JdbcDriver driver = new JdbcDriver(owner);

		driver.setName("MsAccess");
		driver.setCaption("MS Access");

		// set driver properties
		driver.setClassName("sun.jdbc.odbc.JdbcOdbcDriver");
		driver.setConnectionStringTemplate("jdbc:odbc:Driver="
				+ "{Microsoft Access Driver (*.mdb)};DBQ=%databaseFile%;"
				+ "DriverID=22;READONLY=true;UID=%username%;PWD=%password%}");
		driver.setDescription("MS Access over JDBC-ODBC bridge");
		driver.setDownloadUrl("");
		driver.setSchemaStructs("db");

		// add required files
		GrtStringList files = new GrtStringList(driver);
		driver.setFiles(files);

		// set modules
		driver.setReverseEngineeringModule("ReverseEngineeringAccess");
		driver.setMigrationModule("MigrationAccess");
		driver.setTransformationModule("");

		// set driver parameters
		JdbcDriverParameterList jdbcParams = new JdbcDriverParameterList();
		driver.setParameters(jdbcParams);

		JdbcDriverParameter param = GetJdbcDriverParameter(owner,
				"databaseFile", "Database File:", "MS Access database file.",
				"file", 1, 360);

		GrtStringHashMap paramTypeDetail = new GrtStringHashMap();
		paramTypeDetail.add("fileType", "MS Access Files");
		paramTypeDetail.add("fileExtension", "mdb");
		paramTypeDetail.add("fileOpenDialogCaption", "Open MS Access File ...");
		param.setParamTypeDetails(paramTypeDetail);

		jdbcParams.add(param);

		jdbcParams.add(GetJdbcDriverParameter(owner, "username", "Username:",
				"Name of the user to connect with.", "string", 2));

		jdbcParams.add(GetJdbcDriverParameter(owner, "password", "Password:",
				"The user's password.", "password", 3));

		// check if driver is installed
		driver.setIsInstalled(driverIsInstalled(driver));

		return driver;
	}

	private static JdbcDriverParameter GetJdbcDriverParameter(Object owner,
			String name, String caption, String desc, String paramType, int row) {
		return GetJdbcDriverParameter(owner, name, caption, desc, paramType,
				row, 218);
	}

	private static JdbcDriverParameter GetJdbcDriverParameter(Object owner,
			String name, String caption, String desc, String paramType,
			int row, int width) {
		JdbcDriverParameter jdbcParam = new JdbcDriverParameter(owner);
		jdbcParam.setName(name);
		jdbcParam.setCaption(caption);
		jdbcParam.setDescription(desc);
		jdbcParam.setParamType(paramType);
		jdbcParam.setLayoutRow(row);
		jdbcParam.setLayoutWidth(width);

		return jdbcParam;
	}

	private static void addJdbcDriverParameterDefaults(Object owner,
			JdbcDriverParameterList jdbcParams, int startRow) {
		jdbcParams.add(GetJdbcDriverParameter(owner, "host", "Hostname:",
				"Name or IP address of the server machine", "string", startRow,
				118));

		jdbcParams.add(GetJdbcDriverParameter(owner, "port", "Port:",
				"TCP/IP port", "int", startRow, 46));

		jdbcParams.add(GetJdbcDriverParameter(owner, "username", "Username:",
				"Name of the user to connect with.", "string", startRow + 1));

		jdbcParams.add(GetJdbcDriverParameter(owner, "password", "Password:",
				"The user's password.", "password", startRow + 2));
	}

	private static int driverIsInstalled(JdbcDriver driver) {
		int res = 0;

		try {
			if (Class.forName(driver.getClassName()) != null)
				res = 1;
		} catch (ClassNotFoundException e) {
			// ignore exception
		}

		return res;
	}
}