/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */


#include "MGImageCheckButton.h"


MGImageCheckButton::MGImageCheckButton(const Glib::RefPtr<Gdk::Pixbuf> &on_img,
                                       const Glib::RefPtr<Gdk::Pixbuf> &off_img)
  : _state(false), _on_img(on_img), _off_img(off_img)
{
  set_size_request(on_img->get_width()+4, on_img->get_height()+4);

  signal_expose_event().connect(SigC::slot(*this,&MGImageCheckButton::on_expose));
  signal_button_press_event().connect(SigC::slot(*this,&MGImageCheckButton::on_button_press));
  
  add_events(Gdk::BUTTON_RELEASE_MASK|Gdk::BUTTON_PRESS_MASK);
}


bool MGImageCheckButton::on_expose(GdkEventExpose *ev)
{  
  get_window()->draw_pixbuf(get_style()->get_fg_gc(Gtk::STATE_NORMAL), 
                            _state?_on_img:_off_img, 0, 0, 
                            (get_width()-_on_img->get_width())/2, 2,
                            -1, -1, Gdk::RGB_DITHER_NORMAL,
                            0, 0);
  return true;
}


bool MGImageCheckButton::on_button_press(GdkEventButton *ev)
{   
  _state = !_state;
  
  toggled();
  
  return true;
}


void MGImageCheckButton::set_active(bool flag)
{
  _state= flag;
  toggled();
}


void MGImageCheckButton::toggled()
{
  queue_draw();
  _signal_toggled.emit();
}

