#include <qvbox.h>
#include <qlabel.h>
#include <qtooltip.h>
#include <qmenubar.h>
#include <qmessagebox.h>
#include <qvaluelist.h>
#include <qpixmap.h>
#include <qstatusbar.h>
#include <qscrollview.h>

#include "mainwindow.h"
#include "mdiwindow.h"
#include "resource.h"

#include "window.xpm"

void MainWindow::make_layout()
{	
	make_menubar();

	make_central_widget();

	make_toolbar();

	make_statusbar();
}

void MainWindow::make_central_widget()
{
	QVBox *l = new QVBox(this);
	l->setFrameStyle(QFrame::StyledPanel | QFrame::Sunken);
	work_space = new XWorkspace(l);
	setCentralWidget(l);

	statusBar()->message(tr("Ready..."), 3000);
	
	//work_space->setBackgroundPixmap(QPixmap(background_xpm));

	setIcon(QPixmap(window_xpm));
}

void MainWindow::make_statusbar()
{
	statusBar();

	statusBar()->message(tr("Ready..."), 3000);
}

void MainWindow::make_toolbar()
{
	toolbar = new QToolBar(this,"");
	addToolBar(toolbar, QMainWindow::Top, TRUE);
	
	database = new QComboBox(toolbar, "");
	database->setFixedWidth(65);
	database->setFixedHeight(20);

	query = new QComboBox(TRUE, toolbar, "");
	query->setFixedHeight(20);
	query->setAutoCompletion(TRUE);	
	query->setInsertionPolicy(QComboBox::NoInsertion);
	query->setDuplicatesEnabled(FALSE);

	set_base_color(query,QColor(0xce,0xc6,0xbd));
	set_base_color(database,QColor(0xce,0xc6,0xbd));

	QToolTip::add(database, tr("Select database"));
	QToolTip::add(query, tr("Enter query and press return."));

	toolbar->setStretchableWidget(query);
}

void MainWindow::make_menubar()
{
	QPopupMenu *l;

	l = new QPopupMenu();
	l->setCaption(tr("File"));	
	l->insertTearOffHandle(TOOLBAR_TEAROFF);	
	//l->insertItem(tr("&Connect"),this,SLOT(slot_connect()), CTRL+Key_C, TOOLBAR_CONNECT);
	l->insertItem(tr("&Open"),this,SLOT(slot_connect()), CTRL+Key_O, TOOLBAR_OPEN);
	l->insertItem(tr("&New"),this,SLOT(slot_connect_new()), CTRL+Key_N, TOOLBAR_NEW);
	//l->insertItem(tr("&Disconnect"),this,SLOT(slot_disconnect()), CTRL+Key_D, TOOLBAR_DISCONNECT);
	l->insertItem(tr("&Close"),this,SLOT(slot_disconnect()), CTRL+Key_C, TOOLBAR_CLOSE);
	l->insertSeparator(); 
	l->insertItem(tr("E&xit"),this,SLOT(slot_exit()), CTRL+Key_X, TOOLBAR_EXIT);
	menuBar()->insertItem(tr("&File"), l);

	l = new QPopupMenu();
	l->setCaption(tr("Edit"));	
	l->insertTearOffHandle(TOOLBAR_TEAROFF);	
	l->insertItem(tr("&Find"),this,SLOT(slot_find()), CTRL+Key_F, TOOLBAR_FIND);
	menuBar()->insertItem(tr("&Edit"), l);

	/*
	l = new QPopupMenu();
	l->setCaption(tr("Window"));	
	l->insertTearOffHandle(TOOLBAR_TEAROFF);	
	l->insertItem(tr("&Toolbar"),this,SLOT(slot_hide_toolbar()),0,TOOLBAR_TOOLBAR);
	l->insertItem(tr("&Statusbar"),this,SLOT(slot_hide_statusbar()),0,TOOLBAR_STATUSBAR);
	l->setItemChecked(TOOLBAR_TOOLBAR,TRUE);
	l->setItemChecked(TOOLBAR_STATUSBAR,TRUE);
	menuBar()->insertItem(tr("&View"), l);
	*/

	l =new QPopupMenu();
	l->setCaption(tr("Style"));	
	l->insertTearOffHandle(TOOLBAR_TEAROFF);	
	l->insertItem(tr("&Windows"),this,SLOT(slot_windows()),0,TOOLBAR_WINDOWS);
	l->insertItem(tr("&CDE"),this,SLOT(slot_cde()),0,TOOLBAR_CDE);
	l->insertItem(tr("&Motif"),this,SLOT(slot_motif()),0,TOOLBAR_MOTIF);
	l->insertItem(tr("Motif Plus"),this,SLOT(slot_motif_plus()),0,TOOLBAR_MOTIF_PLUS);
	l->insertItem(tr("&Platinum"),this,SLOT(slot_platinum()),0,TOOLBAR_PLATINUM);
	l->insertItem(tr("&SGI"),this,SLOT(slot_sgi()),0,TOOLBAR_SGI);
	l->insertItem(tr("&JFC"),this,SLOT(slot_jfc()),0,TOOLBAR_JFC);


	//l->insertItem(tr("&NeXTSTEP"),this,SLOT(slot_nextstep()),0,TOOLBAR_NEXTSTEP);
	//l->setItemChecked(TOOLBAR_WINDOWS, TRUE);
	menuBar()->insertItem(tr("&Style"), l);

	l = new QPopupMenu();
	l->setCaption(tr("MySQL"));	
	l->insertTearOffHandle(TOOLBAR_TEAROFF);	
	l->insertItem(tr("&Schema"),this,SLOT(slot_schema_window()), 0, TOOLBAR_SCHEMA);
	l->insertItem(tr("&User"),this,SLOT(slot_user(int)), 0, TOOLBAR_USER);	
	l->insertItem(tr("&Privilege"),this,SLOT(slot_privilege()), 0, TOOLBAR_PRIVILEGE);	
	l->insertItem(tr("T&able"),this,SLOT(slot_table()), 0, TOOLBAR_TABLE);	
	l->insertItem(tr("&Query"),this,SLOT(slot_query_window()), 0, TOOLBAR_QUERY);
	l->insertItem(tr("&Process"),this,SLOT(slot_process()), 0, TOOLBAR_PROCESSLIST);
	l->insertItem(tr("&Xport"),this,SLOT(slot_xport()), 0, TOOLBAR_XPORT);
	//l->insertItem(tr("&Status"),this,SLOT(slot_status()), 0, TOOLBAR_STATUS);
	//l->insertItem(tr("&Variables"),this,SLOT(slot_variable()), 0, TOOLBAR_VARIABLES);
	l->insertItem(tr("P&assword"),this,SLOT(slot_password()), 0, TOOLBAR_PASSWORD);
	//l->insertItem(tr("P&ing"),this,SLOT(slot_ping()), 0, TOOLBAR_PING);
	l->insertItem(tr("&Edit"),this,SLOT(slot_script_edit()), 0, TOOLBAR_EDIT);

	l->insertItem(tr("&Script"),this,SLOT(slot_script_run()), 0, TOOLBAR_SCRIPT);
	l->insertItem(tr("&Flush"), this, SLOT(slot_flush()), 0, TOOLBAR_FLUSH);
	//l->insertItem(tr("&Log"),this,SLOT(slot_log()), 0, TOOLBAR_LOG);
	//l->insertItem(tr("&Shutdown"),this,SLOT(slot_shutdown()), 0, TOOLBAR_SHUTDOWN);
	
	menuBar()->insertItem(tr("&MySQL"), l);
	
	l = new QPopupMenu();
	l->setCaption(tr("Tools"));	
	l->insertTearOffHandle(TOOLBAR_TEAROFF);	
	l->insertItem(tr("&Toolbar"),this,SLOT(slot_hide_toolbar()),0,TOOLBAR_TOOLBAR);
	l->insertItem(tr("&Statusbar"),this,SLOT(slot_hide_statusbar()),0,TOOLBAR_STATUSBAR);
	l->insertSeparator();
	
	l->setItemChecked(TOOLBAR_TOOLBAR,TRUE);
	l->setItemChecked(TOOLBAR_STATUSBAR,TRUE);
	l->insertItem(tr("Cl&ose"),this,SLOT(slot_close_window()), 0, TOOLBAR_CLOSE_);
	l->insertItem(tr("Close &all"),this,SLOT(slot_close_windows()), 0, TOOLBAR_CLOSE_ALL);
	l->insertSeparator();
	//l->insertItem(tr("&Save history"), this, SLOT(slot_save_history()), 0, TOOLBAR_SAVE_HISTORY);
	l->insertItem(tr("&Clear history"),this,SLOT(slot_clear_history()), 0, TOOLBAR_CLEAR_HISTORY);
	l->insertSeparator();
	l->insertItem(tr("&Configure..."),this,SLOT(slot_xonfigure()), 0, TOOLBAR_XONFIGURE);
	menuBar()->insertItem(tr("&Tools"), l);
	
	l = new QPopupMenu();	 	
	l->setCaption(tr("Help"));	
	l->insertTearOffHandle(TOOLBAR_TEAROFF);	
	l->insertItem(tr("&About..."),this,SLOT(about()), Key_F1, TOOLBAR_ABOUT);
	l->insertItem(tr("About &Qt..."),this,SLOT(aboutQt()), 0, TOOLBAR_QT);
	menuBar()->insertItem(tr("&Help"), l);
	menuBar()->setDefaultUp(FALSE);
}

