#include "mainwindow.h"
#include <qmessagebox.h>
#include <qinputdialog.h>
#include <qlistview.h>
#include "db.xpm"

void MainWindow::slot_create_database(int)
{
	bool si = FALSE;
	
	QString text = QInputDialog::getText(tr("MySQL Navigator"), tr("Please enter database name you will create."), QString::null, &si, this );
	
	if(si && !text.isEmpty())
	{
		if((mysql_create_db(&mysql, text.latin1())))
		{
			QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
			slot_error();
		}
		else
		{
			slot_database();
			//emit signal_schema();
			QListViewItem *database = new QListViewItem(dummy, text); 
			database->setPixmap(0, QPixmap(db_xpm));
			QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Database ")) + text + QString(tr(" is successfully created.")));
			
			mysql_reload(&mysql);

		}
	}
	else
	{
	}
}

void MainWindow::slot_delete_database(int)
{
	QListViewItem *database = (QListViewItem *)dummy;

	QString sql = database->text(0);

	if(database == NULL)
	{
		return;
	}

	if(sql == QString("mysql"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("mysql database cannot be deleted"));
	}
	else
	{
		int l = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you really want to delete this database?"), tr("Yes"), tr("No"));
		
		if(l == 1)
		{
			return;
		}
		
		if((mysql_drop_db(&mysql, sql)))
		{
			QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
			slot_error();
		}
		else
		{
			slot_database();
			delete dummy;
			//emit signal_schema();
			QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Database ")) + sql + QString(tr(" is successfully deleted.")));

			mysql_reload(&mysql);
		}
	}

}
