#include "mainwindow.h"
#include "field.h"
#include "mdiwindow.h"

#include <qmessagebox.h>
#include <qlistview.h>
#include <qmenubar.h>

void MainWindow::slot_create_field(int)
{
	QListViewItem *table = (QListViewItem *)dummy;
	
	if(table == NULL)
	{
		return;
	}
	
	MDIWindow* l = new MDIWindow(work_space, 0, WDestructiveClose);
  
	Field *sql = new Field(&mysql, FIELD_CREATE, table->parent()->text(0), table->text(0), QString(""), l);

	connect(sql, SIGNAL(signal_error()), this, SLOT(slot_error()));
	connect(sql, SIGNAL(signal_schema()), this, SLOT(slot_schema()));

	l->setCentralWidget(sql);
	
	l->setFixedSize(221, 355 + 35);

	l->setCaption(tr("Create field"));

	QPopupMenu *l_ = new QPopupMenu();
	l_->insertItem(tr("&Fire"), sql, SLOT(slot_fire()), CTRL+Key_F);
	l_->insertSeparator();
	l_->insertItem(tr("&Close"), sql, SLOT(slot_close()), CTRL+Key_C);
	l->menuBar()->insertItem(tr("&File"), l_);

	l_ = new QPopupMenu();
	l_->insertItem(tr("&Clear"), sql, SLOT(slot_clear()));
	l->menuBar()->insertItem(tr("&Edit"), l_);
	
	l_ = new QPopupMenu();
	l_->insertItem(tr("&About..."), sql, SLOT(slot_about()), Key_F1);
	l->menuBar()->insertItem(tr("&Help"), l_);

	l->show();
}

void MainWindow::slot_change_field(int)
{
	QListViewItem *field = (QListViewItem *)dummy;
	
	if(field == NULL)
	{
		return;
	}
	
	MDIWindow* l = new MDIWindow(work_space, 0, WDestructiveClose);
  
	Field *sql = new Field(&mysql, FIELD_CHANGE, field->parent()->parent()->text(0), field->parent()->text(0), field->text(0), l);

	connect(sql, SIGNAL(signal_error()), this, SLOT(slot_error()));
	connect(sql, SIGNAL(signal_schema()), this, SLOT(slot_schema()));

	l->setCentralWidget(sql);

	l->setFixedSize(221, 355 + 35);

	l->setCaption(tr("Change field - ") + field->text(0));
	
	QPopupMenu *l_ = new QPopupMenu();
	l_->insertItem(tr("&Fire"), sql, SLOT(slot_fire()), CTRL+Key_F);
	l_->insertSeparator();
	l_->insertItem(tr("&Close"), sql, SLOT(slot_close()), CTRL+Key_C);
	l->menuBar()->insertItem(tr("&File"), l_);

	l_ = new QPopupMenu();
	l_->insertItem(tr("&Clear"), sql, SLOT(slot_clear()));
	l->menuBar()->insertItem(tr("&Edit"), l_);
	
	l_ = new QPopupMenu();
	l_->insertItem(tr("&About..."), sql, SLOT(slot_about()), Key_F1);
	l->menuBar()->insertItem(tr("&Help"), l_);

	l->show();
}

void MainWindow::slot_modify_field(int)
{
	QListViewItem *field = (QListViewItem *)dummy;
	
	if(field == NULL)
	{
		return;
	}
	
	MDIWindow* l = new MDIWindow(work_space, 0, WDestructiveClose);
  
	Field *sql = new Field(&mysql, FIELD_MODIFY, field->parent()->parent()->text(0), field->parent()->text(0), field->text(0), l);

	connect(sql, SIGNAL(signal_error()), this, SLOT(slot_error()));
	connect(sql, SIGNAL(signal_schema()), this, SLOT(slot_schema()));

	l->setCentralWidget(sql);

	l->setFixedSize(221, 355 + 35);

	l->setCaption(tr("Modify field - ") + field->text(0));
	
	QPopupMenu *l_ = new QPopupMenu();
	l_->insertItem(tr("&Fire"), sql, SLOT(slot_fire()), CTRL+Key_F);
	l_->insertSeparator();
	l_->insertItem(tr("&Close"), sql, SLOT(slot_close()), CTRL+Key_C);
	l->menuBar()->insertItem(tr("&File"), l_);

	l_ = new QPopupMenu();
	l_->insertItem(tr("&Clear"), sql, SLOT(slot_clear()));
	l->menuBar()->insertItem(tr("&Edit"), l_);
	
	l_ = new QPopupMenu();
	l_->insertItem(tr("&About..."), sql, SLOT(slot_about()), Key_F1);
	l->menuBar()->insertItem(tr("&Help"), l_);

	l->show();

}

void MainWindow::slot_delete_field(int)
{
	QListViewItem *field = (QListViewItem *)dummy;

	if(field == NULL)
	{
		return;
	}

	QString sql = field->text(0);
	QString database = field->parent()->parent()->text(0);
	QString table = field->parent()->text(0);

	if(database == QString("mysql"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Field in mysql database cannot be deleted"));
		return;
	}

	if(mysql_select_db(&mysql, database.latin1()))
	{
		slot_error();
		return;
	}

	QString query;

	query.sprintf("alter table %s drop %s", table.latin1(), sql.latin1());

	int l = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you really want to delete this field?"), tr("Yes"), tr("No"));
		
	if(l == 1)
	{
		return;
	}


	if((mysql_query(&mysql, query.latin1())))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
		slot_error();
	}
	else
	{
		//emit signal_schema();
		delete dummy;
		QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Field ")) + sql + "@" + table + "@" + database + QString(tr(" is successfully deleted.")));
		mysql_reload(&mysql);
	}
}

void MainWindow::slot_delete_primary(int)
{
	QListViewItem *field = (QListViewItem *)dummy;

	if(field == NULL)
	{
		return;
	}

	QString sql = field->text(0);
	QString database = field->parent()->parent()->text(0);
	QString table = field->parent()->text(0);

	if(database == QString("mysql"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Primary key in mysql database cannot be deleted"));
		return;
	}

	if(mysql_select_db(&mysql, database.latin1()))
	{
		slot_error();
		return;
	}

	QString query;

	query.sprintf("alter table %s drop primary key", table.latin1());
	//debug(query.latin1());

	int l = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you really want to delete this primary key?"), tr("Yes"), tr("No"));
		
	if(l == 1)
	{
		return;
	}
	
	if((mysql_query(&mysql, query.latin1())))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
		slot_error();
	}
	else
	{
		emit signal_schema();
		QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Primary key")) + "@" + table + "@" + database + QString(tr(" is successfully deleted.")));
		mysql_reload(&mysql);
	}
}

void MainWindow::slot_delete_index(int)
{
	QListViewItem *field = (QListViewItem *)dummy;

	if(field == NULL)
	{
		return;
	}

	QString sql = field->text(0);
	QString database = field->parent()->parent()->text(0);
	QString table = field->parent()->text(0);

	if(database == QString("mysql"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Index in mysql database cannot be deleted"));
		return;
	}

	if(mysql_select_db(&mysql, database.latin1()))
	{
		slot_error();
		return;
	}

	QString query;

	query.sprintf("alter table %s drop index %s", table.latin1(), sql.latin1());
	
	//debug(query.latin1());

	int l = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you really want to delete this index?"), tr("Yes"), tr("No"));
		
	if(l == 1)
	{
		return;
	}

	if((mysql_query(&mysql, query.latin1())))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
		slot_error();
	}
	else
	{
		emit signal_schema();
		QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Index")) + "@" + sql +"@" + table + "@" + database + QString(tr(" is successfully deleted.")));
		mysql_reload(&mysql);
	}
}

void MainWindow::slot_delete_unique(int)
{
}

void MainWindow::slot_create_primary(int)
{
	QListViewItem *field = (QListViewItem *)dummy;

	if(field == NULL)
	{
		return;
	}

	QString sql = field->text(0);
	QString database = field->parent()->parent()->text(0);
	QString table = field->parent()->text(0);

	if(database == QString("mysql"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Can't create primary key in mysql database"));
		return;
	}

	if(mysql_select_db(&mysql, database.latin1()))
	{
		slot_error();
		return;
	}

	QString query;

	query.sprintf("alter table %s add primary key(%s)", table.latin1(), sql.latin1());
	
	//debug(query.latin1());

	if((mysql_query(&mysql, query.latin1())))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
		slot_error();
	}
	else
	{
		emit signal_schema();
		QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Primary key")) + "@" + sql +"@" + table + "@" + database + QString(tr(" is successfully created.")));
		mysql_reload(&mysql);
	}
}

void MainWindow::slot_create_unique(int)
{
	QListViewItem *field = (QListViewItem *)dummy;

	if(field == NULL)
	{
		return;
	}

	QString sql = field->text(0);
	QString database = field->parent()->parent()->text(0);
	QString table = field->parent()->text(0);

	if(database == QString("mysql"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Can't create unique index in mysql database"));
		return;
	}

	if(mysql_select_db(&mysql, database.latin1()))
	{
		slot_error();
		return;
	}

	QString query;

	query.sprintf("alter table %s add unique(%s)", table.latin1(), sql.latin1());
	
	//debug(query.latin1());

	if((mysql_query(&mysql, query.latin1())))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
		slot_error();
	}
	else
	{
		emit signal_schema();
		QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Unique index")) + "@" + sql +"@" + table + "@" + database + QString(tr(" is successfully create.")));
		mysql_reload(&mysql);
	}
}

void MainWindow::slot_create_index(int)
{
	QListViewItem *field = (QListViewItem *)dummy;

	if(field == NULL)
	{
		return;
	}

	QString sql = field->text(0);
	QString database = field->parent()->parent()->text(0);
	QString table = field->parent()->text(0);

	if(database == QString("mysql"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Can't create index in mysql database"));
		return;
	}

	if(mysql_select_db(&mysql, database.latin1()))
	{
		slot_error();
		return;
	}

	QString query;

	query.sprintf("alter table %s add index(%s)", table.latin1(), sql.latin1());
	
	//debug(query.latin1());

	if((mysql_query(&mysql, query.latin1())))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
		slot_error();
	}
	else
	{
		emit signal_schema();
		QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Index")) + "@" + sql +"@" + table + "@" + database + QString(tr(" is successfully created.")));
		mysql_reload(&mysql);
	}

}


