#include "mainwindow.h"
#include "mdiwindow.h"
#include "script.h"
#include "edit.h"
#include <qpixmap.h>

void MainWindow::slot_script_run()
{
	if(!flag)
	{
		return;	
	}
		
	MDIWindow* window = new MDIWindow(work_space, 0, WDestructiveClose);

	window->setFixedSize(371,173);
	
	Script *script = new Script(&mysql, window);

	connect(script, SIGNAL(signal_error(const QString &, const QString &)), this, SLOT(slot_error(const QString &, const QString &)));
	connect(script, SIGNAL(signal_schema()), this, SLOT(slot_schema()));

    window->setCentralWidget(script);
			 
    window->setCaption(tr("Script"));

	window->show();
}

void MainWindow::slot_script_edit()
{
	Edit *edit = new Edit(work_space,0,WDestructiveClose);

	if(global.background.flag)
	{
		edit->slot_display_background(global.background.file);
	}
	else
	{
		edit->slot_display_background("");
	}

	connect(this, SIGNAL(signal_display_background(const QString &)), edit, SLOT(slot_display_background(const QString &)));

	edit->setCaption(tr("Edit"));
	edit->resize(500,400);	
	edit->show();
}
