#include "multilinelistviewitem.h"

MultiLineListViewItem::MultiLineListViewItem(QListView *parent)
	: QListViewItem(parent)
{
}

MultiLineListViewItem::MultiLineListViewItem(QListView *parent, QListViewItem *sibling)
	: QListViewItem(parent, sibling)
{
}


MultiLineListViewItem::MultiLineListViewItem(QListView *parent, QString string)
	: QListViewItem(parent, string)
{
}

MultiLineListViewItem::~MultiLineListViewItem()
{
}

void MultiLineListViewItem::set_height(int height)
{
	_height = height;
	
	setHeight(_height);
}

void MultiLineListViewItem::setup()
{
	QListViewItem::setup();

	setHeight(_height);
}

void MultiLineListViewItem::paintCell(QPainter *si,const QColorGroup &color,int column,int width,int alignment)
{
	QListViewItem::paintCell(si,color,column,width,alignment );

	 int x = width - 1;
	 int y = height() - 1;

	 si->setPen(Qt::black);
	 si->setPen(QPen(QColor(210,210,210),1));
	 si->drawLine(0, 0, 0, height());         
	 si->drawLine(0, y, x, y);
}
