#ifndef QUERYTABLE_H
#define QUERYTABLE_H

#include <qtable.h>
#include <mysql.h>

#define SQL_ERROR		-1
#define SQL_NOSCHEMA	0
#define SQL_SCHEMA		1	
#define SQL_SIMPLE		2		

class QueryTable : public QTable
{
Q_OBJECT

public:
	QueryTable(MYSQL *,QWidget *parent);
	~QueryTable();

	void set_sql(const QString &, const QString &);
	int execute();

public slots:
	void slot_clear();
	void slot_save();
	void slot_close();
	void slot_about();

private:
	QString database;
	QString sql;
	MYSQL *mysql;
	MYSQL_RES *result;
	MYSQL_ROW row; 
	MYSQL_FIELD *field;

signals:
	void signal_error();
	void signal_error_log();

};

#endif
