#include <qmessagebox.h>
#include <qinputdialog.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qdatetime.h>
#include <qcursor.h>

#include <stdio.h>

#include "mainwindow.h"
#include "mdiwindow.h"
#include "schema.h"
#include "schemalistviewitem.h"
#include "field.h"
#include "loglistviewitem.h"

#include "include/sql.h"
#include "src/mysql/copy/copy.h"
#include "database.xpm"
#include "field.xpm"
#include "collapse.xpm"
#include "expand.xpm"

void MainWindow::slot_schema_clicked(QListViewItem *data)
{
	if(data == NULL)
	{
		return;
	}


	hay = data;


	bool flag = data->isOpen();
	data->setOpen(!flag);


	switch(((SchemaListViewItem *)data)->flag)
	{
		case FLAG_HOST:
			slot_query("", "show databases", "");
			break;
		case FLAG_DATABASE:
			slot_query("", QString("show tables from ") + data->text(0) , "");
			break;
		case FLAG_TABLE:
			slot_query(((SchemaListViewItem *)data)->database, QString("select * from ") + data->text(0) + " limit " + QString::number(option.from) + ", " + QString::number(option.to), "");
			break;

		case FLAG_DATABASE_ROOT:

			slot_create_database(0);

			break;

		case FLAG_USER_ROOT:

			slot_user_create();

			break;

		case FLAG_USER:

			slot_user_modify();

			break;

		case FLAG_FIELD:

			slot_change_field(0);

			break;

		case FLAG_KEY:

			slot_delete_key();

			break;
	}
}

void MainWindow::slot_schema_clicked(QListViewItem *data, const QPoint &, int)
{
	if(data == NULL)
	{
		return;
	}

	switch(((SchemaListViewItem *)data)->flag)
	{
		case FLAG_HOST:
		{
			// host	

			QPopupMenu *z = new QPopupMenu(this);


			z->insertItem(tr("Reload"), this, SLOT(slot_schema(int)));	
			z->insertSeparator();	
			
			QPopupMenu *s = new QPopupMenu();	
			s->insertItem(tr("Hosts"), this, SLOT(slot_flush_hosts(int)));
			s->insertItem(tr("Logs"), this, SLOT(slot_flush_logs(int)));
			s->insertItem(tr("Status"), this, SLOT(slot_flush_status(int)));
			s->insertItem(tr("Tables"), this, SLOT(slot_flush_tables(int)));

			s->insertItem(tr("Tables with Read Lock"), this, SLOT(slot_flush_tables2(int)));
			s->insertItem(tr("Privileges"), this, SLOT(slot_flush_privileges(int)));
			z->insertItem(tr("Flush"), s);	
			

			s = new QPopupMenu();	
			s->insertItem(tr("Ping"), this, SLOT(slot_ping()));	
			s->insertItem(tr("Status"), this, SLOT(slot_status()));	
			s->insertItem(tr("Variable"), this, SLOT(slot_variable()));	
			s->insertItem(tr("Shutdown"), this, SLOT(slot_shutdown()));	
			z->insertItem(tr("Server"), s);	


			hay = data;

			z->popup(QCursor::pos());
			
			break;
		}

		case FLAG_DATABASE_ROOT:

		{

			QPopupMenu *z = new QPopupMenu(this);



			z->insertItem(tr("Create database"), this, SLOT(slot_create_database(int)));	

			hay = data;

			z->popup(QCursor::pos());



			break;

		}
		case FLAG_DATABASE:
		{

			QPopupMenu *z = new QPopupMenu(this);


			// database
			z->insertItem(tr("Delete database"), this, SLOT(slot_delete_database(int)));	

			z->insertItem(tr("Xport database"), this, SLOT(slot_xport(int)));	

			z->insertSeparator();

			z->insertItem(tr("Execute query"), this, SLOT(slot_query2(int)));	
			//z->insertSeparator();

			//z->insertItem(tr("Create table"), this, SLOT(slot_create_table(int)));	

			hay = data;

			z->popup(QCursor::pos());

			break;
		}

		case FLAG_TABLE_ROOT:

		{

			QPopupMenu *z = new QPopupMenu(this);



			z->insertItem(tr("Create table"), this, SLOT(slot_create_table(int)));	



			hay = data;

			z->popup(QCursor::pos());



			break;

		}
		case FLAG_TABLE:
		{

			QPopupMenu *z = new QPopupMenu(this);


			// table
			QPopupMenu *s;
			

			z->insertItem(tr("List fields"), this, SLOT(slot_list_fields(int)));

			z->insertItem(tr("Unlist fields"), this, SLOT(slot_unlist_fields(int)));

			z->insertSeparator();
			z->insertItem(tr("Keys in table"),this,SLOT(slot_table_keys(int)));	
			z->insertItem(tr("Fields in table"), this,SLOT(slot_table_fields(int)));	
			z->insertItem(tr("Status in table"),this,SLOT(slot_table_status(int)));	
			z->insertItem(tr("Record in table"),this,SLOT(slot_table_records(int)));	
			z->insertSeparator();
			z->insertItem(tr("Delete table"), this, SLOT(slot_delete_table(int)));	
			z->insertItem(tr("Move table"), this, SLOT(slot_move_table(int)));	
			z->insertItem(tr("Copy table"), this, SLOT(slot_copy_table(int)));	

			z->insertItem(tr("Rename table"), this, SLOT(slot_rename_table(int)));	

			z->insertItem(tr("Truncate table"), this, SLOT(slot_truncate_table(int)));	
			z->insertSeparator();
			z->insertItem(tr("Optimize table"), this, SLOT(slot_optimize()));
			

			s = new QPopupMenu;
			s->insertItem(tr("Normal"), this, SLOT(slot_check_normal())); 
			s->insertItem(tr("Quick"), this, SLOT(slot_check_quick()));
			s->insertItem(tr("Fast"), this, SLOT(slot_ckeck_fast()));
			s->insertItem(tr("Changed"), this, SLOT(slot_check_changed()));
			s->insertItem(tr("Extended"), this, SLOT(slot_check_extended()));
			z->insertItem(tr("Check table"), s);
			
			z->insertItem(tr("Analyze table"), this, SLOT(slot_analyze()));
			

			s = new QPopupMenu;
			s->insertItem(tr("Normal"), this, SLOT(slot_repair_normal()));
			s->insertItem(tr("Quick"), this, SLOT(slot_repair_quick()));
			z->insertItem(tr("Repair table"), s);
			//z->insertSeparator();
			//z->insertItem(tr("Read lock"),this, SLOT(slot_read_lock_table(int)));	
			//z->insertItem(tr("Write lock"),this, SLOT(slot_write_lock(int)));	
			//z->insertItem(tr("Unlock"),this, SLOT(slot_unlock_table(int)));	
			//z->insertSeparator();
			//z->insertItem(tr("Create field"), this, SLOT(slot_create_field(int)));

			//z->insertItem(tr("Create key"), this, SLOT(slot_create_key(int)));
			hay = data;

			z->popup(QCursor::pos());


			break;

		}
		case FLAG_FIELD:
		{

			QPopupMenu *z = new QPopupMenu(this);



			z->insertItem(tr("Delete field"), this, SLOT(slot_delete_field(int)));
			z->insertItem(tr("Change field"), this, SLOT(slot_change_field(int)));
			z->insertItem(tr("Modify field"), this, SLOT(slot_modify_field(int)));
			//z->insertSeparator();	
			//z->insertItem(tr("Delete primary"), this, SLOT(slot_delete_primary(int)));
			//z->insertItem(tr("Delete index"), this, SLOT(slot_delete_index(int)));
			//z->insertSeparator();	
			//z->insertItem(tr("Create primary"), this, SLOT(slot_create_primary(int)));
			//z->insertItem(tr("Create unique"), this, SLOT(slot_create_unique(int)));
			//z->insertItem(tr("Create index"), this, SLOT(slot_create_index(int)));
			hay = data;

			z->popup(QCursor::pos());


			break;
		}

		case FLAG_USER_ROOT:

		{

			QPopupMenu *z = new QPopupMenu(this);



			z->insertItem(tr("Create user"), this, SLOT(slot_user_create()));

			hay = data;

			z->popup(QCursor::pos());



			break;

		}

		case FLAG_USER:

		{

			QPopupMenu *z = new QPopupMenu(this);



			z->insertItem(tr("Modify user"), this, SLOT(slot_user_modify()));

			z->insertItem(tr("Delete user"), this, SLOT(slot_user_delete()));

			z->insertSeparator();

			z->insertItem(tr("Modify password"), this, SLOT(slot_password_modify()));	

			hay = data;

			z->popup(QCursor::pos());



			break;

		}

		case FLAG_KEY_ROOT:

		{

			QPopupMenu *z = new QPopupMenu(this);

			z->insertItem(tr("Create key"), this, SLOT(slot_create_key(int)));

			hay = data;

			z->popup(QCursor::pos());

			break;

		}

		case FLAG_FIELD_ROOT:

		{

			QPopupMenu *z = new QPopupMenu(this);

			z->insertItem(tr("Create field"), this, SLOT(slot_create_field(int)));

			hay = data;

			z->popup(QCursor::pos());

			break;

		}

		case FLAG_KEY:

		{

			QPopupMenu *z = new QPopupMenu(this);



			z->insertItem(tr("Delete key"), this, SLOT(slot_delete_key()));

			hay = data;

			z->popup(QCursor::pos());

			break;

		}
	}
}

void MainWindow::slot_schema2()
{
	if(open == FALSE)
		return;
	
	MDIWindow* z = new MDIWindow(workspace, 0, WDestructiveClose);
	
	Schema *schema= new Schema(&mysql, host, user, z);

	connect((QListView *)schema,SIGNAL(rightButtonClicked(QListViewItem *, const QPoint &, int)),this,SLOT(slot_schema_clicked(QListViewItem *, const QPoint &, int)));
	connect((QListView *)schema,SIGNAL(doubleClicked(QListViewItem *)),this,SLOT(slot_schema_clicked(QListViewItem *)));

	connect(this, SIGNAL(signal_schema()), schema, SLOT(slot_schema()));

	schema->slot_schema();

	z->setCentralWidget(schema);
	
	z->setCaption(tr("Schema"));

	z->resize(300,workspace->height()-25);
	
	z->show();
}

void MainWindow::slot_schema()
{
	slot_database();
	emit signal_schema();
}

void MainWindow::slot_schema(int)
{
	slot_schema();
}

void MainWindow::slot_read_lock_table(int)
{
	QString sql;

	if(mysql_select_db(&mysql, ((SchemaListViewItem *)hay)->database.latin1()))
	{
		return;
	}

	sql.sprintf("LOCK TABLES %s READ", hay->text(0).latin1());

	if((SQL::sql_query(sql.latin1())))
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
}

void MainWindow::slot_read_local_lock_table(int)	
{	
	QString sql;

	if(mysql_select_db(&mysql, ((SchemaListViewItem *)hay)->database.latin1()))
	{
		return;
	}

	sql.sprintf("LOCK TABLES %s READ LOCAL", hay->text(0).latin1());

	if((SQL::sql_query(sql.latin1())))
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
}

void MainWindow::slot_write_lock(int)	
{
	QString sql;

	if(mysql_select_db(&mysql, ((SchemaListViewItem *)hay)->database.latin1()))
	{
		return;
	}

	sql.sprintf("LOCK TABLES %s WRITE", hay->text(0).latin1());

	if((SQL::sql_query(sql.latin1())))
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
}

void MainWindow::slot_low_priority_write_lock(int)	
{
	QString sql;

	if(mysql_select_db(&mysql, ((SchemaListViewItem *)hay)->database.latin1()))
	{
		return;
	}

	sql.sprintf("LOCK TABLES %s LOW_PRIORITY WRITE", hay->text(0).latin1());

	if((SQL::sql_query(sql.latin1())))
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
}

void MainWindow::slot_unlock_table(int)	
{
	QString sql;

	if(mysql_select_db(&mysql, ((SchemaListViewItem *)hay)->database.latin1()))
	{
		return;
	}

	sql.sprintf("UNLOCK TABLES");
	
	if((SQL::sql_query(sql.latin1())))
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
}


// database

void MainWindow::slot_table_in_database(int)

{

	slot_query("", QString("show tables from ") + hay->text(0) , "");

}



void MainWindow::slot_create_database(int)

{

	bool z = FALSE;

	

	QString sql = QInputDialog::getText(tr("MySQL Navigator"), tr("Please enter database name you will create."), QLineEdit::Normal, QString::null, &z, this );

	

	if(z && !sql.isEmpty())

	{

		if((mysql_create_db(&mysql, sql.latin1())))

		{

			QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));

		}

		else

		{

			slot_database();

			//emit signal_schema();

			SchemaListViewItem *database = new SchemaListViewItem((SchemaListViewItem *)hay, NULL, sql, FLAG_DATABASE); 

			database->setPixmap(0, QPixmap(database_xpm));

			//QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Database ")) + sql + QString(tr(" is successfully created.")));

			

			mysql_reload(&mysql);



		}

	}

	else

	{

	}

}



void MainWindow::slot_delete_database(int)

{

	QListViewItem *database = (QListViewItem *)hay;



	QString sql = database->text(0);



	if(database == NULL)

	{

		return;

	}



	if(sql == QString("mysql"))

	{

		QMessageBox::critical(this, tr("MySQL Navigator"), tr("mysql database cannot be deleted"));

	}

	else

	{

		int z = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you want to delete this database?"), tr("Yes"), tr("No"));

		

		if(z == 1)

		{

			return;

		}

		

		if((mysql_drop_db(&mysql, sql.latin1())))

		{

			QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));

		}

		else

		{

			slot_database();

			delete hay;

			//emit signal_schema();

			//QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Database ")) + sql + QString(tr(" is successfully deleted.")));



			mysql_reload(&mysql);

		}

	}



}



// field

void MainWindow::slot_create_field(int)

{

	QListViewItem *table = (QListViewItem *)hay;

	

	if(table == NULL)

	{

		return;

	}

	

	MDIWindow* s = new MDIWindow(workspace, 0, WDestructiveClose);

  

	Field *sql = new Field(&mysql, FIELD_CREATE, ((SchemaListViewItem *)table)->database, ((SchemaListViewItem *)hay)->table, QString(""), s);



	connect(sql, SIGNAL(signal_schema()), this, SLOT(slot_schema()));



	s->setCentralWidget(sql);

	

	s->setFixedSize(221, 355 + 35);



	s->setCaption(tr("Create field"));



	QPopupMenu *z = new QPopupMenu();

	z->insertItem(tr("&Fire"), sql, SLOT(slot_fire()), Key_F5);

	z->insertSeparator();

	z->insertItem(tr("Cl&ose"), sql, SLOT(slot_close()));

	s->menuBar()->insertItem(tr("&File"), z);



	z = new QPopupMenu();

	z->insertItem(tr("Cl&ear"), sql, SLOT(slot_clear()));

	s->menuBar()->insertItem(tr("&Tools"), z);

	

	//z = new QPopupMenu();

	//z->insertItem(tr("&About..."), sql, SLOT(slot_about()), Key_F1);

	//s->menuBar()->insertItem(tr("&Help"), z);



	s->show();

}



void MainWindow::slot_create_field()

{

	MDIWindow* s = new MDIWindow(workspace, 0, WDestructiveClose);

  

	Field *sql = new Field(&mysql, FIELD_CREATE, "", "", "", s);



	connect(sql, SIGNAL(signal_schema()), this, SLOT(slot_schema()));



	s->setCentralWidget(sql);

	

	s->setFixedSize(221, 355 + 35);



	s->setCaption(tr("Field"));



	QPopupMenu *z = new QPopupMenu();

	z->insertItem(tr("&Fire"), sql, SLOT(slot_fire()), Key_F5);

	z->insertSeparator();

	z->insertItem(tr("Cl&ose"), sql, SLOT(slot_close()));

	s->menuBar()->insertItem(tr("&File"), z);



	z = new QPopupMenu();

	z->insertItem(tr("Cl&ear"), sql, SLOT(slot_clear()));

	s->menuBar()->insertItem(tr("&Tools"), z);

	

	//z = new QPopupMenu();

	//z->insertItem(tr("&About..."), sql, SLOT(slot_about()), Key_F1);

	//s->menuBar()->insertItem(tr("&Help"), z);



	s->show();

}







void MainWindow::slot_change_field(int)

{

	SchemaListViewItem *field = (SchemaListViewItem *)hay;

	

	if(field == NULL)

	{

		return;

	}

	

	MDIWindow* s = new MDIWindow(workspace, 0, WDestructiveClose);

  

	Field *sql = new Field(&mysql, FIELD_CHANGE, field->database, field->table, field->text(0), s);



	connect(sql, SIGNAL(signal_schema()), this, SLOT(slot_schema()));



	s->setCentralWidget(sql);



	s->setFixedSize(221, 355 + 35);



	s->setCaption(tr("Change field - ") + field->text(0));

	

	QPopupMenu *z = new QPopupMenu();

	z->insertItem(tr("&Fire"), sql, SLOT(slot_fire()), Key_F5);

	z->insertSeparator();

	z->insertItem(tr("Cl&ose"), sql, SLOT(slot_close()));

	s->menuBar()->insertItem(tr("&File"), z);



	z = new QPopupMenu();

	z->insertItem(tr("Cl&ear"), sql, SLOT(slot_clear()));

	s->menuBar()->insertItem(tr("&Tools"), z);

	

	//z = new QPopupMenu();

	//z->insertItem(tr("&About..."), sql, SLOT(slot_about()), Key_F1);

	//s->menuBar()->insertItem(tr("&Help"), z);



	s->show();

}



void MainWindow::slot_modify_field(int)

{

	SchemaListViewItem *field = (SchemaListViewItem *)hay;

	

	if(field == NULL)

	{

		return;

	}

	

	MDIWindow* s = new MDIWindow(workspace, 0, WDestructiveClose);

  

	Field *sql = new Field(&mysql, FIELD_MODIFY, field->database, field->table, field->text(0), s);



	connect(sql, SIGNAL(signal_schema()), this, SLOT(slot_schema()));



	s->setCentralWidget(sql);



	s->setFixedSize(221, 355 + 35);



	s->setCaption(tr("Modify field - ") + field->text(0));

	

	QPopupMenu *z = new QPopupMenu();

	z->insertItem(tr("&Fire"), sql, SLOT(slot_fire()), Key_F5);

	z->insertSeparator();

	z->insertItem(tr("Cl&ose"), sql, SLOT(slot_close()));

	s->menuBar()->insertItem(tr("&File"), z);



	z = new QPopupMenu();

	z->insertItem(tr("Cl&ear"), sql, SLOT(slot_clear()));

	s->menuBar()->insertItem(tr("&Tools"), z);

	

	//z = new QPopupMenu();

	//z->insertItem(tr("&About..."), sql, SLOT(slot_about()), Key_F1);

	//s->menuBar()->insertItem(tr("&Help"), z);



	s->show();

}



void MainWindow::slot_delete_field(int)

{

	SchemaListViewItem *field = (SchemaListViewItem *)hay;



	if(field == NULL)

	{

		return;

	}

	

	QString sql = field->text(0);

	QString database = field->database;

	QString table = field->table;



	if(database == QString("mysql"))

	{

		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Field in mysql database cannot be deleted"));

		return;

	}



	if(mysql_select_db(&mysql, database.latin1()))

	{

		return;

	}



	QString query;



	query.sprintf("alter table %s drop %s", table.latin1(), sql.latin1());



	int z = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you want to delete this field?"), tr("Yes"), tr("No"));

		

	if(z == 1)

	{

		return;

	}



	if((SQL::sql_query(query.latin1())))

		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));

	else

	{

		delete hay;

		mysql_reload(&mysql);

	}

}



void MainWindow::slot_delete_primary(int)

{

	QListViewItem *field = (QListViewItem *)hay;



	if(field == NULL)

	{

		return;

	}



	QString sql = field->text(0);

	QString database = ((SchemaListViewItem *)hay)->database;

	QString table = ((SchemaListViewItem *)hay)->table;



	if(database == QString("mysql"))

	{

		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Primary key in mysql database cannot be deleted"));

		return;

	}



	if(mysql_select_db(&mysql, database.latin1()))

	{

		return;

	}



	QString query;



	query.sprintf("alter table %s drop primary key", table.latin1());

	//debug(query.latin1());



	int z = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you want to delete this primary key?"), tr("Yes"), tr("No"));

		

	if(z == 1)

	{

		return;

	}

	

	if((SQL::sql_query(query.latin1())))

		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));

	else

	{

		emit signal_schema();

		mysql_reload(&mysql);

	}

}



void MainWindow::slot_delete_index(int)

{

	QListViewItem *field = (QListViewItem *)hay;



	if(field == NULL)

	{

		return;

	}



	QString sql = field->text(0);

	QString database = ((SchemaListViewItem *)hay)->database;

	QString table = ((SchemaListViewItem *)hay)->table;



	if(database == QString("mysql"))

	{

		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Index in mysql database cannot be deleted"));

		return;

	}



	if(mysql_select_db(&mysql, database.latin1()))

	{

		return;

	}



	QString query;



	query.sprintf("alter table %s drop index %s", table.latin1(), sql.latin1());

	

	//debug(query.latin1());



	int z = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you want to delete this index?"), tr("Yes"), tr("No"));

		

	if(z == 1)

	{

		return;

	}



	if((SQL::sql_query(query.latin1())))

		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));

	else

	{

		emit signal_schema();

		mysql_reload(&mysql);

	}

}



void MainWindow::slot_delete_unique(int)

{

}



void MainWindow::slot_create_primary(int)

{

	QListViewItem *field = (QListViewItem *)hay;



	if(field == NULL)

	{

		return;

	}



	QString sql = field->text(0);

	QString database = ((SchemaListViewItem *)hay)->database;

	QString table = ((SchemaListViewItem *)hay)->table;



	if(database == QString("mysql"))

	{

		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Can't create primary key in mysql database"));

		return;

	}



	if(mysql_select_db(&mysql, database.latin1()))

	{

		return;

	}



	QString query;



	query.sprintf("alter table %s add primary key(%s)", table.latin1(), sql.latin1());

	

	//debug(query.latin1());



	if((SQL::sql_query(query.latin1())))

		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));

	else

	{

		emit signal_schema();

		mysql_reload(&mysql);

	}

}



void MainWindow::slot_create_unique(int)

{

	QListViewItem *field = (QListViewItem *)hay;



	if(field == NULL)

	{

		return;

	}



	QString sql = field->text(0);

	QString database = ((SchemaListViewItem *)hay)->database;

	QString table = ((SchemaListViewItem *)hay)->table;



	if(database == QString("mysql"))

	{

		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Can't create unique index in mysql database"));

		return;

	}



	if(mysql_select_db(&mysql, database.latin1()))

	{

		return;

	}



	QString query;



	query.sprintf("alter table %s add unique(%s)", table.latin1(), sql.latin1());

	

	//debug(query.latin1());



	if((SQL::sql_query(query.latin1())))

		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));

	else

	{

		emit signal_schema();

		mysql_reload(&mysql);

	}

}



void MainWindow::slot_create_index(int)

{

	QListViewItem *field = (QListViewItem *)hay;



	if(field == NULL)

	{

		return;

	}



	QString sql = field->text(0);

	QString database = ((SchemaListViewItem *)hay)->database;

	QString table = ((SchemaListViewItem *)hay)->table;



	if(database == QString("mysql"))

	{

		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Can't create index in mysql database"));

		return;

	}



	if(mysql_select_db(&mysql, database.latin1()))

	{

		return;

	}



	QString query;



	query.sprintf("alter table %s add index(%s)", table.latin1(), sql.latin1());

	

	//debug(query.latin1());



	if((SQL::sql_query(query.latin1())))

		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));

	else

	{

		emit signal_schema();

		mysql_reload(&mysql);

	}



}



void MainWindow::slot_delete_key()

{

	int z = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you want to delete this key?"), tr("Yes"), tr("No"));

		

	if(z == 1)

	{

		return;

	}



	SchemaListViewItem *key = (SchemaListViewItem *)hay;



	if(key == NULL)

	{

		return;

	}



	if(key->database == QString("mysql"))

	{

		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Can't delete key in mysql database"));

		return;

	}



	if(mysql_select_db(&mysql, key->database.latin1()))

	{

		return;

	}



	QString query;



	if(key->text(0) == "PRIMARY")

		query.sprintf("alter table %s drop primary key", key->table.latin1());

	else

		query.sprintf("drop index %s on %s", key->text(0).latin1(), key->table.latin1());

	

	if((SQL::sql_query(query.latin1())))

		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));

	else

	{

		delete hay;

		hay = NULL;

	}

}



// host

void MainWindow::slot_flush_hosts(int)

{

	if(SQL::sql_query("flush hosts"))

		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));

}



void MainWindow::slot_flush_logs(int)

{

	if(SQL::sql_query("flush logs"))

		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));

}



void MainWindow::slot_flush_status(int)

{

	if(SQL::sql_query("flush status"))

		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));

}



void MainWindow::slot_flush_tables(int)

{

	if(SQL::sql_query("flush tables"))

		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));

}



void MainWindow::slot_flush_tables2(int)

{

	if(SQL::sql_query("flush tables with read lock"))

		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));

}



void MainWindow::slot_flush_privileges(int)

{

	if(SQL::sql_query("flush privileges"))

		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));

}



// table

void MainWindow::slot_table_records(int)

{

	slot_query(((SchemaListViewItem *)hay)->database, QString("select * from ") + ((QListViewItem *)hay)->text(0) + " limit " + QString::number(option.from) + ", " + QString::number(option.to), tr("Table"));

}



void MainWindow::slot_table_keys(int)

{

	slot_query(((SchemaListViewItem *)hay)->database, QString("show keys from ") + ((QListViewItem *)hay)->text(0), tr("Keys"));

}



void MainWindow::slot_table_fields(int)

{

	slot_query(((SchemaListViewItem *)hay)->database, QString("show fields from ") + ((QListViewItem *)hay)->text(0), tr("Fields"));

}



void MainWindow::slot_table_status(int)

{

	slot_query(((SchemaListViewItem *)hay)->database, QString("show table status like \'") + ((QListViewItem *)hay)->text(0) + QString("\'"), tr("Status"));

}



void MainWindow::slot_create_table(int)

{

	slot_table(((SchemaListViewItem *)hay)->database);

}



void MainWindow::slot_create_key(int)

{

	SchemaListViewItem *value = (SchemaListViewItem *)hay;

	slot_key(value->database, value->table);

}



void MainWindow::slot_rename_table(int)

{

	QListViewItem *table = (QListViewItem *)hay;



	if(table == NULL)

	{

		return;

	}



	QString sql = table->text(0);

	QString database = ((SchemaListViewItem *)hay)->database;



	if(database == QString("mysql"))

	{

		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Table in mysql database cannot be renamed."));

		return;

	}



	if(mysql_select_db(&mysql, database.latin1()))

	{

		return;

	}



	bool z = FALSE;

	

	QString target = QInputDialog::getText(tr("MySQL Navigator"), tr("Please enter table name you will rename."), QLineEdit::Normal, sql, &z, this );

	

	if(z && !target.isEmpty())

	{

	}

	else

	{

		return;

	}



	QString query;



	query.sprintf("rename table %s to %s", sql.latin1(), target.latin1());



	z = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you want to rename this table?"), tr("Yes"), tr("No"));

		

	if(z == 1)

	{

		return;

	}



	if((SQL::sql_query(query.latin1())))

		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));

	else

	{

		hay->setText(0, target);

		mysql_reload(&mysql);

	}

}



void MainWindow::slot_delete_table(int)

{

	QListViewItem *table = (QListViewItem *)hay;



	if(table == NULL)

	{

		return;

	}



	QString sql = table->text(0);

	QString database = ((SchemaListViewItem *)hay)->database;



	if(database == QString("mysql"))

	{

		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Table in mysql database cannot be deleted"));

		return;

	}



	if(mysql_select_db(&mysql, database.latin1()))

	{

		return;

	}



	QString query;



	query.sprintf("drop table %s", sql.latin1());



	int z = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you want to delete this table?"), tr("Yes"), tr("No"));

		

	if(z == 1)

		return;

	

	if((SQL::sql_query(query.latin1())))

		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));

	else

	{

		delete hay;

		mysql_reload(&mysql);

	}

}



void MainWindow::slot_truncate_table(int)

{

	QListViewItem *table = (QListViewItem *)hay;



	if(table == NULL)

		return;



	QString sql = table->text(0);

	QString database = ((SchemaListViewItem *)hay)->database;



	if(database == QString("mysql"))

	{

		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Table in mysql database cannot be truncated."));

		return;

	}



	if(mysql_select_db(&mysql, database.latin1()))

	{

		return;

	}



	QString query;



	query.sprintf("delete from %s", sql.latin1());



	int z = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you want to truncate this table?"), tr("Yes"), tr("No"));

		

	if(z == 1)

		return;

	

	if((SQL::sql_query(query.latin1())))

		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));

	else

	{

		emit signal_schema();

		mysql_reload(&mysql);

	}

}



void MainWindow::slot_optimize()

{

	slot_query(((SchemaListViewItem *)hay)->database, QString("optimize table ") + ((QListViewItem *)hay)->text(0), tr("Table"));

}



void MainWindow::slot_check_normal()

{

	slot_query(((SchemaListViewItem *)hay)->database, QString("check table ") + ((QListViewItem *)hay)->text(0), tr("Table"));

}



void MainWindow::slot_check_quick()

{

	slot_query(((SchemaListViewItem *)hay)->database, QString("check table ") + ((QListViewItem *)hay)->text(0) + QString(" type = quick"), tr("Table"));

}



void MainWindow::slot_ckeck_fast()

{

	slot_query(((SchemaListViewItem *)hay)->database, QString("check table ") + ((QListViewItem *)hay)->text(0) + QString(" type = fast"), tr("Table"));

}



void MainWindow::slot_check_changed()

{

	slot_query(((SchemaListViewItem *)hay)->database, QString("check table ") + ((QListViewItem *)hay)->text(0) + QString(" type = changed"), tr("Table"));

}



void MainWindow::slot_check_extended()

{

	slot_query(((SchemaListViewItem *)hay)->database, QString("check table ") + ((QListViewItem *)hay)->text(0) + QString(" type = extended"), tr("Table"));

}



void MainWindow::slot_analyze()

{

	slot_query(((SchemaListViewItem *)hay)->database, QString("analyze table ") + ((QListViewItem *)hay)->text(0), tr("Table"));

}



void MainWindow::slot_repair_normal()

{

	slot_query(((SchemaListViewItem *)hay)->database, QString("repair table ") + ((QListViewItem *)hay)->text(0), tr("Table"));

}



void MainWindow::slot_repair_quick()

{

	slot_query(((SchemaListViewItem *)hay)->database, QString("repair table ") + ((QListViewItem *)hay)->text(0) + QString(" type = quick"), tr("Table"));

}



void MainWindow::slot_list_fields(int)

{

	MYSQL_RES *result;

	MYSQL_FIELD *field;

	QString database;



	SchemaListViewItem *z;



	while((z = (SchemaListViewItem *)hay->firstChild()))

		delete z;



	database = ((SchemaListViewItem *)hay)->database;



	if(mysql_select_db(&mysql, database.latin1()))

		return;



	result = mysql_list_fields(&mysql,hay->text(0).latin1(),NULL);



	if(result == NULL)

		return;

	

	z = NULL;



	SchemaListViewItem *data = new SchemaListViewItem((SchemaListViewItem *)hay, z, "Field", FLAG_FIELD_ROOT, "", "");

	data->setOpen(TRUE);



	while((field = mysql_fetch_field(result)))

	{

		z = new SchemaListViewItem(data, z, field->name, FLAG_FIELD, database, hay->text(0));

		z->setPixmap(0, QPixmap(field_xpm));	

	}



	hay->setOpen(TRUE);

	

	struct table_value value;

	memset((void *)&value, 0, sizeof(struct table_value));



	QMap<QString, struct table_value> s = ((Schema *)hay->listView())->table_map.find(database).data();

	sprintf(value.table, "%s", hay->text(0).latin1());

	value.value = FLAG_EXPAND;

	s.replace(hay->text(0), value);

	((Schema *)hay->listView())->table_map.replace(database, s);

	

	hay->setText(1, "-");

	//hay->setText(1, QChar(0x91, 0x21));

	//hay->setPixmap(1, QPixmap(collapse_xpm));



	mysql_free_result(result);



	z = NULL;

	data = new SchemaListViewItem((SchemaListViewItem *)hay, z, "Key", FLAG_KEY_ROOT, database, hay->text(0));

	data->setOpen(TRUE);



	QMap<QString, bool> key;

	QMap<QString, bool>::Iterator s_;

	QString sql = "show keys from " + hay->text(0);



	if(SQL::sql_query(sql.latin1()))

	{

	}

	else

	{

		result = mysql_store_result(&mysql);



		if(result == NULL)

			return;



		while(MYSQL_ROW row = mysql_fetch_row(result))

			key.replace(row[2], TRUE);



		for(s_ = key.begin(); s_ != key.end(); s_++)

			z = new SchemaListViewItem(data, z, s_.key(), FLAG_KEY, database, hay->text(0));



		mysql_free_result(result);

	}

}



void MainWindow::slot_unlist_fields(int)

{

	QString database = ((SchemaListViewItem *)hay)->database;



	SchemaListViewItem *z;

	while((z = (SchemaListViewItem *)hay->firstChild()))

		delete z;



	QMap<QString, struct table_value> s = ((Schema *)hay->listView())->table_map.find(database).data();

	s.remove(hay->text(0));

	((Schema *)hay->listView())->table_map.replace(database, s);



	hay->setText(1, "+");

	//hay->setText(1, QChar(0x93, 0x21));

	//hay->setPixmap(1, QPixmap(expand_xpm));

}



void MainWindow::slot_move_table(int)
{
	MDIWindow* s = new MDIWindow(workspace, 0, WDestructiveClose);
	  
	s->setFixedSize(390, 135 + 25);
	
	Copy *copy = new Copy(s);
	copy->set_mode(M_MOVE);

	copy->slot_value(((SchemaListViewItem *)hay)->database, hay->text(0));

	connect(copy, SIGNAL(signal_schema()), this, SLOT(slot_schema()));

	s->setCaption(tr("Move table"));
    s->setCentralWidget(copy);
			 
	QPopupMenu *z = new QPopupMenu();
	z->insertItem(tr("&Fire"), copy, SLOT(slot_fire()), Key_F5);
	z->insertSeparator();	
	z->insertItem(tr("Cl&ose"), copy, SLOT(slot_close()));
	s->menuBar()->insertItem(tr("&File"), z);
	
	z = new QPopupMenu();
	z->insertItem(tr("Cl&ear"), copy, SLOT(slot_clear()));
	s->menuBar()->insertItem(tr("&Tools"), z);

	s->show();

	/*
	QListViewItem *table = (QListViewItem *)hay;



	if(table == NULL)

	{

		return;

	}



	QString sql = table->text(0);

	QString database = ((SchemaListViewItem *)hay)->database;



	if(database == QString("mysql"))

	{

		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Table in mysql database cannot be moved."));

		return;

	}



	if(mysql_select_db(&mysql, database.latin1()))

	{

		return;

	}



	bool z = FALSE;

	

	QString target = QInputDialog::getText(tr("MySQL Navigator"), tr("Please enter database name you will move."), QLineEdit::Normal, database, &z, this );

	

	if(z && !target.isEmpty())

	{

		if(database == target.stripWhiteSpace())

		{

			QMessageBox::critical(this, tr("MySQL Navigator"), tr("Please enter another database name."));

			return;

		}



		if(target == "mysql")

		{

			QMessageBox::critical(this, tr("MySQL Navigator"), tr("Table cannot be moved to mysql database."));

			return;

		}

	}

	else

	{

		return;

	}



	QString query;



	query.sprintf("alter table %s rename to %s.%s", sql.latin1(), target.latin1(), sql.latin1());



	z = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you want to move this table?"), tr("Yes"), tr("No"));

		

	if(z == 1)

	{

		return;

	}



	if((SQL::sql_query(query.latin1())))

	{

		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));

	}

	else

	{

		emit signal_schema();

		mysql_reload(&mysql);

	}
	*/

}

void MainWindow::slot_copy_table(int)
{
	MDIWindow* s = new MDIWindow(workspace, 0, WDestructiveClose);
	  
	s->setFixedSize(390, 135 + 25);
	
	Copy *copy = new Copy(s);
	copy->set_mode(M_COPY);

	copy->slot_value(((SchemaListViewItem *)hay)->database, hay->text(0));

	connect(copy, SIGNAL(signal_schema()), this, SLOT(slot_schema()));

	s->setCaption(copy->caption());
    s->setCentralWidget(copy);
			 
	QPopupMenu *z = new QPopupMenu();
	z->insertItem(tr("&Fire"), copy, SLOT(slot_fire()), Key_F5);
	z->insertSeparator();	
	z->insertItem(tr("Cl&ose"), copy, SLOT(slot_close()));
	s->menuBar()->insertItem(tr("&File"), z);
	
	z = new QPopupMenu();
	z->insertItem(tr("Cl&ear"), copy, SLOT(slot_clear()));
	s->menuBar()->insertItem(tr("&Tools"), z);

	s->show();

	/*
	QListViewItem *table = (QListViewItem *)hay;

	if(table == NULL)
	{
		return;
	}

	QString sql = table->text(0);

	QString database = ((SchemaListViewItem *)hay)->database;

	if(database == QString("mysql"))

	{

		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Table in mysql database cannot be moved."));

		return;

	}



	if(mysql_select_db(&mysql, database.latin1()))

	{

		return;

	}



	bool z = FALSE;

	

	QString target = QInputDialog::getText(tr("MySQL Navigator"), tr("Please enter database name you will move."), QLineEdit::Normal, database, &z, this );

	

	if(z && !target.isEmpty())

	{

		if(database == target.stripWhiteSpace())

		{

			QMessageBox::critical(this, tr("MySQL Navigator"), tr("Please enter another database name."));

			return;

		}



		if(target == "mysql")

		{

			QMessageBox::critical(this, tr("MySQL Navigator"), tr("Table cannot be moved to mysql database."));

			return;

		}

	}

	else

	{

		return;

	}



	QString query;



	query.sprintf("alter table %s rename to %s.%s", sql.latin1(), target.latin1(), sql.latin1());



	z = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you want to move this table?"), tr("Yes"), tr("No"));

		

	if(z == 1)

	{

		return;

	}



	if((SQL::sql_query(query.latin1())))

	{

		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));

	}

	else

	{

		emit signal_schema();

		mysql_reload(&mysql);

	}
	*/
}

