/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/**
 * @file myx_gc_model.cpp 
 * @brief Implementation of the model that manages the visual representation in the generic canvas.
 * 
 */

#ifdef _WINDOWS
  #include <windows.h>
#else
#endif // ifdef _WINDOWS

#include <gl/gl.h>
#include <gl/glu.h>

#include "myx_gc_figure.h"
#include "myx_gc_model.h"
#include "myx_gc_canvas.h"

//----------------------------------------------------------------------------------------------------------------------

CGCModel::CGCModel(CGenericCanvas* Controller)
{
  FCanvas = Controller;
  FRoot = new CFigure(this, -1);
}

//----------------------------------------------------------------------------------------------------------------------

CGCModel::~CGCModel(void)
{
  delete FRoot;
}

//----------------------------------------------------------------------------------------------------------------------

CGenericCanvas* CGCModel::GetController(void)
{
  return FCanvas;
}

//----------------------------------------------------------------------------------------------------------------------

CFigure* CGCModel::CreateFigure(char* Type, CFigure* Parent)
{
  // Find a predefined template list for the given type of figure. This might return -1 if the type name is not
  // registered, however the figure takes care for this case.
  GLuint TemplateList = FCanvas->FindTemplate(string(Type));
  CFigure* Figure = new CFigure(this, TemplateList);
  if (Parent == NULL)
    FRoot->AddChild(Figure);
  else
    Parent->AddChild(Figure);

  return Figure;
}

//----------------------------------------------------------------------------------------------------------------------

// Clears the entire model.
void CGCModel::Clear(void)
{
  FCanvas->BeginUpdate();
  FRoot->Clear();
  FCanvas->EndUpdate();
}

//----------------------------------------------------------------------------------------------------------------------

// Renders the entire model to the currently active rendering context.
void CGCModel::Render(void)
{
  FRoot->Render();
}

//----------------------------------------------------------------------------------------------------------------------

void CGCModel::ScaleV(const double Factor[3], bool Accumulative)
{
  FRoot->ScaleV(Factor, Accumulative);
}

//----------------------------------------------------------------------------------------------------------------------

void CGCModel::Scale(double Sx, double Sy, double Sz, bool Accumulative)
{
  FRoot->Scale(Sx, Sy, Sz, Accumulative);
}

//----------------------------------------------------------------------------------------------------------------------

void CGCModel::RotateV(double Angle, const double Axis[3])
{
  FRoot->RotateV(Angle, Axis);
}

//----------------------------------------------------------------------------------------------------------------------

void CGCModel::Rotate(double Angle, double Rx, double Ry, double Rz)
{
  FRoot->Rotate(Angle, Rz, Ry, Rz);
}

//----------------------------------------------------------------------------------------------------------------------

void CGCModel::TranslateV(const double Factor[3], bool Accumulative)
{
  FRoot->TranslateV(Factor, Accumulative);
}

//----------------------------------------------------------------------------------------------------------------------

void CGCModel::Translate(double Tx, double Ty, double Tz, bool Accumulative)
{
  FRoot->Translate(Tx, Ty, Tz, Accumulative);
}

//----------------------------------------------------------------------------------------------------------------------

